
' General predefined constant values for LabWindows instrument modules

CONST BUS = 20000                ' Trigger mode bus
CONST EXTERNAL = 20001           ' Trigger mode external
CONST INTERNAL = 20002           ' Trigger mode internal
CONST MANUAL = 20003             ' Trigger mode manual
CONST NO = 20004                 ' Used to indicate when turning something off
CONST YES = 20005                ' Used to indicate when turning something on
CONST ACTUAL.SET = 20008         ' When initializing do not set instrument
                                 ' settings explicitly
CONST DEFAULT.SET = 20009        ' When initializing set instrument settings
                                 ' explicitly
CONST END.OF.ARRAY = 24003

' Predefined values for generator drivers

CONST ARBITRARY = 23000          ' Arbitrary waveform
CONST CONT1 = 23001              ' Continuous burst or sweep mode 1
CONST CONT2 = 23002              ' Continuous burst or sweep mode 2
CONST CONT3 = 23023              ' Continuous burst or sweep mode 3
CONST CONTINUOUS = 23001         ' Continuous burst or sweep mode 1
CONST COSINE = 23003             ' Cosine waveform
CONST DBM = 23004                ' For specifying a value as dbm eg. amplitude
CONST HAVERSINE = 23005          ' Haversine waveform
CONST LINEAR = 23006             ' Sweep mode linear
CONST LOGARITHMIC = 23007        ' Sweep mode logarithmic
CONST NEG.PULSE = 23008          ' Negative pulse waveform
CONST NEG.SAWTOOTH = 23009       ' Negative sawtooth waveform
CONST POS.PULSE = 23010          ' Positive pulse waveform
CONST SAWTOOTH = 23020           ' Sawtooth waveform
CONST PP = 23012                 ' For specifying a value as peak peak eg.
                                 ' amplitude
CONST SINE = 23014               ' Sine waveform
CONST k..SINGLE = 23015          ' Single burst or sweep mode 1
CONST SINGLE1 = 23015            ' Single burst or sweep mode 1
CONST SINGLE2 = 23021            ' Single burst or sweep mode 2
CONST SINGLE3 = 23022            ' Single burst or sweep mode 3
CONST SQUARE = 23016             ' Square waveform

' Predefined values for multimeter drivers

CONST AUTOMATIC = 1.701412e+038  ' Automatic ranging
CONST CAPACITANCE = 22001        ' Capacitance function
CONST CURRENT.AC = 22002         ' Current AC function
CONST CURRENT.DC = 22003         ' Current DC function
CONST CURRENT.RMS = 22004        ' Current RMS function
CONST DIODE = 22005              ' Diode function
CONST HIGH = 22006               ' High indication for eg. setting speed of
                                 ' meter
CONST LOW = 22007                ' Low indication for eg. setting speed of
                                 ' meter
CONST MEDIUM = 22008             ' Medium indication for eg. setting speed of
                                 ' meter
CONST NORMAL = 22009             ' Normal indication for eg. setting speed of
                                 ' meter
CONST PERIOD.POS = 22021         ' Period measurement from positive edge to
                                 ' positive edge
CONST PERIOD.NEG = 22010         ' Period measurement from negative edge to
                                 ' negative edge
CONST PULSEWIDTH.POS = 22022     ' Period measurement from positive edge to
                                 ' negative edge
CONST PULSEWIDTH.NEG = 22011     ' Period measurement from negative edge to
                                 ' positive edge
CONST RESISTANCE.2W = 22012      ' Resistance 2 wire function
CONST RESISTANCE.4W = 22013      ' Resistance 4 wire function
CONST TEMPERATURE = 22014        ' Temperature function
CONST VOLT.AC = 22015            ' Voltage AC function
CONST VOLT.DC = 22016            ' Voltage DC function
CONST VOLT.PEAK.PEAK = 22017     ' Voltage Peak Peak function
CONST VOLT.RMS = 22018           ' Voltage RMS function
CONST VOLT.PEAK.POS = 22019      ' Maximum voltage function
CONST VOLT.PEAK.NEG = 22020      ' Minimum voltage function

' Predefined values for counter drivers

CONST AC = 21000                 ' AC coupling
CONST CHA = 21001                ' Channel A
CONST CHALL = 21002              ' All channels
CONST CHB = 21003                ' Channel B
CONST CHC = 21004                ' Channel C
CONST DC = 21005                 ' DC coupling
CONST DUTYFACTOR.A = 21006       ' Dutyfactor channel A
CONST DUTYFACTOR.B = 21007       ' Dutyfactor channel B
CONST DUTYFACTOR.C = 21008       ' Dutyfactor channel C
CONST DUTYFACTOR = 21061         ' Dutyfactor channel A
CONST FREQUENCY.A = 21062        ' Frequency channel A
CONST FREQUENCY.B = 21009        ' Frequency channel B
CONST FREQUENCY.C = 21010        ' Frequency channel C
CONST FREQUENCY = 20006          ' Frequency channel A
CONST GATED = 21011              ' Gated totalize mode: from positive edge
                                 ' to negative edge
CONST NEG.ARM = 21012            ' Arming with negative level
CONST POS.ARM = 21022            ' Arming with positive level
CONST ARMING = 21059             ' Arming with positive level
CONST NEG.AVERAGE = 21013        ' Negative averaging
CONST POS.AVERAGE = 21023        ' Positive averaging
CONST AVERAGING = 21060          ' Averaging
CONST NEG.GATE = 21014           ' Gating for negative edge
CONST POS.GATE = 21024           ' Gating for positive edge
CONST GATING = 21063             ' Gating
CONST NEGATIVE = 21015           ' Negative slope, eg. for trigger
CONST PERIOD.A = 21016           ' Period channel A
CONST PERIOD.B = 21017           ' Period channel B
CONST PERIOD.C = 21018           ' Period channel C
CONST PERIOD = 21064             ' Period channel A
CONST PHASE.A.B = 21019          ' Phase between channels A and B
CONST PHASE.A.C = 21020          ' Phase between channels A and C
CONST PHASE.B.A = 21050          ' Phase between channels B and A
CONST PHASE.B.C = 21052          ' Phase between channels B and C
CONST PHASE.C.A = 21051          ' Phase between channels C and A
CONST PHASE.C.B = 21021          ' Phase between channels C and B
CONST PHASE = 21065              ' Phase between channels A and B
CONST POSITIVE = 21025           ' Positive slope, eg. for trigger
CONST PULSEWIDTH.A = 21026       ' Pulsewidth channel A
CONST PULSEWIDTH.B = 21027       ' Pulsewidth channel B
CONST PULSEWIDTH.C = 21028       ' Pulsewidth channel C
CONST PULSEWIDTH = 21066         ' Pulsewidth channel A
CONST RATIO.A.B = 21029          ' Ratio between channels A and B
CONST RATIO.C.A = 21054          ' Ratio between channels C and A
CONST RATIO.A.C = 21030          ' Ratio between channels A and C
CONST RATIO.B.A = 21053          ' Ratio between channels B and A
CONST RATIO.B.C = 21055          ' Ratio between channels B and C
CONST RATIO.C.B = 21031          ' Ratio between channels C and B
CONST RATIO = 21067              ' Ratio between channels A and B
CONST RISETIME.A = 21032         ' Risetime channel A
CONST RISETIME.B = 21033         ' Risetime channel B
CONST RISETIME.C = 21034         ' Risetime channel C
CONST RISETIME = 21068           ' Risetime channel A
CONST START.STOP = 21035         ' Start/stop totalize mode: from positive
                                 ' edge to positive edge
CONST TIMEINTERVAL.A.B = 21036   ' Timeinterval between channels A and B
CONST TIMEINTERVAL.A.C = 21037   ' Timeinterval between channels A and C
CONST TIMEINTERVAL.B.A = 21056   ' Timeinterval between channels B and A
CONST TIMEINTERVAL.B.C = 21038   ' Timeinterval between channels B and C
CONST TIMEINTERVAL.C.A = 21057   ' Timeinterval between channels C and A
CONST TIMEINTERVAL.C.B = 21058   ' Timeinterval between channels C and B
CONST TIMEINTERVAL = 21069       ' Timeinterval between channels A and B
CONST TOTALIZE.A = 21039         ' Totalize on channel A
CONST TOTALIZE.B = 21040         ' Totalize on channel B
CONST TOTALIZE.C = 21041         ' Totalize on channel C
CONST TOTALIZE = 21070           ' Totalize on channel A
CONST VMAX.A = 21042             ' Maximum voltage channel A
CONST VMAX.B = 21043             ' Maximum voltage channel B
CONST VMAX.C = 21044             ' Maximum voltage channel C
CONST VMAX = 21071               ' Maximum voltage channel A
CONST VMIN.A = 21045             ' Minimum voltage channel A
CONST VMIN.B = 21046             ' Minimum voltage channel B
CONST VMIN.C = 21047             ' Minimum voltage channel C
CONST VMIN = 21072               ' Minimum voltage channel A
CONST VPP.A = 21073              ' Volt Peak Peak channel A
CONST VPP.B = 21048              ' Volt Peak Peak channel B
CONST VPP.C = 21049              ' Volt Peak Peak channel C
CONST VPP = 20007                ' Volt Peak Peak channel A

' Predefined values for oscilloscope drivers

CONST AC.HPF = 25000             ' A type of trigger coupling
CONST AC.LPF = 25001             ' A type of trigger coupling
CONST ACCU = 25002               ' The register in which measurement results
                                 ' are stored
CONST ACTUAL = 25004             ' For data transfer setup: real measured data
                                 ' selected
CONST ADD = 25004                ' Addition of 2 channels is selected
CONST ADD.A = 25005              ' Add channel A to specified channel
CONST ADD.B = 25006              ' Add channel B to specified channel
CONST ADD.C = 25007              ' Add channel C to specified channel
CONST ALL.REGS = 25008           ' Select all registers, e.g. for display,
                                 ' positioning, etc.
CONST AUTO.HPF = 25009           ' A type of trigger coupling
CONST AUTO.LFP = 25010           ' A type of trigger coupling
CONST AUTO.RECURRENT = 25011     ' A horizontal triggering mode
CONST AUTO.TRIG = 25013          ' A type of trigger coupling
CONST AUTOPLOT = 20014           ' Automatically plots ACCU data
CONST AVERAGE = 25015            ' Selects averaging of the input signal
CONST BANDWIDTH.FILTER = 25016   ' Selects an input channel bandwidth filter
CONST CURRENT = 25017            ' Specification of probe type: current probe
CONST DC.LPF = 25018             ' A type of trigger coupling
CONST DIVS = 25019               ' A unit specification for trigger delay:
                                 ' divisions
CONST DOT.JOIN = 25020           ' The signal is displayed as a line
CONST DOTS = 25021               ' The signal is displayed as sample dots only
CONST DTIME = 25022              ' Cursor measurement type: time between curves
CONST DUAL = 25023               ' A type of trigger slope selection
CONST DVOLT = 25024              ' Cursor measurement type: voltage between
                                 ' curves
CONST EVENTS = 25025             ' Select type of trigger delay = number of ext
                                 ' events
CONST EVENTS.ECL = 25026         ' External events input coupling is implicitly
                                 ' selected
CONST EVENTS.TTL = 25027         ' Ext events input coupling is TTL
CONST EXTERN.10 = 25028          ' The external trigger input is attenuated by
                                 ' factor 10
CONST FREE.ROLL = 25029          ' A horizontal trigger mode: no trigger
                                 ' awaited
CONST FRONT = 25030              ' For register settings transfer to front
                                 ' panel
CONST FULL = 25031               ' Amount of display text selection
CONST HI.IMP = 25032             ' Input channel impedance selection
CONST HV.ISOLATION = 25033       ' Type of probe: high voltage probe
CONST INV.DTIME = 25034          ' Type of cursor measurement: inverse of delta
                                 ' time
CONST MAINS = 25035              ' Trigger source type: mains lines
CONST LO.IMP = 25036             ' Input channel impedance slection
CONST MIN.MAX = 25037            ' Data acquisition type: glitch detection on
CONST MULTIPLE = 25038           ' A horizontal trigger mode: multiple
                                 ' registers are filled
CONST k..OFF = 25039             ' Multiple use for switching functions off
CONST RECURRENT = 25040          ' A horizontal trigger mode: arming starts
                                 ' recurrently
CONST REDUCED = 25041            ' A reduced amount of display text is selected
CONST REVERSED = 25042           ' Reverse a cursor zoom action
CONST k..SCREEN = 2504           ' Source for plot action: plot the screen
CONST SEC = 25044                ' Trigger delay units: seconds
CONST SINGLE.SHOT = 25045        ' A horizontal trigger mode: fill one register
                                 ' once
CONST SMOOTH = 25046             ' Smooth out the display of samples
CONST START = 25047              ' Start the arming process
CONST SUBTRACT = 25048           ' Subtract two channels
CONST SUBTRACT.A = 25049         ' Subtract channel A from the selected channel
CONST SUBTRACT.B = 25050         ' Subtract channel B from the selected channel
CONST SWITCH.OFF = 25051         ' General use: switch function off
CONST SWITCH.ON = 25052          ' General use: switch function on
CONST TVF = 25053                ' A type of trigger coupling
CONST TVL = 25054                ' A type of trigger coupling
CONST VOLT = 25055               ' A type of cursor measurement
CONST VOLT.MEAN = 25056          ' A type of cursor measurement
CONST X.AXIS = 25057             ' Select X axis for magnification of display,
                                 ' etc.
CONST Y.AXIS = 25058             ' Select X axis for magnification of display,
                                 ' etc.
CONST ZERO = 25059               ' Shortcircuit input channel OR make offset
                                 ' zero

