
/* General predefined constant values for LabWindows instrument modules */

#define BUS               20000  /* Trigger mode bus */
#define EXTERNAL          20001  /* Trigger mode external */
#define INTERNAL          20002  /* Trigger mode internal */
#define MANUAL            20003  /* Trigger mode manual */
#define NO                20004  /* Used to indicate when turning something */
                                 /* off */
#define YES               20005  /* Used to indicate when turning something */
                                 /* on */
#define ACTUAL_SET        20008  /* When initializing do not set instrument */
                                 /* settings explicitly */
#define DEFAULT_SET       20009  /* When initializing set instrument */
                                 /* settings explicitly */
#define END_OF_ARRAY      24003

/* Predefined values for generator drivers */

#define ARBITRARY         23000  /* Arbitrary waveform */
#define CONT1             23001  /* Continuous burst or sweep mode 1 */
#define CONT2             23002  /* Continuous burst or sweep mode 2 */
#define CONT3             23023  /* Continuous burst or sweep mode 3 */
#define CONTINUOUS        23001  /* Continuous burst or sweep mode 1 */
#define COSINE            23003  /* Cosine waveform */
#define DBM               23004  /* Specifies a value as dbm eg. amplitude */
#define HAVERSINE         23005  /* Haversine waveform */
#define LINEAR            23006  /* Sweep mode linear */
#define LOGARITHMIC       23007  /* Sweep mode logarithmic */
#define NEG_PULSE         23008  /* Negative pulse waveform */
#define NEG_SAWTOOTH      23009  /* Negative sawtooth waveform */
#define POS_PULSE         23010  /* Positive pulse waveform */
#define POS_SAWTOOTH      23011  /* Positive sawtooth waveform */
#define SAWTOOTH          23020  /* Sawtooth waveform */
#define PP                23012  /* For specifying a value as peak peak eg. */
                                 /* amplitude */
#define SINE              23014  /* Sine waveform */
#define SINGLE            23015  /* Single burst or sweep mode 1 */
#define SINGLE1           23015  /* Single burst or sweep mode 1 */
#define SINGLE2           23021  /* Single burst or sweep mode 2 */
#define SINGLE3           23022  /* Single burst or sweep mode 3 */
#define SQUARE            23016  /* Square waveform */

/* Predefined values for multimeter drivers */

#define AUTOMATIC         1.701411733192644250e38 /* Automatic ranging */
#define CAPACITANCE       22001  /* Capacitance function */
#define CURRENT_AC        22002  /* Current AC function */
#define CURRENT_DC        22003  /* Current DC function */
#define CURRENT_RMS       22004  /* Current RMS function */
#define DIODE             22005  /* Diode function */
#define HIGH              22006  /* High indication for eg. setting speed of */
                                 /* meter */
#define LOW               22007  /* Low indication for eg. setting speed of */
                                 /* meter */
#define MEDIUM            22008  /* Medium indication for eg. setting speed */
                                 /* of meter */
#define NORMAL            22009  /* Normal indication for eg. setting speed */
                                 /* of meter */
#define PERIOD_POS        22021  /* Period measurement from positive edge to */
                                 /* positive edge */
#define PERIOD_NEG        22010  /* Period measurement from negative */
                                 /* edge to negative edge */
#define PULSEWIDTH_POS    22022  /* Period measurement from positive */
                                 /* edge to negative edge */
#define PULSEWIDTH_NEG    22011  /* Period measurement from negative */
                                 /* edge to positive edge */
#define RESISTANCE_2W     22012  /* Resistance 2 wire function */
#define RESISTANCE_4W     22013  /* Resistance 4 wire function */
#define TEMPERATURE       22014  /* Temperature function */
#define VOLT_AC           22015  /* Voltage AC function */
#define VOLT_DC           22016  /* Voltage DC function */
#define VOLT_PEAK_PEAK    22017  /* Voltage Peak Peak function */
#define VOLT_RMS          22018  /* Voltage RMS function */
#define VOLT_PEAK_POS     22019  /* Maximum voltage function */
#define VOLT_PEAK_NEG     22020  /* Minimum voltage function */

/* Predefine d values for counter drivers */

#define AC                21000  /* AC coupling */
#define CHA               21001  /* Channel A */
#define CHALL             21002  /* All channels */
#define CHB               21003  /* Channel B */
#define CHC               21004  /* Channel C */
#define DC                21005  /* DC coupling */
#define DUTYFACTOR_A      21006  /* Dutyfactor channel A */
#define DUTYFACTOR_B      21007  /* Dutyfactor channel B */
#define DUTYFACTOR_C      21008  /* Dutyfactor channel C */
#define DUTYFACTOR        21061  /* Dutyfactor channel A */
#define FREQUENCY_A       21062  /* Frequency  channel A */
#define FREQUENCY_B       21009  /* Frequency  channel B */
#define FREQUENCY_C       21010  /* Frequency  channel C */
#define FREQUENCY         20006  /* Frequency  channel A */
#define GATED             21011  /* Gated totalize mode: from positive */
                                 /* edge to negative edge */
#define NEG_ARM           21012  /* Arming with negative level */
#define POS_ARM           21022  /* Arming with positive level */
#define ARMING            21059  /* Arming with positive level */
#define NEG_AVERAGE       21013  /* Negative averaging */
#define POS_AVERAGE       21023  /* Positive averaging */
#define AVERAGING         21060  /* Averaging */
#define NEG_GATE          21014  /* Gating for negative edge */
#define POS_GATE          21024  /* Gating for positive edge */
#define GATING            21063  /* Gating */
#define NEGATIVE          21015  /* Negative slope, eg. for trigger */
#define PERIOD_A          21016  /* Period channel A */
#define PERIOD_B          21017  /* Period channel B */
#define PERIOD_C          21018  /* Period channel C */
#define PERIOD            21064  /* Period channel A */
#define PHASE_A_B         21019  /* Phase between channels A and B */
#define PHASE_A_C         21020  /* Phase between channels A and C */
#define PHASE_B_A         21050  /*Phase between channels B and A */
#define PHASE_B_C         21052  /* Phase between channels B and C */
#define PHASE_C_A         21051  /* Phase between channels C and A */
#define PHASE_C_B         21021  /* Phase between channels C and B */
#define PHASE             21065  /* Phase between channels A and B */
#define POSITIVE          21025  /* Positive slope, eg. for trigger */
#define PULSEWIDTH_A      21026  /* Pulsewidth channel A */
#define PULSEWIDTH_B      21027  /* Pulsewidth channel B */
#define PULSEWIDTH_C      21028  /* Pulsewidth channel C */
#define PULSEWIDTH        21066  /* Pulsewidth channel A */
#define RATIO_A_B         21029  /* Ratio between channels A and B */
#define RATIO_A_C         21030  /* Ratio between channels A and C */
#define RATIO_B_A         21053  /* Ratio between channels B and A */
#define RATIO_B_C         21055  /* Ratio between channels B and C */
#define RATIO_C_A         21054  /* Ratio between channels C and A */
#define RATIO_C_B         21031  /* Ratio between channels C and B */
#define RATIO             21067  /* Ratio between channels A and B */
#define RISETIME_A        21032  /* Risetime channel A */
#define RISETIME_B        21033  /* Risetime channel B */
#define RISETIME_C        21034  /* Risetime channel C */
#define RISETIME          21068  /* Risetime channel A */
#define START_STOP        21035  /* Start/stop totalize mode: from positive */
                                 /* edge to positive edge */
#define TIMEINTERVAL_A_B  21036  /* Timeinterval between channels A and B */
#define TIMEINTERVAL_A_C  21037  /* Timeinterval between channels A and C */
#define TIMEINTERVAL_B_A  21056  /* Timeinterval between channels B and A */
#define TIMEINTERVAL_B_C  21038  /* Timeinterval between channels B and C */
#define TIMEINTERVAL_C_A  21057  /* Timeinterval between channels C and A */
#define TIMEINTERVAL_C_B  21058  /* Timeinterval between channels C and B */
#define TIMEINTERVAL      21069  /* Timeinterval between channels A and B */
#define TOTALIZE_A        21039  /* Totalize on channel A */
#define TOTALIZE_B        21040  /* Totalize on channel B */
#define TOTALIZE_C        21041  /* Totalize on channel C */
#define TOTALIZE          21070  /* Totalize on channel A */
#define VMAX_A            21042  /* Maximum voltage channel A */
#define VMAX_B            21043  /* Maximum voltage channel B */
#define VMAX_C            21044  /* Maximum voltage channel C */
#define VMAX              21071  /* Maximum voltage channel A */
#define VMIN_A            21045  /* Minimum voltage channel A */
#define VMIN_B            21046  /* Minimum voltage channel B */
#define VMIN_C            21047  /* Minimum voltage channel C */
#define VMIN              21072  /* Minimum voltage channel A */
#define VPP_A             21073  /* Volt Peak Peak channel A */
#define VPP_B             21048  /* Volt Peak Peak channel B */
#define VPP_C             21049  /* Volt Peak Peak channel C */
#define VPP               20007  /* Volt Peak Peak channel A */

/* Predefined values for oscilloscope drivers */

#define AC_HPF            25000  /* A type of trigger coupling */
#define AC_LPF            25001  /* A type of trigger coupling */
#define ACCU              25002  /* The register in which measurement */
                                 /* results are stored */
#define ACTUAL            25004  /* For data transfer setup: real measured */
                                 /* data selected */
#define ADD               25004  /* Addition of 2 channels is selected*/
#define ADD_A             25005  /* Add channel A to specified channel */
#define ADD_B             25006  /* Add channel B to specified channel */
#define ADD_C             25007  /* Add channel C to specified channel */
#define ALL_REGS          25008  /* Select all registers, e.g. for display, */
                                 /* positioning, etc.*/
#define AUTO_HPF          25009  /* A type of trigger coupling */
#define AUTO_LFP          25010  /* A type of trigger coupling */
#define AUTO_RECURRENT    25011  /* A horizontal triggering mode */
#define AUTO_TRIG         25013  /* A type of trigger coupling */
#define AUTOPLOT          20014  /* Automatically plots ACCU data */
#define AVERAGE           25015  /* Selects averaging of the input signal */
#define BANDWIDTH_FILTER  25016  /* Selects an input channel bandwidth */
                                 /* filter */
#define CURRENT           25017  /* Specify probe type: current probe */
#define DC_LPF            25018  /* A type of trigger coupling */
#define DIVS              25019  /* A unit specification for trigger delay:  */
                                 /* divisions */
#define DOT_JOIN          25020  /* The signal is displayed as a line */
#define DOTS              25021  /* The signal is displayed as sample dots */
                                 /* only */
#define DTIME             25022  /* Cursor measurement type: time between */
                                 /* curves */
#define DUAL              25023  /* A type of trigger slope selection */
#define DVOLT             25024  /* Cursor measurement type: voltage between */
                                 /* curves */
#define EVENTS            25025  /* Select type of trigger delay = number of */
                                 /* ext events */
#define EVENTS_ECL        25026  /* External events input coupling is */
                                 /* implicitly selected */
#define EVENTS_TTL        25027  /* Ext events input coupling is TTL */
#define EXTERN_10         25028  /* The external trigger input is */
                                 /* attenuated by factor 10 */
#define FREE_ROLL         25029  /* A horizontal trigger mode: no trigger */
                                 /* awaited */
#define FRONT             25030  /* For register settings transfer to front */
                                 /* panel */
#define FULL              25031  /* Amount of display text selection */
#define HI_IMP            25032  /* Input channel impedance selection */
#define HV_ISOLATION      25033  /* Type of probe: high voltage probe */
#define INV_DTIME         25034  /* Type of cursor measurement: inverse of */
                                 /* delta time */
#define MAINS             25035  /* Trigger source type: mains lines */
#define LO_IMP            25036  /* Input channel impedance slection */
#define MIN_MAX           25037  /* Data acquisition type: glitch detect on */
#define MULTIPLE          25038  /* A horizontal trigger mode: multiple */
                                 /* registers are filled */
#define OFF               25039  /* Multiple use for switching functions off */
#define RECURRENT         25040  /* A horizontal trigger mode: arming starts */
                                 /* recurrently */
#define REDUCED           25041  /* A reduced amount of display text is */
                                 /* selected */
#define REVERSED          25042  /* Reverse a cursor zoom action */
#define SCREEN            25043  /* Source for plot action: plot the screen */
#define SEC               25044  /* Trigger delay units: seconds */
#define SINGLE_SHOT       25045  /* A horizontal trigger mode: fill one */
                                 /* register once */
#define SMOOTH            25046  /* Smooth out the display of samples */
#define START             25047  /* Start the arming process */
#define SUBTRACT          25048  /* Subtract two channels */
#define SUBTRACT_A        25049  /* Subtract channel A from the selected */
                                 /* channel */
#define SUBTRACT_B        25050  /* Subtract channel B from the selected */
                                 /* channel */
#define SWITCH_OFF        25051  /* General use: switch function off */
#define SWITCH_ON         25052  /* General use: switch function on */
#define TVF               25053  /* A type of trigger coupling */
#define TVL               25054  /* A type of trigger coupling */
#define VOLT              25055  /* A type of cursor measurement */
#define VOLT_MEAN         25056  /* A type of cursor measurement */
#define X_AXIS            25057  /* Select X axis for magnification of */
                                 /* display, etc. */
#define Y_AXIS            25058  /* Select X axis for magnification of */
                                 /* display, etc. */
#define ZERO              25059  /* Shortcircuit input channel OR make */
                                 /* offset zero */

