/*
 * graphics.h
 *
 * "Include" file for Microsoft C programs using
 * the LabWindows Standard Graphics Library.
 *
 * Copyright (C) National Instruments 1987-1989.
 *
 */

extern int grferr;

void GrfCurv2D (void *, void *, int);
void GrfYCurv2D (void *, int);
void GrfWaveform (void *, int, double, double, double, double);
void GrfPoint2D (double, double);
void GrfText2D (double, double, char []);
void GrfPrint (int, int, char []);

void GrfReset (int);
void GrfLReset (int, int, int, int);
void GrfPush (void);
void GrfPop (void);

void SetCurv2D (int);
void SetPointStyle (int);
void SetPointFreq (int);
void SetPlotMode (int);
void SetBckColor (int);
void SetFrmColor (int);
void SetGrdColor (int);
void SetLblColor (int);
void SetCrvColor (int);
void SetTtlColor (int);
void SetPortWidth (int);
void SetPortHeight (int);
void SetPortDim (int, int);
void SetPortPos (int, int);
void SetPortFrame (int);
void SetGrdFrame (int);
void SetTitle (char []);
void SetAdapter (int, int, int *);

void SetAxRange (int, double, double, int);
void SetAxScale (int, int);
void SetAxAuto (int, int);
void SetAxGridVis (int, int);
void SetAxLblVis (int, int);
void SetAxLblUnits (int, int);
void SetAxName (int, char []);

void SetTxFont (int);
void SetTxBold (int);
void SetTxItalic (int);
void SetTxUnder (int);
void SetTxStrike (int);
void SetTxProport (int);
void SetTxStyle (int);
void SetTxColor (int);
void SetTxAlign (int, int);
void SetTxWidth (int);
void SetTxHeight (int);
void SetTxSize (int, int);
void SetTxAngle (int);

void HardCopy (void);
void PrintScreen(void);
void SetupPrinter (char [], int, double, double, int);
void PlotGraph (unsigned int );
void SetPlotterPenCount (int);
void SetPlotterPenColors (int, int, int, int, int, int, int, int,
			  int, int, int, int, int, int, int, int);
void SetPlotterSpeed(int);
void SetupGPIBPlotter (int, int);
void SetupRS232Plotter (int, int, int, int, int);
void SetupPlotFile (char *, int, int, int, int);

void SaveGraphFile (char [], unsigned int);
int  LoadGraphFile (char [], unsigned int *);

unsigned int CreatePort (int, int, int, int);
void DisplayPort (unsigned int);
void RemovePlots (unsigned int);
void DeletePort (unsigned int);
void SetActivePort (unsigned int);
void SetPortVisibility (unsigned int, int);

void SetXDataType (int);
void SetYDataType (int);
void SetDisplayMode (int);
void DefaultGraphSettings(void);
void GrfMsg (char [], int);

unsigned int  CreateStripChart (int, int, int, int, double, double,
				double, double, int, int, int);
void GrfStrip (int, void *, int, int, int);
void SetControlTrace (int, void *, int, int, int, int);
void SetTraceColor (int, int, int);
void SetTraceCrvStyle (int, int, int);
void SetTracePtStyle (int, int, int);

unsigned int  CreateNumericPort (int, int, int, int, int, char [], char[]);
void GrfNumeric (int, double);

