/*
 * analysis.h (advanced)
 *
 * "Include" file for Microsoft C programs using
 * the LabWindows Advanced Analysis Library.
 *
 * Copyright (C) National Instruments 1987-1989.
 *
 */

extern int dsperr;

void Impulse (unsigned, double, unsigned, double []);
void Pulse (unsigned, double, unsigned, unsigned, double []);
void Ramp (unsigned, double, double, double []);
void Triangle (unsigned, double, double []);
void SineWave (unsigned, double, double, double, double []);
void Uniform (unsigned, double []);
void WhiteNoise (unsigned, double, double []);
void GaussNoise (unsigned, double, double[]);

void Add1D (double [], double [], unsigned, double []);
void Sub1D (double [], double [], unsigned, double []);
void Mul1D (double [], double [], unsigned, double []);
void Div1D (double [], double [], unsigned, double []);
void Abs1D (double [], unsigned, double[]);
void Neg1D (double [], unsigned, double[]);
void LinEv1D (double [], unsigned, double, double, double []);
void PolyEv1D (double [], unsigned, double [], unsigned, double []);
void Scale1D (double [], unsigned, double [], double *, double *);
void QScale1D (double [], unsigned, double [], double *);
void MaxMin (double [], unsigned, double *, unsigned *, double *, unsigned *);
void MaxMin1D (double [], unsigned, double *, unsigned *, double *, unsigned *);
void Sum1D (double [], unsigned, double *);
void Prod1D (double [], unsigned, double *);
void Subset1D (double [], unsigned, unsigned, unsigned, double []);
void UnWrap1D (double [], unsigned);

void Add2D (void *, void *, unsigned, unsigned, void *);
void Sub2D (void *, void *, unsigned, unsigned, void *);
void Mul2D (void *, void *, unsigned, unsigned, void *);
void Div2D (void *, void *, unsigned, unsigned, void *);
void LinEv2D (void *, unsigned, unsigned, double, double, void *);
void PolyEv2D (void *, unsigned, unsigned, double [], unsigned, void *);
void Scale2D (void *, unsigned, unsigned, void *, double *, double *);
void QScale2D (void *, unsigned, unsigned, void *, double *);
void MaxMin2D (void *, unsigned, unsigned, double *, unsigned *, unsigned *,
					   double *, unsigned *, unsigned *);
void Sum2D (void *, unsigned, unsigned, double *);

void CxAdd (double, double, double, double, double *, double *);
void CxSub (double, double, double, double, double *, double *);
void CxMul (double, double, double, double, double *, double *);
void CxDiv (double, double, double, double, double *, double *);
void CxRecip (double, double, double *, double *);
void ToPolar (double, double, double *, double *);
void ToRect (double, double, double *, double *);
void CxSqrt (double, double, double *, double *);
void CxLog (double, double, double *, double *);
void CxLn (double, double, double *, double *);
void CxExp (double, double, double *, double *);
void CxPow (double, double, double, double *, double *);

void CxAdd1D (double [], double [], double [], double [], unsigned, double [], double []);
void CxSub1D (double [], double [], double [], double [], unsigned, double [], double []);
void CxMul1D (double [], double [], double [], double [], unsigned, double [], double []);
void CxDiv1D (double [], double [], double [], double [], unsigned, double [], double []);
void CxLinEv1D (double [], double [], unsigned, double, double, double, double, double [], double []);
void ToPolar1D (double [], double [], unsigned, double [], double []);
void ToRect1D (double [], double [], unsigned, double [], double []);

void FFT (double [], double [], unsigned);
void InvFFT (double [], double [], unsigned);
void ReFFT (double [], double [], unsigned);
void ReInvFFT (double [], double [], unsigned);
void FHT (double [], unsigned);
void InvFHT (double [], unsigned);
void Spectrum (double [], unsigned);
void Cxy (double [], unsigned, double [], unsigned, double []);
void Rxy (double [], unsigned, double [], unsigned, double []);

void Integrate (double [], unsigned, double, double, double, double []);
void Difference (double [], unsigned, double, double, double, double []);
void Reverse (double [], unsigned, double []);
void Shift (double [], unsigned, int, double []);
void Clip (double [], unsigned, double, double, double []);
void PulseParam (double [], unsigned, double *, double *, double *, double *,
		 double *, double *, double *, double *,
		 unsigned *, unsigned *, unsigned *, unsigned *, double *);

void Bw_LPF (double [], unsigned, double, double, unsigned, double []);
void Bw_HPF (double [], unsigned, double, double, unsigned, double []);
void Bw_BPF (double [], unsigned, double, double, double, unsigned, double []);
void Bw_BSF (double [], unsigned, double, double, double, unsigned, double []);
void Ch_LPF (double [], unsigned, double, double, double, unsigned, double []);
void Ch_HPF (double [], unsigned, double, double, double, unsigned, double []);
void Ch_BPF (double [], unsigned, double, double, double, double, unsigned, double []);
void Ch_BSF (double [], unsigned, double, double, double, double, unsigned, double []);
void InvCh_LPF (double [], unsigned, double, double, double, unsigned, double []);
void InvCh_HPF (double [], unsigned, double, double, double, unsigned, double []);
void InvCh_BPF (double [], unsigned, double, double, double, double, unsigned, double []);
void InvCh_BSF (double [], unsigned, double, double, double, double, unsigned, double []);
void Elp_LPF (double [], unsigned, double, double, double, double, unsigned, double []);
void Elp_HPF (double [], unsigned, double, double, double, double, unsigned, double []);
void Elp_BPF (double [], unsigned, double, double, double, double, double, unsigned, double []);
void Elp_BSF (double [], unsigned, double, double, double, double, double, unsigned, double []);

void Wind_LPF (double, double, int, double [], int);
void Wind_HPF (double, double, int, double [], int);
void Wind_BPF (double, double, double, int, double [], int);
void Wind_BSF (double, double, double, int, double [], int);
void Ksr_LPF (double, double, int, double[], double);
void Ksr_HPF (double, double, int, double[], double);
void Ksr_BPF (double, double, double, int, double[], double);
void Ksr_BSF (double, double, double, int, double[], double);
void Equi_Ripple (int, double[], double[], double, double[], int, int, double [], double *);
void EquiRpl_LPF (double, double, double, int, double[], double *);
void EquiRpl_HPF (double, double, double, int, double[], double *);
void EquiRpl_BPF (double, double, double, double, double, int, double[], double *);
void EquiRpl_BSF (double, double, double, double, double, int, double[], double *);

void TriWin (double[], unsigned);
void HanWin (double[], unsigned);
void HamWin (double[], unsigned);
void BkmanWin (double[], unsigned);
void KsrWin (double[], unsigned, double);

void Mean (double [], unsigned, double *);
void StdDev (double [], unsigned, double *, double *);
void Variance (double [], unsigned, double *, double *);
void RMS (double [], unsigned, double *);
void Moment (double [], unsigned, unsigned, double *);
void Median (double [], unsigned, double *);
void Histogram (double [], unsigned, double, double, unsigned [], double [], unsigned);
void Mode (double [], unsigned, double, double, unsigned, double *);
void Sort (double [], unsigned, unsigned, double []);

void LinFit (double [], double [], unsigned, double [], double *, double *, double *);
void ExpFit (double [], double [], unsigned, double [], double *, double *, double *);
void PolyFit (double [], double [], unsigned, unsigned, double [], double [], double *);

void DotProduct (double [], double [], unsigned, double *);
void NormalVector (double [], unsigned, double [], double *, double *);
void NormalMat (void *, unsigned, unsigned, void *, double *,double *);
void MatrixMul (void *, void *, unsigned, unsigned, unsigned, void *);
void InvMatrix (void *, unsigned, void *);
void Transpose (void *, unsigned, unsigned, void *);
void Determinant (void *, unsigned, double *);
void Trace (void *, unsigned, double *);
void LinEqs (void *, double [], unsigned, double []);
void LU (void *, unsigned, int [], int *);
void ForwSub (void *, double [], unsigned, double [], int []);
void BackSub (void *, double [], unsigned, double []);

void Copy1D (double [], unsigned, double []);
void Set1D (double [], unsigned, double);
void Clear1D (double [], unsigned);


