#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <graph.h>
#include <memory.h>
#include <malloc.h>
#include <ctype.h>
#include <conio.h>
#include <math.h>
#include <time.h>
#include <dos.h>
#include <io.h>

/* Includes for canned functions */
#include "c:\krs\adprogs\csource\t_colors.h"
#include	"c:\krs\adprogs\csource\box.h"
#include "c:\krs\adprogs\csource\box.c"
#include "c:\krs\adprogs\csource\getkey.h"
#include "c:\krs\adprogs\csource\getkey.c"
#include "c:\krs\adprogs\csource\menu.h"
#include "c:\krs\adprogs\csource\menu.c"
#include "c:\krs\adprogs\csource\v3.h"
#include "c:\krs\adprogs\csource\ioformats.h"

/* Includes for National Instruments Data Acquisition Board */
#include "c:\labwin\include\dataacq.h"
#include "c:\labwin\include\formatio.h"
#include "c:\labwin\include\lw_const.h"

/* Includes and Defines for National Instruments GPIB Controller Card */
#include "c:\gpib488\gpib_lib.c"
#include "c:\gpib488\fsg_prog.c"
#include "c:\gpib488\hsa_prog.c"

#define	CAL_PATH			"c:\\krs\\adprogs\\calfiles\\"
#define	TRUE				1

/* Text formatting information */
#define	TEXT_ENTRY_ROW			14
#define	TEXT_ENTRY_COL			15
#define	TEXT_ENTRY_ROW2		19
#define	TEXT_ENTRY_COL2		18
#define  TEXT_ENTRY_ROW3		10
#define  TEXT_ENTRY_COL3		3
#define  ERROR_MESSAGE_ROW		11
#define	ERROR_MESSAGE_COL		8
#define	STATUS_MESSAGE_ROW1	15
#define	STATUS_MESSAGE_COL1	10
#define	DA_ERROR_ROW			20
#define	DA_ERROR_COL			25
#define	GPS_ERROR_ROW			20
#define	GPS_ERROR_COL			1
#define	GPS_STATUS_ROW			15
#define	GPS_STATUS_COL			3
#define	MKR_STATUS_ROW			11
#define	MKR_STATUS_COL			3
#define	HEADER_ROW1		 		1
#define	HEADER_COL1		 		10
#define	HEADER_ROW2		 		2
#define	HEADER_COL2		 		10
#define	MESSAGE_ROW1	 		7
#define	MESSAGE_COL1	 		8
#define	MESSAGE_ROW2	 		12
#define	MESSAGE_COL2	 		10
#define	MESSAGE_ROW3	 		14
#define	MESSAGE_COL3	 		10

/****************************************************************************
*	Function:		int Initialize_GPS_Receiver(void)
*	Description:	Initialize the GPS receiver in warning mode through the 
*	serial port connection.  This routine waits for the GPS receiver to lock 
*	onto three satellites.  If lock cannot be made, the user has the option to
*	abort the program.
****************************************************************************/
int Initialize_GPS_Receiver(void)
{										  
  int  i,quit;
  char message[60];

  gps_state = 2;

  /*  Initialize GPS Receiver */
  if (gps_state > 0)
  {
    tans_init();
    time (&gps_last_warning_time);		/* initialize warning timer */
    if (gps_state == 2)						/* wait for lock in warning mode */
    {
      quit = !TRUE;            
      Empty_Keyboard_Buffer();
      while (!quit)
      {
        if (Display_GPS_Status() == 0) quit = TRUE;
        if (kbhit())
        {
          i = getch();
          if (i == 0x1b)
          {
            save_gps_error = menu_message(GPS_ERROR_ROW,GPS_ERROR_COL,error_message2);
            strcpy(message,"Aborted before GPS lock was established.");
            _settextposition(GPS_ERROR_ROW+1,GPS_ERROR_COL+2);
				_outtext(message);
            tans_restore();
            Wait(3);
            menu_erase(save_gps_status);
            menu_erase(save_gps_error);
            quit = TRUE;      
          }
          else if (i == '\r')
            menu_erase(save_gps_error);
        }  /* endif */
      } /* end while waiting for lock */
    }  /* end if warning set */
  } /* if gps is enabled */
  GPSinitflag = TRUE;
  Wait(3);
  menu_erase(save_gps_status);
  return(TRUE);
}  

/*****************************************************************************
*	Function:		Display_GPS_Status(void)
*	Description:	Take the current GPS reading an load the structure (through
*	tans_get_gps_status) and display the result on some standardized display.
*	Returns current gps status byte (0 == locked o.k.)
*****************************************************************************/
int Display_GPS_Status()
{
  char	descr[50];
  time_t	now;
  int	i, j;
  int	ret_status;
  static int  first_time = TRUE;	

  if (first_time == TRUE) {
    first_time = !TRUE;
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    save_gps_status = menu_message(GPS_STATUS_ROW,GPS_STATUS_COL,status_message);
  }
  switch (gps_state) {
    case 1:	/* gps on */
    case 2:	/* gps set to warning */
	   Wait(1);
      ret_status = tans_get_gps_status (&gps_info);	/* get the gps information 07.08 */
      if (gps_state == 2) {	/* do warning checks */
        time(&now);	/* get current time */
        if (ret_status == 0)		/* 07.08 */
        { /* doing fixes */
          gps_last_warning_time = now;
        }
        else
        {  /* gps not locked, beep if time exceeded */
          if (fabs(difftime(now, gps_last_warning_time)) > (double) GPS_WARNING_TIME) 
          { /* time to warn them, do a nasty display thing too... */
            save_gps_error = menu_message(GPS_ERROR_ROW,GPS_ERROR_COL,error_message);
            strcpy (descr, "GPS NOT LOCKED");
				_settextposition(GPS_ERROR_ROW+1,GPS_ERROR_COL+5);
			   _outtext(descr);
            printf ("\a");  /* sound bell here */
            gps_last_warning_time = now;
          }
        }
      }  /* end gps warning check */
      switch (ret_status) {  /* 07.08 */
        case -1:  /* still waiting for all packets info to accompany a fix 07.08 */
          sprintf (descr, "  Wait   %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 0:  /* doing fixes */
          sprintf (descr, "  Locked %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 1:  /* no GPS time yet */
          sprintf (descr, "  NoTime %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 8:  /* no sats */
          sprintf (descr, "  NO Sat %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 9:  /* 1 satellite */
          sprintf (descr, "  1 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 0xa:  /* 2 satellites */
          sprintf (descr, "  2 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        case 0xb:  /* 3 satellites */
          sprintf (descr, "  3 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
        default:
          sprintf (descr, "  Unknwn %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
            gps_info.c_sats[0],
            gps_info.c_sats[1],
            gps_info.c_sats[2],
            gps_info.c_sats[3],
            gps_info.c_pdop,
            gps_info.last_lat,
            gps_info.last_lon);
            _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
            _outtext(descr);
          break;
      }  /* end switch on status */
      break;
    case 0:  /* no gps in use */
      strcpy (descr, "Off");
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      break;
  } /* end switch on gps_state */
  if (gps_state == 0) /* no gps */
    return (0);  /* return all o.k. in this case */
  else
    return (ret_status);  /* return current status (including -1) 07.08 */
}  /* end Display_GPS_Status */

/*****************************************************************************
*	Function:		Write_GPS_Data(void)
*	Description:	Take the current GPS reading an load the structure (through
*	tans_get_gps_status) and display the result on some standardized display.
*	Returns current gps status byte (0 == locked o.k.)
*****************************************************************************/
int Write_GPS_Data()
{
  char	descr[60];
  time_t	now;
  int	i,j,index;
  int	ret_status;
  char outstr[64];
  static int  first_time = TRUE;	

  if (first_time == TRUE) {
    first_time = !TRUE;
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    save_gps_status = menu_message(GPS_STATUS_ROW,GPS_STATUS_COL,status_message2);
  }
 
  ret_status = tans_get_gps_status (&gps_info);	
  if (gps_info.new) {
    gps_rec_count++;
    sprintf(outstr,"G%.5ld",gps_rec_count);  
    for (index = 0; index < params.channels; index++) 
      fprintf(tmpfileptr[index],"%s\t",outstr);
  }
  else 
    sprintf(outstr,"G%.5ld",gps_rec_count);  
  switch (ret_status) {  
    case -1:  /* still waiting for all packets info to accompany a fix 07.08 */
      sprintf (descr, "%s   Wait   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
        outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  Wait   %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
 	     outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 0:  /* doing fixes */
      sprintf (descr, "%s   Locked   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
        outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  Locked %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
		  outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 1:  /* no GPS time yet */
      sprintf (descr, "%s   NoTime   %2d.%2d.%2d.%2d  %3.1f  %8.5lf %10.5lf",
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  NoTime %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
		  outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 8:  /* no sats */
      sprintf (descr, "%s   NoSat   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
		  outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  NO Sat %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
		  outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 9:  /* 1 satellite */
      sprintf (descr, "%s   1 Sat   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
        outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  1 Sat  %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
	     outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 0xa:  /* 2 satellites */
      sprintf (descr, "%s   2 Sat   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
	    outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  2 Sat  %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
	     outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    case 0xb:  /* 3 satellites */
      sprintf (descr, "%s   3 Sat   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
	    outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  3 Sat  %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
	     outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
    break;
    default:
      sprintf (descr, "%s   Unknwn   %2d.%2d.%2d.%2d  %3.1f  %7.4lf %9.4lf",
	    outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      _settextposition(GPS_STATUS_ROW+2,GPS_STATUS_COL+2);
      _outtext(descr);
      if (gps_info.new)
      fprintf (gpsfileptr, "%s  Unknwn %2d.%2d.%2d.%2d %3.1f %8.5lf %10.5lf\n",
	    outstr,
        gps_info.c_sats[0],
        gps_info.c_sats[1],
        gps_info.c_sats[2],
        gps_info.c_sats[3],
        gps_info.c_pdop,
        gps_info.last_lat,
        gps_info.last_lon);
      break;
  }  /* end switch on status */
  if (gps_state == 0) /* no gps */
    return (0);  /* return all o.k. in this case */
  else
    return (ret_status);  /* return current status (including -1) 07.08 */
}  /* end Display_GPS_Status */


/*****************************************************************************
*	Function:		Write_Marker(void)
*	Description:	Write a marker to the output data file.  Markers are used
*	for marking the file when the GPS data is not fed to file.  This can occur
*	when the GPS receiver is not locked or when it is disabled.
*****************************************************************************/
int Write_Marker()
{
  int	index;
  char descr[80];
  char outstr[64];
  static int  first_time = TRUE;	

  if (first_time == TRUE) {
    first_time = !TRUE;
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    save_marker_status = menu_message(MKR_STATUS_ROW,MKR_STATUS_COL,status_message3);
  }
 
  mkr_count++;
  sprintf(outstr,"M%.5ld",mkr_count);  
  for (index = 0; index < params.channels; index++) 
    fprintf(tmpfileptr[index],"%s\t",outstr);
  sprintf (descr, "Current Marker: %s",outstr);
  _settextposition(MKR_STATUS_ROW+1,MKR_STATUS_COL+2);
  _outtext(descr);
}

/*****************************************************************************
*	Function:		GPS_Receiver_Operation()
*	Description:	Menu operator to enable/disable GPS receiver
*****************************************************************************/
int GPS_Receiver_Operation()
{
  int keypressed;
  int far *drop_toggle_menu;
  char *toggle_menu[] = 
	{
	" GPS Operation ",
	"On",
	"Off",
	"",
	NULL
	};

   drop_toggle_menu = menu_drop(9,25,toggle_menu,&keypressed);
	if (keypressed == 1)	{
	  if (!GPSinitflag)
       Initialize_GPS_Receiver();
     GPSreadflag = TRUE;
   }
   if(keypressed == 2) {
     tans_restore();
     GPSinitflag = !TRUE;
	  GPSreadflag = !TRUE;
   }
   menu_erase(drop_toggle_menu);
	return(TRUE);
}

/****************************************************************************
*	Function:	int Check_Free_Disk_Space(void)
*	Description:	Gets the free disk space (from Disk_Free_kb procedure which 
*	checks the specified drive and returns true if the available space is less 
*	than specified by MIN_FREE_DISK_SIZE. Also display message and waits for
*	operator	to acknowledge this error.
****************************************************************************/
int Check_Free_Disk_Space (void)
{
  int  retval = TRUE;
  if (Disk_Free_kb() <= (long)MIN_FREE_DISK_SIZE)
    retval = !TRUE;
  return (retval);
}

/****************************************************************************
*	Function:	unsigned long Disk_Free_kb(void)
*	Description:	Returns kbytes free (rounded down) as a long integer value.
*	Note:  This function currently checks only the C drive.  It may be req'd
*	to change this function so other drives (e.g., Bernoulli) are checked.
****************************************************************************/
unsigned long Disk_Free_kb(void)
{
  unsigned long free_space, bytes_per_cluster;
  struct	diskfree_t	dfinfo;

  if (_dos_getdiskfree(3, &dfinfo) != 0) /* can't do this disk */
  {
    printf ("Error in function\n");
    return (0L);
  }
  bytes_per_cluster = dfinfo.sectors_per_cluster * dfinfo.bytes_per_sector;
  free_space = dfinfo.avail_clusters * bytes_per_cluster;
  free_space = free_space / 1000L;
  return (free_space);
}	/* end Disk_Free_kb */


/*****************************************************************************
*	Function:		int Process_Error_Code(int errNum)
*	Description:	Function process the error codes returned by the LabWindows
*	Data Acquisition C Libraries.  The warning and error codes are described in
*	the LabWindows documentation.
*****************************************************************************/
int Process_Error_Code(int errNum)
{
  char message[40];
  static int first_time = TRUE;

  if (first_time == TRUE && errNum != 0) {
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    save_DA_message = menu_message(DA_ERROR_ROW,DA_ERROR_COL,DA_error_message);
	 first_time = !TRUE;
  }

  switch (errNum)
  {
    case 0:
      //  Operation completed.  No error(s) detected.
      return(TRUE);
    break;
    case 5:
      // Warning message - calibrationFailed.
      strcpy(message,"Warning - Analog input channel calibration failed.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case 12:
      // Warning - overWriteBeforeCopy.
      strcpy(message,"Buffer overwritten before copied.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -60:
      //  Operation incomplete - NotOurBrdErr.
      strcpy(message,"DA board not recognized.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -61:
      //  Operation incomplete - badBrdNumErr.
      strcpy(message,"Incorrect DA board number.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -62:
      //  Operation incomplete - badGainErr.
      strcpy(message,"Invalid A/D gain value specified.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -63:
      // Operation incomplete - badChanErr.
      strcpy(message,"Invalid analog input channel specified.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -64:
      // Operation incomplete - noSupportErr.
      strcpy(message,"No support available.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -69:
      // Operation incomplete - badInputValError
		strcpy(message,"Bad input value.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -70:
      // Operation incomplete - timeOutErr.
      strcpy(message,"Time out error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -71:
      // Operation incomplete - outOfRangeErr.
      strcpy(message,"Data out of range.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -72:
      // Operation incomplete - daqInProgErr.
      strcpy(message,"Data acquisition in progress.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -73:
      // Operation incomplete - counterInUseErr.
      strcpy(message,"Counter in use.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -75:
      // Operation incomplete - overFlowErr.
      strcpy(message,"Buffer overflow error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -76:
      // Operation incomplete - overRunErr.
      strcpy(message,"Buffer overrun error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -77:
      // Operation incomplete - badCntErr.
      strcpy(message,"Bad counter error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -91:
      // Operation incomplete - badPreTrigCntError.
      strcpy(message,"Bad pretrigger counter error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -93:
      // Operation incomplete - intLevelNoSupportErr.
      strcpy(message,"No internal level support.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -94:
      // Operation incomplete - extConvErr.
      strcpy(message,"External conversion error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -96:
      // Operation incomplete - noDbDaqErr.
      strcpy(message,"Double buffering not initialized.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -97:
      // Operation incomplete - overWriteErr.
      strcpy(message,"Buffer overwrite error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
	 break;
    case -98:
      //  Operation incomplete - memErr.
      strcpy(message,"Memory error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -99:
      //  Operation incomplete - noConfigFile
      strcpy(message,"Cannot find configuration file.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
 	 case -101:
      //  Operation incomplete - intLevelInUse
    	strcpy(message,"Level in use.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -102:
      // Operation incomplete - DMAChanInUse
      strcpy(message,"DMA channel in use.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -104:
      // Operation incomplete - lowScanIntervalErr
      strcpy(message,"Low scan interval error.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -118:
      // Operation incomplete - DMADisabledErr
      strcpy(message,"DMA channel disabled.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    case -119:
      //  Operation incomplete - invalidConfigErr.
      strcpy(message,"Invalid configuration data.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE); 
    break;
    case -127:
      // Operation incomplete - keyNotFoundErr.
      strcpy(message,"Key code not found.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      return(!TRUE);
    break;
    default:
      //  Operation incomplete - default error code
      strcpy(message,"Error unknown.");
      _settextposition(DA_ERROR_ROW+1,DA_ERROR_COL+1);
      _outtext(message);
      exit(0);
    break;
  }
}

/*****************************************************************************
*	Function:		Empty_Keyboard_Buffer(void)
*	Description:	Function to empty keyboard buffer to enable a program escape
*	sequence.  This function is used prior to entering and key controlled loop.
*****************************************************************************/
Empty_Keyboard_Buffer(void)
{
  while( kbhit() )
    getch();
}

/*****************************************************************************
*	Function:		int Open_Data_File()
*	Description:	Ask the operator for the file number to store the data in.
*	This function creates a filename of the form mmddfxxx.. Where 'mm' is 
*	the current month, 'dd' is the current day, 'f' is the analog channel the
*	data is collected with, and  'xxx' is the file number entered by the
*	the operator.  The '.acq' extension is standard for all of the	data files.
*	The routine also opens a file to store GPS data in if the GPS read flag is
*	set appropriately.
*****************************************************************************/
int Open_Data_File(int fnumber)
{
  int 	i;
  char  	datebfr[10],filestr[32],tmpstr[10];
  char *error_message1[] = 
  {
    " File I/O Error ",
    "                                                        ",
    " Press Any Key To Continue ",
    NULL
  };
  char message[64];
  int far *save_error;

  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);

  /* Get the system date and operator entries */
  _strdate(datebfr);
  strncpy(filestr,datebfr,(size_t) 2);
  strncpy(&filestr[2],&datebfr[3],(size_t) 2);
  filestr[4] = '\0';
  for (i = 0; i < params.channels; i++)
    strcpy(iodata.datafilename[i],iodata.datafilepath);
  strcpy(iodata.gpsfilename,iodata.datafilepath);
  for (i = 0; i < params.channels; i++)
    strcat(iodata.datafilename[i],filestr);
  strcat(iodata.gpsfilename,filestr);
  for (i = 0; i < params.channels; i++) {
	 sprintf(tmpstr,"%1d",i);
    strcat(iodata.datafilename[i],tmpstr);
    sprintf(tmpstr,"%.3d",fnumber);
    strcat(iodata.datafilename[i],tmpstr);
  }
  sprintf(tmpstr,"%.3d",fnumber);
  strcat(iodata.gpsfilename,tmpstr);
  for (i = 0; i < params.channels; i++)
    strcat(iodata.datafilename[i],DATAEXT);
  strcat(iodata.gpsfilename,GPSEXT);
  for (i = 0; i < params.channels; i++) {
    datafileptr[i] = fopen(iodata.datafilename[i],"r");
    if (datafileptr[i] != NULL) { 
      save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
		sprintf(message,"Data file <%s> exists",iodata.datafilename[i]);
      _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
      _outtext(message);
		printf("\a");
		getch();
      fclose(datafileptr[i]);
      return(!TRUE);
    }
    if ( (datafileptr[i] = fopen(iodata.datafilename[i],"w+")) == NULL) {
      save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
		sprintf(message,"Cannot create data file <%s>",iodata.datafilename[i]);
      _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
      _outtext(message);
		printf("\a");
      getch();
      return(!TRUE);
    }
  }
  if ( (gpsfileptr = fopen(iodata.gpsfilename,"w+")) == NULL) {
    save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
    sprintf(message,"Cannot create GPS data file <%s>",iodata.gpsfilename);
    _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
    _outtext(message);
    printf("\a");
    getch();
    return(!TRUE);
  }
  return(TRUE);
}

/****************************************************************************
*	Function:		int Open_Temporary_File(int fnumber)
*	Description:	Open a temporary file to store raw (unscaled) data in.  One
*	file is opened for each of the channels scanned.  The acquired data is 
*	demuxed before it is written to file to simplify later data processing.
*	Temporary files are deleted upon successful program completion.
****************************************************************************/
int Open_Temporary_File(int fnumber)
{

  int 	i;
  char  	operinpt[32],datebfr[10],filestr[32],tmpstr[10];
  char *error_message1[] = 
  {
    " File I/O Error ",
    "                                                        ",
    " Press Any Key To Continue ",
    NULL
  };
  char message[64];
  int far *save_error;
 
  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);

  for (i = 0; i < params.channels; i++) {
    _strdate(datebfr);
    strncpy(filestr,datebfr,(size_t) 2);
    strncpy(&filestr[2],&datebfr[3],(size_t) 2);
    filestr[4] = '\0';
    strcpy(iodata.tmpfilename[i],iodata.tmpfilepath);
    strcat(iodata.tmpfilename[i],filestr);
    sprintf(filestr,"%1d",i);
    strcat(iodata.tmpfilename[i],filestr);
    sprintf(filestr,"%.3d",fnumber);
    strcat(iodata.tmpfilename[i],filestr);
    strcat(iodata.tmpfilename[i],TMPEXT);
  }
  if (GPSinitflag	== TRUE) {
    strncpy(filestr,datebfr,(size_t) 2);
    strncpy(&filestr[2],&datebfr[3],(size_t) 2);
    filestr[4] = '\0';
    strcpy(iodata.gpsfilename,iodata.tmpfilepath);
    strcat(iodata.gpsfilename,filestr);
    sprintf(filestr,"%.3d",fnumber);
    strcat(iodata.gpsfilename,filestr);
    strcat(iodata.gpsfilename,GPSEXT);
  }
   
  for (i = 0; i < params.channels; i++) {
    tmpfileptr[i] = fopen(iodata.tmpfilename[i],"r");
    if (tmpfileptr[i] != NULL) { 
      save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
      sprintf(message,"Raw data file <%s> exists",iodata.tmpfilename[i]);
      _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
      _outtext(message);
      printf("\a");
      getch();
      fclose(tmpfileptr[i]);
      return(!TRUE);
    }
  }
  for (i = 0; i < params.channels; i++) {
    if ( (tmpfileptr[i] = fopen(iodata.tmpfilename[i],"w+")) == NULL) {
      save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
		sprintf(message,"Cannot create temp file <%s>",iodata.datafilename[i]);
      _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
      _outtext(message);
		printf("\a");
      getch();
      return(!TRUE);
    }
  }
  if (GPSinitflag	== TRUE) {
    if ( (gpsfileptr = fopen(iodata.gpsfilename,"w+")) == NULL) {
      save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
      sprintf(message,"Cannot create GPS data file <%s>",iodata.gpsfilename);
      _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
      _outtext(message);
      printf("\a");
      getch();
      return(!TRUE);
    }
  }
  return(TRUE);
}

/****************************************************************************
*	Function:		int Get_File_Number()
*	Description:	Ask the operator for a file number.  The number can be up
*	to three digits.  This file number is incorported into the temporary and
*	final data filenames.
****************************************************************************/
int Get_File_Number()
{
  int fnumber;
  int far  *save_box;
  char *info_box[] = {
    " Output File Number ",
    ">>                    ",
    " Enter up to 4 digits ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  menu_erase(save_box);
  fnumber = atoi(readstr);
  if (fnumber < 1 || fnumber > 999) { /* error in range specified */
    printf("Number entered (%i) is out of range\n");
    return(!TRUE);
  }
  else
    return(fnumber);
}

/*****************************************************************************
*	Function:		int Write_Raw_Data(int ptsTfr,int *dataMuxed)
*	Description:	Demux the raw (unscaled) data and write each data stream to
*	its respective temporary file.  The data will be processed later.
*****************************************************************************/
int Write_Raw_Data(int ptsTfr,int *dataMuxed)
{
  int errNum;
  int index,marker;
  unsigned int bufsize;

  for (index = 0; index < params.channels; index++) {
    for (marker = index; marker < params.ptsTfr; marker += params.channels)
      fprintf(tmpfileptr[index],"%i\t",dataMuxed[marker]);
  }
  return(TRUE);
} 

/*****************************************************************************
*	Function:		int Write_End_Record()
*	Description:	Attach an end record to each of the data files.  The end
*	record verifies successful data acquisition and date/time staps the final
*	data file.
*****************************************************************************/
int Write_End_Record()
{
  int 		index;
  time_t 	end;
  char		dateBuffer[10],timeBuffer[10];

  _strdate(dateBuffer);
  _strtime(timeBuffer);
  for (index = 0; index < params.channels; index++)	{
    fprintf(tmpfileptr[index],COMMENT_MARKER,COMMENT_END_DATA_RECORD);
    fprintf(tmpfileptr[index],END_DATA_RECORD,dateBuffer,timeBuffer);
  }
  for (index = 0; index < params.channels; index++) {
    fprintf(tmpfileptr[index],COMMENT_MARKER,COMMENT_END_FILE);
    fprintf(tmpfileptr[index],END_DATA_FILE,index);
  }
}

/*****************************************************************************
*	Function:		int Process_Raw_Data()
*	Description:	Read the raw data stored in a temporary file, scale the 
*	raw (binary) value to an actual voltage level, and write this processed
*	to file.  This operation is conducted for each of the temporary files
*	(e.g., channels scanned).  
*****************************************************************************/
int Process_Raw_Data()
{
  int channel;
  char readstr[10];
  int readval;
  double voltage;

  for (channel = 0; channel < params.channels; channel++) {
    if ( (tmpfileptr[channel] = fopen(iodata.tmpfilename[channel],"r")) == NULL ) {
      _settextposition(MESSAGE_ROW3,MESSAGE_COL3);
      printf("Unable to open temporary file for data processing.\n");
      printf("Program aborted.\n");
      exit(0);
    }
    while (!feof(tmpfileptr[channel])) {
      fscanf(tmpfileptr[channel],"%s\t",readstr);
      if (strnicmp(readstr,"G",1) == 0) {
        fprintf(datafileptr[channel],"%6s\t",readstr);
      }
		else { 
        readval = atoi(readstr);
        voltage = Scale_Data(readval,params.gain[channel]);
        fprintf(datafileptr[channel],"%lf\t",voltage);
      }
    }
    Write_End_Record();
    if (tmpfileptr == NULL)
      printf("NULL file temporary file pointer discovered\n");
    fclose(tmpfileptr[channel]);
    if (datafileptr[channel] == NULL)
      printf("NULL data file pointer discovered\n");
    fclose(datafileptr[channel]);
    remove(iodata.tmpfilename[channel]);
  }
  return(TRUE);
}

/*****************************************************************************
*	Function:		double Scale_Data(int readval,int gain)
*	Description:	Scale the A/D output (binary value) to a measured voltage.
*	This operation depends on the polarity setting on the DA board.
*****************************************************************************/
double Scale_Data(int readval,int gain)
{
  double voltage;
  
  switch(daqbrd.polarity) {
    case 0:
      /*  Bipolar mode */
      voltage = ((double)readval/2048.0) * (daqbrd.inputRange/gain);
    break;
    case 1:
      /* Unipolar mode */
      voltage = ((double)readval/4096.0) * (daqbrd.inputRange/gain);
    break;
    default:
      voltage = 0;
    break;
  }
  return(voltage);
}

/*****************************************************************************
*	Function:		int Default_Parameters()
*	Description:	Set up default DA board parameters and data acquisition
*	parameters.  This is hard coded so that parameters not specified in the
*	configuration file will have a "workable" value. 
*****************************************************************************/
int Default_Parameters()
{
  daqbrd.board = 2;				// Board installed on slot 2 of EISA Bus
  daqbrd.daqBufMode = 1; 		// Enable double buffering
  daqbrd.inputRange = 10;
  daqbrd.polarity = 1;
  daqbrd.inputMode = 0;

  params.samples = 2000;
  params.channels = 2;
  params.points = params.samples*params.channels;
  params.buffer = 2.0*(int)params.points;
  params.ptsTfr = params.samples / 2;

  params.sampleRate = 1.0;   // Sampling rate for single channel acquistions
  params.sampTimebase = 3;		// Timebase (resolution) for sample interval counter
  params.sampInterval = 2;		// Length of sample interval (elapsed time between A/D conversions)
  params.scanTimebase = 4;    // Timebase for scan interval counter
  params.scanInterval = 0;    // Length of scan interval (elasped time between scan sequences)
  params.scanchannel[0] = 0;	// Analog channels to scan
  params.scanchannel[1] = 1;
  params.gain[0] = 1;		   // Default analog channel gain factors
  params.gain[1] = 1;

  strcpy(iodata.headerfilepath,HDRPATH);
  strcpy(iodata.tmpfilepath,TMPPATH);
  strcpy(iodata.datafilepath,DATAPATH);

  return(TRUE);
} 

/*****************************************************************************
*	Function:		int Set_Graphics_Mode(void)
*	Description:	Initialize the graphics driver based on the graphics mode
*	supported by the machine.
*****************************************************************************/
int Set_Graphics_Mode(void)
{
  if (!graphics_mode) {
    graphics_mode = TRUE;
    if (_setvideomode(_VRES16COLOR) != 0)
      return(TRUE);
    if (_setvideomode(_HRES16COLOR) != 0)
      return(TRUE);
    if (_setvideomode(_MRES4COLOR) != 0)
      return(TRUE);
    printf("No graphics capability available...\n");
    return(!TRUE);
  }
}

/*****************************************************************************
*	Function:		int Create_Header_File(int fnumber)
*	Description:	Create a header file for the measurement.  One header file
*	is created for a single measurement session, so there may be several data
*	files corresponding to one header file (if multiple channels are scanned).
*	Pertinent measurement information, necessary for later data processing, is
*	stored in this file.
*****************************************************************************/
int Create_Header_File(int fnumber)
{
  int		i,lines;
  char  	operinpt[32],datebfr[10],timebfr[10],filestr[32],tmpstr[10];
  char 	ch,configfilename[64],readstr[81],buffer[6][81];
  FILE 	*configfileptr;
  int far  *save_box;
  int far  *error_message_box;

  char *error_message1[] = {
    " Error ",
    " Unable to create the header data file. ",
    " Press Any Key To Continue ",
    NULL
  };
 
  char *error_message2[] = {
    " Error ",
    " Unable to open the configuration file. ",
    " Press Any Key To Continue ",
    NULL
  };

  char *meas_descr[] = {
    " Measurement Site Description ",
    "                                                                       ",
    "                                                                       ",
    "                                                                       ",
    "                                                                       ",
    "                                                                       ",
 	 " Enter up to Five Lines of Description Text ",
    NULL
  };

  char *meas_site_class[] = {
    " Measurement Site Classification ",
    "                                       ",
    " Enter Environment Type ",
     NULL
   };

  _strdate(datebfr);
  _strtime(timebfr);
  strncpy(filestr,datebfr,(size_t) 2);
  strncpy(&filestr[2],&datebfr[3],(size_t) 2);
  filestr[4] = '\0';
  sprintf(tmpstr,"%.3d",fnumber);
  strcat(filestr,tmpstr);
  strcpy(hdrfilename,iodata.headerfilepath);
  strcat(hdrfilename,filestr);
  strcat(hdrfilename,HDREXT);
  if ( (hdrfileptr = fopen(hdrfilename,"w+")) == NULL) {
    _setbkcolor(T_WHITE);	  
    _settextcolor(T_BLACK);
    error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
    getch();
    menu_erase(error_message_box);
    return(!TRUE);
  }

  /* Duplicate legal/proprietary information */
  fprintf(hdrfileptr,LEGAL_HEADER1);  
  fprintf(hdrfileptr,LEGAL_HEADER2);
  fprintf(hdrfileptr,LEGAL_HEADER3);
  fprintf(hdrfileptr,LEGAL_HEADER4);
  fprintf(hdrfileptr,LEGAL_HEADER5);
  fprintf(hdrfileptr,LEGAL_HEADER6);
  fprintf(hdrfileptr,LEGAL_HEADER7,PROGRAM_NAME);
  fprintf(hdrfileptr,LEGAL_HEADER8,timebfr,datebfr);
  fprintf(hdrfileptr,LEGAL_HEADER9,iodata.configfilename);
  fprintf(hdrfileptr,LEGAL_HEADER10,fnumber);
  fprintf(hdrfileptr,LEGAL_HEADER11);

  /* Echo configuration file */
  if ( (configfileptr = fopen(iodata.configfilename,"r")) == NULL) {
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message2);
    getch();
    menu_erase(error_message_box);
    return(!TRUE);
  }
  while ( !feof(configfileptr) ) {
    fgets(readstr,80,configfileptr);
    fprintf(hdrfileptr,readstr);
  }

  save_box = menu_message(TEXT_ENTRY_ROW3,TEXT_ENTRY_COL3,meas_descr);
  for (i = 1; i <= 5; i++) {
    lines = i;
    _settextposition(TEXT_ENTRY_ROW3+i,TEXT_ENTRY_COL3+1);
    gets(&buffer[i][0]);
    if (strlen(&buffer[i][0]) == 0) {
      menu_erase(save_box);
      break;
    }
  }
  menu_erase(save_box);
  for (i = 1; i <= lines; i++) {
    if (strlen(&buffer[i][0]) != 0)
      fprintf(hdrfileptr,COMMENT_FORMAT,HEADER_SITE_DESCR,buffer[i]);
  }
    
  save_box = menu_message(TEXT_ENTRY_ROW3,TEXT_ENTRY_COL3,meas_site_class);
  _settextposition(TEXT_ENTRY_ROW3+1,TEXT_ENTRY_COL3+1);
  i = 0;
  while ( ch != '\r') {
    ch = getch();
    putch(ch);
    tmpstr[i] = toupper(ch);
    i++;
  }
  menu_erase(save_box);
  tmpstr[i] = '\0';
  fprintf(hdrfileptr,COMMENT_FORMAT,HEADER_SITE_CLASS,tmpstr); 

  fclose(configfileptr);
  fclose(hdrfileptr);
  return(TRUE);
}

/*****************************************************************************
*	Function:		char * Get_Config_Filename()
*	Description:	Get the base filename for the configuration data file.  The
*	configuration file holds the DA board and general measurement parameters.
*****************************************************************************/
char * Get_Config_Filename()
{
  int far  *save_box;
  char *info_box[] = {
    " Configuration Filename ",
    ">>                                        ",
    " Enter Filename ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(NULL);
  }
  menu_erase(save_box);
  return(readstr);
}
  

/*****************************************************************************
*	Function:		int Read_Config_File(char filename[])
*	Description:	Read the configuration file specified as a command line
*	argument.  Assign the measurement parameter from the configuration file
*	to its respective variable.
*****************************************************************************/
int Read_Config_File(char filename[])
{
  int		i,tmpval;
  char 	readstr[81],*tmpstr;
  FILE 	*configfileptr;
  char   message[80];

  int far *error_message_box;
  int far *status_box;

  char *error_message1[] = {
    " Error ",
    " Unable to open the configuration file. ",
    " Press Any Key To Continue ",
    NULL
  };
  char *error_message2[] = {
    " Error ",
    "                                                        ",
    " Press Any Key To Continue ",
    NULL
  };
  char *status_message1[] = {
    " Status ",
    "                                                                 ",
    " Press Any Key to Continue ",
    NULL
  };

  Default_Parameters();
  strcpy(iodata.configfilename,CONFIGPATH);
  strcat(iodata.configfilename,filename);
  if ( (configfileptr = fopen(iodata.configfilename,"r+")) == NULL) {
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
    getch();
    menu_erase(error_message_box);
    return(!TRUE);
  }
 
  while ( !feof(configfileptr) ) {
    fgets(readstr,80,configfileptr);
    tmpstr = strtok(readstr,"\t");
    if ( (tmpval = atoi(tmpstr)) <= 4)
      continue;
    else  {
      switch (tmpval) {
        case DA_BOARD_CONFIG:	/* Board Specific Parameters */
          tmpstr = strtok(NULL,"\t");
          daqbrd.board = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          daqbrd.inputRange = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          daqbrd.polarity = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          daqbrd.inputMode = atoi(tmpstr);
        break;
        case DA_BUFFER_CONFIG: /* Buffering Mode */
          tmpstr = strtok(NULL,"\t");
			 daqbrd.daqBufMode = atoi(tmpstr);
        break;
		  case DA_PARAMS: /* Data Acquisition Parameters */
          tmpstr = strtok(NULL,"\t");
          params.channels = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          params.samples = atoi(tmpstr);
          for (i = 0; i < params.channels; i++) {
            tmpstr = strtok(NULL,"\t");
            params.scanchannel[i] = atoi(tmpstr);
          }
        break;
        case ANALOG_CHANNEL_CONFIG: /* Analog Channel Gains */
          for (i = 0; i < params.channels; i++)	{
            tmpstr = strtok(NULL,"\t");
            params.gain[i] = atoi(tmpstr);
          }
        break;
        case SAMPLING_PARAMS:  /* Sampling Parameters */
          tmpstr = strtok(NULL,"\t");
          params.sampTimebase = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          params.sampInterval = atoi(tmpstr);
        break;
        case SCANNING_PARAMS: /* Scan Parameters */
          tmpstr = strtok(NULL,"\t");
          params.scanTimebase = atoi(tmpstr);
          tmpstr = strtok(NULL,"\t");
          params.scanInterval = atoi(tmpstr);
        break;
        default:
          _setbkcolor(T_WHITE);
          _settextcolor(T_BLACK);
          error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message2);
          sprintf(message,"Error: <%s>",readstr);
          _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+1);
          _outtext(message);
          getch();
			 menu_erase(error_message_box);
        break;
      }
    }
  }

  /* Additional variables to initialize based on input data */
  params.points = params.samples*params.channels;
  params.buffer = 2.0*(int)params.points;
  params.ptsTfr = params.samples / 2;

  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);
  status_box = menu_message(STATUS_MESSAGE_ROW1,STATUS_MESSAGE_COL1,status_message1);
  sprintf(message,"File <%s> read successfully",iodata.configfilename);
  _settextposition(STATUS_MESSAGE_ROW1+1,STATUS_MESSAGE_COL1+2);
  _outtext(message);
  printf("\a");
  getch();
  menu_erase(status_box);
  fclose(configfileptr);
  ConfigFileflag = TRUE;
  return(TRUE);
}

/****************************************************************************
*	Function:		Print_Parameters()
*	Description:	Print the DA board parameters.  Used for debugging only.
*****************************************************************************/
Print_Parameters()
{
  printf("daqbrd.board = %i\n",daqbrd.board); 
  printf("daqbrd.daqBufMode = %i\n",daqbrd.daqBufMode);
  printf("daqbrd.inputRange = %i\n",daqbrd.inputRange);
  printf("daqbrd.polarity = %i\n",daqbrd.polarity);
  printf("daqbrd.inputMode = %i\n",daqbrd.inputMode);

  printf("params.samples = %u\n",params.samples);
  printf("params.channels = %i\n",params.channels);
  printf("params.points = %i\n",params.points);
  printf("params.buffer = %i\n",params.buffer);
  printf("params.ptsTfr = %i\n",params.ptsTfr);

  printf("params.sampTimebase = %i\n",params.sampTimebase);
  printf("params.sampInterval = %u\n",params.sampInterval);
  printf("params.scanTimebase = %i\n",params.scanTimebase);
  printf("params.scanInterval = %u\n",params.scanInterval);
  printf("params.scanchannel[0] = %i\n",params.scanchannel[0]);
  printf("params.scanchannel[1] = %i\n",params.scanchannel[1]);
  printf("params.gain[0] = %i\n",params.gain[0]);
  printf("params.gain[1] = %i\n",params.gain[1]);

  getch();

  return(TRUE);
}
/*****************************************************************************
*	Function:	void Annotate(int xdispl,int ydispl,char annotate[])
*****************************************************************************/
void Annotate(int xdispl,int ydispl,char annotate[])
{
  _moveto(xdispl,ydispl);
  _outtext(annotate);
}												 

/*****************************************************************************
*	Function:	void Annotate_W(float xdispl,float ydispl,char annotate[])
*****************************************************************************/
void Annotate_W(float xdispl,float ydispl,char annotate[])
{
  _moveto_w(xdispl,ydispl);
  _outtext(annotate);
}

/*****************************************************************************
*	Function:	void reset_graphics(void)
*****************************************************************************/
void reset_graphics (void)
{
  _unregisterfonts();
  _setvideomode(_DEFAULTMODE);
  graphics_mode = !TRUE;
  _clearscreen(_GCLEARSCREEN);
}

/*****************************************************************************
*	Function:		Do_Measurement()
*	Description:	Main measurement routine.  This function controls the data
*	acquistion subroutines and provides ancillarly data collection utilities,
*	such as GPS position data and measurement header data.
*****************************************************************************/
int Do_Measurement()
{
  int i,keypressed;
  int errNum,status;
  int code,quit,fnumber,exitloop;
  int *dataBuffer,*dataHalfBuffer;
  long numTimeOutTicks;
  int far *save_meas_headr,*save_status,*save_error; 
  char message[64];
  int marker;

  char *meas_headr[] =
  {
    "",
    "Southwestern Bell Technology Resources, Inc.",
    "       Narrow Band Measurement Software",
    "",
    NULL
  };

  char *status_message1[] = 
  {
    " Measurement Status ",
    "                                                        ",
    "",
    NULL
  };
 
  char *error_message1[] = 
  {
    " General System Error ",
    "                                                        ",
    " Press Any Key To Continue ",
    NULL
  };
 
  char *error_message2[] = 
  {
    " General System Error ",
    "                                                             ",
    " Press 'Esc' to quit or any other key to continue",
    NULL
  };
 
  /* Re-initialize video */
  _setvideomode(_TEXTC80);
  _clearscreen(_GCLEARSCREEN);
  _setbkcolor(T_BLUE);
  box_color(1,1,25,80);

  quit = !TRUE;

  save_meas_headr = menu_message(1, 16, meas_headr);

  if ( Check_Free_Disk_Space() == !TRUE ) {
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    save_error = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message2);
    sprintf(message,"WARNING: Less than %i Mbytes of disk space",(MIN_FREE_DISK_SIZE/1000));
	 _settextposition(ERROR_MESSAGE_ROW+1,ERROR_MESSAGE_COL+2);
    _outtext(message);
    printf("\a");
    keypressed = getch();
    if (keypressed == 0x1b) {
      Restore_State();
      exit(0);
    }
    else
      menu_erase(save_error);
  }
  if (ConfigFileflag == !TRUE)
    Default_Parameters();
  if ( !(fnumber = Get_File_Number()) ) {
    Restore_State();
    exit(0);
  }
  if ( !Open_Temporary_File(fnumber) ) {
    Restore_State();
    exit(0);
  }

/* On-line data processing disabled.  Only the raw data is written to file.
   This is necessary to speed up data acquisition rates as the data processing
   requires LOTS of compuation time and disk access.
 
  if ( !Open_Data_File(fnumber) ) {
    Restore_State();
    exit(0);
  }
*/

  if ( !Create_Header_File(fnumber) ) {
    Restore_State();
    exit(0);
  }

  save_status = menu_message(MESSAGE_ROW1,MESSAGE_COL1,status_message1);
  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);
   errNum = Get_DA_Brds_Info(daqbrd.board,&daqbrd.boardCode,&daqbrd.baseAddr,
                            &daqbrd.irq1Lvl,&daqbrd.irq2Lvl,&daqbrd.irqTrigMode,
                            &daqbrd.dma1Lvl,&daqbrd.dma2Lvl,&daqbrd.daqMode);
  Process_Error_Code(errNum);
  sprintf(message,"Parameters retrieved for data acquisition board.         ");
  _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
  _outtext(message);
  errNum = Init_DA_Brds(daqbrd.board,&daqbrd.boardCode);
  Process_Error_Code(errNum);
  errNum = AI_Config(daqbrd.board,daqbrd.inputMode,daqbrd.inputRange,daqbrd.polarity);
  Process_Error_Code(errNum);
  if (numTimeOutTicks < 20L) numTimeOutTicks = 20L;
  errNum = Timeout_Config(daqbrd.board,numTimeOutTicks);
  Process_Error_Code(errNum);
  errNum = DAQ_DB_Config(daqbrd.board,daqbrd.daqBufMode);
  Process_Error_Code(errNum);
  dataBuffer = (int *) calloc(params.buffer,sizeof(int));
  dataHalfBuffer = (int *) calloc(params.buffer,sizeof(int));
  sprintf(message,"Data acquisition board and buffers initialized.          ");
  _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
  _outtext(message);
  errNum = SCAN_Setup(daqbrd.board,params.channels,params.scanchannel,params.gain);
  if (errNum == 0)
  sprintf(message,"Multi-channel scan setup complete.                       ");
  _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
  _outtext(message);
  sprintf(message,"Ready to begin data acquistion - Press any key to begin. ");
  _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
  _outtext(message);
  getch();
  Empty_Keyboard_Buffer();
  errNum = SCAN_Start(daqbrd.board,dataBuffer,params.points,
                        params.sampTimebase,params.sampInterval,
                        params.scanTimebase,params.scanInterval);
  Process_Error_Code(errNum);
  while (!quit) 
  {
    sprintf(message,"MEASURING - 'Esc' to Quit or 'Enter' to End DA Operation");
    _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
    _outtext(message);
    errNum = DAQ_DB_Transfer(daqbrd.board,dataHalfBuffer,&params.ptsTfr,&status);
	 if (errNum != TRUE)
      Process_Error_Code(errNum);
    if (GPSinitflag == TRUE)
      Write_GPS_Data();
	 Write_Raw_Data((int)params.ptsTfr,dataHalfBuffer);
    if ( kbhit() )
    {
      code = getch();
      Empty_Keyboard_Buffer();
      if (code == 0x1b)
      {
        errNum = DAQ_Clear(daqbrd.board);
        Restore_State();
        exit(0);
      }
      else if (code == '\r')
      {
        errNum = DAQ_Clear(daqbrd.board);
        free(dataHalfBuffer);
        free(dataBuffer);
        Write_End_Record();
        for (i = 0; i < params.channels; i++)
          fclose(tmpfileptr[i]);
        sprintf(message,"Processing temporary files.  Please wait....              ");
        _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
        _outtext(message);

/*      Process_Raw_Data();  On-line data processing disabled.              */

        sprintf(message,"Data Acquistion Complete - Press Any Key            ");
        _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
        _outtext(message);
		  printf("\a");
		  getch();
        menu_erase(save_status);
        if (GPSinitflag == TRUE) {
          menu_erase(save_gps_status);
          tans_restore();
        }
        if (MKRinitflag == TRUE)
          menu_erase(save_marker_status);
        menu_erase(save_meas_headr);
        return(TRUE);
      }
      else if (code == 'p')
	   {
        sprintf(message,"Data Acquistion Paused - Press 'Enter' to Resume        ");
        _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
        _outtext(message);
		  printf("\a");
		  Empty_Keyboard_Buffer();
        while (!quit) {
          errNum = DAQ_DB_Transfer(daqbrd.board,dataHalfBuffer,&params.ptsTfr,&status);
          if ( kbhit() ) {
            code = getch();
            if (code == 0x1b) {
              errNum = DAQ_Clear(daqbrd.board);
		        _clearscreen(_GCLEARSCREEN);
              exit(0);
            }
            else if (code == '\r')
            {
              quit = TRUE;
              sprintf(message,"Resuming data acqusition                      ");
  				  _settextposition(MESSAGE_ROW1+1,MESSAGE_COL1+1);
				  _outtext(message);
              if (GPSinitflag == TRUE)
                Write_GPS_Data();
	           Write_Raw_Data((int)params.ptsTfr,dataHalfBuffer);
            }
          }
        }
        quit = !TRUE;
      }
      else if (code == 'm') {
        MKRinitflag = TRUE;
        Write_Marker();
      }
	 }
  }
}

/*****************************************************************************
*	Function:		int Get_Calfilename()
*****************************************************************************/
int Get_Calfilename()
{
  int far  *save_box;
  FILE *calfileptr;
  char *info_box[] = {
    " Calibration File ",
    ">>                                        ",
    " Enter Path and Filename ",
    NULL
  };
  char readstr[96];
  char *error_message1[] = 
  {
    " File I/O Error ",
    "                                                        ",
    " Press Any Key To Continue ",
    NULL
  };
  char message[64];
  int far *save_error;

  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  if (strlen(iodata.calfilepath) > 0)
    strcpy(caldata.calfilename,iodata.calfilepath);
  else 
    strcpy(caldata.calfilename,CALPATH);
  strcat(caldata.calfilename,readstr);
  if( (calfileptr = fopen(caldata.calfilename,"r")) != NULL) {
    menu_erase(save_box);
    save_error = menu_message(MESSAGE_ROW3,MESSAGE_COL3,error_message1);
	 sprintf(message,"Calibration file <%s> exists",caldata.calfilename);
    _settextposition(MESSAGE_ROW3+1,MESSAGE_COL3+1);
    _outtext(message);
	 printf("\a");
	 getch();
    fclose(calfileptr);
    menu_erase(save_error);
    return(!TRUE);
  }
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Set_DA_Parameters()
*	Decription:		Function to set default data acquisition parameters for 
*	a receiver calibration session.
*****************************************************************************/
int Set_DA_Parameters()
{
  int i;
  int far  *save_box;
  char *info_box[] = {
    " Data Acquistion Parameters ",
    "GPIB Address      >>     ",
    "Analog Channel    >>     ",
    "Number of Samples >>     ",
    "Sampling Rate     >>     ",
    "",
    NULL
  };
  char readstr[8][8];

  Default_Parameters();
  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  for (i = 1; i <= 4; i++) {
    _settextposition(TEXT_ENTRY_ROW+i,TEXT_ENTRY_COL+23);
    gets(readstr[i]);
    if ( strlen(readstr[i]) == 0 )
    {
      menu_erase(save_box);
      return(!TRUE);
    }
  }
  caldata.dev_id = atoi(readstr[1]);
  caldata.channel = atoi(readstr[2]);
  caldata.samples = atoi(readstr[3]);
  caldata.sampleRate = atof(readstr[4]);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Set_Calibration_Frequency()
*****************************************************************************/
int Set_Calibration_Frequency()
{

  int far  *save_box;
  char *info_box[] = {
    " Calibration Frequency ",
    ">>      "	,
    " Specify Calibration Frequency in MHz ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  caldata.frequency = atof(readstr);
  menu_erase(save_box);
  return(TRUE);
}
/*****************************************************************************
*	Function:		int Set_Calibration_Range()
*****************************************************************************/
int Set_Calibration_Range()
{
  int far  *save_box;
  char *info_box[] = {
    " Calibration Range ",
    "Minimum Input Signal Level >>         ",
    "Maximum Input Signal Level >>         ",
	 " Specify Calibration Range in dBm ",
    NULL
  };
  char readstr1[10],readstr2[10];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+32);
  gets(readstr1);
  _settextposition(TEXT_ENTRY_ROW+2,TEXT_ENTRY_COL+32);
  gets(readstr2);
  if (strlen(readstr1) == 0 || strlen(readstr2) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  caldata.mindBmlvl = atof(readstr1);
  caldata.maxdBmlvl = atof(readstr2);
  menu_erase(save_box);
  return(TRUE);
}
/*****************************************************************************
*	Function:		int Set_Calibration_Increment()
*****************************************************************************/
int Set_Calibration_Increment()
{

  int far  *save_box;
  char *info_box[] = {
    " Calibration Increment ",
    ">>     ",
    " Specify Calibration Increment in dBm ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  caldata.dBmstep = atof(readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Calibrate_Receiver()
*****************************************************************************/
int Calibrate_Receiver()
{
  int index,errNum;
  int fsg_ud;
  FILE *calfileptr;
  int *dataBuffer;
  double *voltageArray;
  float avgval;
  int numSteps;
  float currdBmlvl;
  int count;
  char message[80];
  long numTimeOutTicks;
  float frequency,level;
  char datebfr[10],timebfr[10];

  int far *error_message_box;
  int far *measurement_status_box;

  char *error_message1[] = {
    " GPIB Error ",
    "Unable to open connection to signal generator.",
    "Check the unit's power supply and cable connections.",
    " Press Any Key To Continue ",
    NULL
  };
  char *error_message2[] = {
    " Error ",
    " Unable to open the output calibration data file. ",
    " Press Any Key To Continue ",
    NULL
  };
  char *status_message1[] = {
    " Calibration Status ",
    "                                                          ",
    "",
    NULL
  };

  _setbkcolor(T_WHITE);
  _settextcolor(T_BLACK);
  /* Open GPIB connection and set signal generator to some initial state */
  fsg_ud = gpib_open(caldata.dev_id);
  if (fsg_ud < 0) {
    error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
	 getch();
    menu_erase(error_message_box);
	 return(!TRUE);
  }
  fsg_reset_hpsl(fsg_ud);
  fsg_rf_hpsl(fsg_ud,RFOFF);
 
  if ( ( calfileptr = fopen(caldata.calfilename,"w+") ) == NULL) {
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message2);
    getch();
    return(!TRUE);
  }

  _strdate(datebfr);
  _strtime(timebfr);

  /* Duplicate legal/proprietary information */
  fprintf(calfileptr,LEGAL_HEADER1);  
  fprintf(calfileptr,LEGAL_HEADER2);
  fprintf(calfileptr,LEGAL_HEADER3);
  fprintf(calfileptr,LEGAL_HEADER4);
  fprintf(calfileptr,LEGAL_HEADER5);
  fprintf(calfileptr,LEGAL_HEADER6);
  fprintf(calfileptr,LEGAL_HEADER7,PROGRAM_NAME);
  fprintf(calfileptr,LEGAL_HEADER8,timebfr,datebfr);
  fprintf(calfileptr,LEGAL_HEADER9,caldata.calfilename);
  fprintf(calfileptr,LEGAL_HEADER11);

  errNum = Get_DA_Brds_Info(daqbrd.board,&daqbrd.boardCode,&daqbrd.baseAddr,
                            &daqbrd.irq1Lvl,&daqbrd.irq2Lvl,&daqbrd.irqTrigMode,
                            &daqbrd.dma1Lvl,&daqbrd.dma2Lvl,&daqbrd.daqMode);
  Process_Error_Code(errNum);
  errNum = Init_DA_Brds(daqbrd.board,&daqbrd.boardCode);
  Process_Error_Code(errNum);
  errNum = AI_Config(daqbrd.board,daqbrd.inputMode,daqbrd.inputRange,daqbrd.polarity);
  Process_Error_Code(errNum);
 
  numSteps = floor( (caldata.maxdBmlvl - caldata.mindBmlvl)/caldata.dBmstep );
  dataBuffer = (int *)calloc(caldata.samples,sizeof(int));
  voltageArray = (double *)calloc(caldata.samples,sizeof(int));

  measurement_status_box = menu_message(STATUS_MESSAGE_ROW1,STATUS_MESSAGE_COL1,status_message1);

  for (count = 0; count <= numSteps; count++) {
    avgval = 0.0;
    currdBmlvl = caldata.mindBmlvl + count*caldata.dBmstep;
    fsg_freqMHz_hpsl(fsg_ud,caldata.frequency);
    fsg_ampdBm_hpsl(fsg_ud,currdBmlvl);
    fsg_rf_hpsl(fsg_ud,RFON);
	 Wait(3);
    errNum = DAQ_Op(daqbrd.board,params.scanchannel[caldata.channel],params.gain[caldata.channel],
                    dataBuffer,caldata.samples,caldata.sampleRate);
    Process_Error_Code(errNum);
    errNum = DAQ_Scale(daqbrd.board,params.gain[caldata.channel],caldata.samples,dataBuffer,voltageArray);
    Process_Error_Code(errNum);
    for (index = 0; index < caldata.samples; index++)
      avgval += voltageArray[index];
    avgval = avgval/(float)caldata.samples;
    fprintf(calfileptr,"%f\t%f\n",currdBmlvl,avgval); 
    sprintf(message,"Calibrated at %.2f for %.2f dBm input signal level    ",caldata.frequency,currdBmlvl);
    _settextposition(STATUS_MESSAGE_ROW1+1,STATUS_MESSAGE_COL1+1);
    _outtext(message);
    currdBmlvl += caldata.dBmstep;
  }

  strcpy(message,"Receiver calibration complete.  Press any key to continue.");
  _settextposition(STATUS_MESSAGE_ROW1+1,STATUS_MESSAGE_COL1+1);
  _outtext(message);
  getch();
        
  errNum = DAQ_Clear(daqbrd.board);
  fsg_rf_hpsl(fsg_ud,RFOFF);
  gpib_local(fsg_ud);

  fprintf(calfileptr,COMMENT_MARKER,COMMENT_END_DATA_RECORD);
  fprintf(calfileptr,END_DATA_RECORD,datebfr,timebfr);
  fprintf(calfileptr,COMMENT_MARKER,COMMENT_END_FILE);
  fprintf(calfileptr,END_DATA_FILE,index);
  fclose(calfileptr);

  menu_erase(measurement_status_box);
  return(TRUE);
}  
 
/*****************************************************************************
*	Function:		int DA_Board_Config()
*****************************************************************************/
int DA_Board_Config()
{
  int far  *save_box;
  char *info_box[] = {
    " Data Acquisition Board Configuration ",
    "DA Board Number               >>   ",
    "Analog Channel Input Range    >>   ",
    "Analog Channel Input Polarity >>   ",
    "Analog Channel Input Mode     >>   ",
	 " Specify All Data Acqusition Board Parameters ",
    NULL
  };
  char readstr1[10],readstr2[10],readstr3[10],readstr4[10];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+35);
  gets(readstr1);
  _settextposition(TEXT_ENTRY_ROW+2,TEXT_ENTRY_COL+35);
  gets(readstr2);
  _settextposition(TEXT_ENTRY_ROW+3,TEXT_ENTRY_COL+35);
  gets(readstr3);
   _settextposition(TEXT_ENTRY_ROW+4,TEXT_ENTRY_COL+35);
  gets(readstr4);
  if (strlen(readstr1) == 0 || strlen(readstr2) == 0
      || strlen(readstr3) == 0 || strlen(readstr4) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  daqbrd.board = atoi(readstr1);
  daqbrd.daqBufMode = atoi(readstr2);
  daqbrd.polarity = atoi(readstr3);
  daqbrd.inputMode = atoi(readstr4);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Channel_Config()
*****************************************************************************/
int Channel_Config()
{
  int index;
  int far *save_box1;
  int far *save_box2; 
  char *info_box1[] = {
    " Analog Channel Configuration ",
    "Number of Channels >>   ",
	 " Specify the Number of Channels to Measure ",
    NULL
  };
  char *info_box2[] = {
    " Single Channel Configuration ",
    "                                    ",
    "DA Channel Number >>  ",
    "Channel Gain (dB) >>  ",
    "",
    NULL
  };
 
  char readstr1[10],readstr2[10],readstr3[10],message[40];

  save_box1 = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box1);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+23);
  gets(readstr1);
  if (strlen(readstr1) == 0 || (params.channels = atoi(readstr1)) == 0)
  {
    menu_erase(save_box1);
    return(!TRUE);
  }
  for (index = 0; index < params.channels; index++) {
    save_box2 = menu_message(TEXT_ENTRY_ROW2,TEXT_ENTRY_COL2,info_box2);  
	 sprintf(message,"Enter parameters for scan channel %1i",index);
    _settextposition(TEXT_ENTRY_ROW2+1,TEXT_ENTRY_COL2+1);
    _setbkcolor(T_WHITE);
    _settextcolor(T_BLACK);
    _outtext(message);
    _settextposition(TEXT_ENTRY_ROW2+2,TEXT_ENTRY_COL2+22);
    gets(readstr2);
    _settextposition(TEXT_ENTRY_ROW2+3,TEXT_ENTRY_COL2+22);
    gets(readstr3);
    if (strlen(readstr2) == 0 || strlen(readstr3) == 0)
    {
      menu_erase(save_box1);
      menu_erase(save_box2);
      return(!TRUE);
    }
	 params.scanchannel[index] = atoi(readstr2);
    params.gain[index] = atoi(readstr3);
    menu_erase(save_box2);
  }
  menu_erase(save_box1);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Sampling_Config()
*****************************************************************************/
int Sampling_Config()
{
  int far  *save_box;
  char *info_box[] = {
    " Analog Channel Sampling Configuration ",
    "Number of Sample Points   >>  ",
    "Channel Sampling Timebase >>   ",
    "Channel Sampling Interval >>   ",
	 " Specify All Analog Channel Sampling Parameters ",
    NULL
  };
  char readstr1[10],readstr2[10],readstr3[10];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+31);
  gets(readstr1);
  _settextposition(TEXT_ENTRY_ROW+2,TEXT_ENTRY_COL+31);
  gets(readstr2);
  _settextposition(TEXT_ENTRY_ROW+3,TEXT_ENTRY_COL+31);
  gets(readstr3);
  if (strlen(readstr1) == 0 || strlen(readstr2) == 0 || strlen(readstr3) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  params.samples = atoi(readstr1);
  params.sampTimebase = atoi(readstr2);
  params.sampInterval = atoi(readstr3);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Scan_Config()
*****************************************************************************/
int Scan_Config()
{
  int far  *save_box;
  char *info_box[] = {
    " Multichannel Scan Configuration ",
    "Channel Scanning Timebase >>   ",
    "Channel Scanning Interval >>   ",
	 " Specify All Analog Channel Sampling Parameters ",
    NULL
  };
  char readstr1[10],readstr2[10];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+31);
  gets(readstr1);
  _settextposition(TEXT_ENTRY_ROW+2,TEXT_ENTRY_COL+31);
  gets(readstr2);
  if (strlen(readstr1) == 0 || strlen(readstr2) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  params.scanTimebase = atoi(readstr1);
  params.scanInterval = atoi(readstr2);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Get_Tempfile_Path()
*	Description:	Get the path to create the tempfile under
*****************************************************************************/
int Get_Tempfile_Path()
{

  int far  *save_box;
  char *info_box[] = {
    " Temporary File ",
    ">>                                        ",
    " Enter Temporary File Path ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  strcpy(iodata.tmpfilepath,readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Get_Datafile_Path()
*	Description:	Get the path to create the datafile under
*****************************************************************************/
int Get_Datafile_Path()
{

  int far  *save_box;
  char *info_box[] = {
    " Output Data File ",
    ">>                                        ",
    " Enter Data File Path ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  strcpy(iodata.datafilepath,readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Get_Calfile_Path()
*	Description:	Get the path to create the configuration file under
*****************************************************************************/
int Get_Calfile_Path()
{

  int far  *save_box;
  char *info_box[] = {
    " Calibration Data File ",
    ">>                                        ",
    " Enter Calibration File Path ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  strcpy(iodata.calfilepath,readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Get_Header_Path()
*	Description:	Get the path to create the configuration file under
*****************************************************************************/
int Get_Header_Path()
{

  int far  *save_box;
  char *info_box[] = {
    " Header Data File ",
    ">>                                        ",
    " Enter Header File Path ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+5);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  strcpy(iodata.headerfilepath,readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Get_Buffer_Size()
*	Description:	Get the buffer size for DA board data acquisitions
*****************************************************************************/
int Get_Buffer_Size()
{

  int far  *save_box;
  char *info_box[] = {
    " Data Acquisition Buffering ",
    "Buffer Size >>                 ",
    " Enter Buffer Size in Elements ",
    NULL
  };
  char readstr[96];

  save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
  _settextposition(TEXT_ENTRY_ROW+1,TEXT_ENTRY_COL+16);
  gets(readstr);
  if (strlen(readstr) == 0)
  {
    menu_erase(save_box);
    return(!TRUE);
  }
  params.buffer = atoi(readstr);
  menu_erase(save_box);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Control_Double_Buffering()
*	Description:	Control the double buffering operation of the DA board
*****************************************************************************/
int Control_Double_Buffering()
{
  int keypressed;
  int far *drop_toggle_menu;
  char *toggle_menu[] = 
	{
	" Buffering ",
	"On",
	"Off",
	"",
	NULL
	};

   drop_toggle_menu = menu_drop(12,52,toggle_menu,&keypressed);
	if (keypressed == 1)	{
     daqbrd.daqBufMode = 1;		// Enable double buffering
   }
   if(keypressed == 2) {
     daqbrd.daqBufMode = 0; 		// Disable double buffering
   }
   menu_erase(drop_toggle_menu);
	return(TRUE);
}

/*****************************************************************************
*	Function:		Signal_Generator_Operation()
*	Description:	Function to control the signal generator. The signal 
*	generator is used to provide LO drive or is used for system calibration.
*****************************************************************************/
int Signal_Generator_Operation()
{
  static int fsg_ud;
  int keypressed,keypressed2;
  int far  *save_box,*save_drop_siggen,*error_message_box;
  char *drop_siggen_menu[] = {
    " Operate Signal Generator ",
	 "Establish/Reset Connection",
    "Toggle RF Output On/Off",
    "Configure Signal Generator",
    "",
    NULL,
  };
  char *drop_toggle_menu[] = {
    " Toggle RF Output ",
    "Activate RF Output",
    "Deactivate RF Output",
    "",
    NULL
  };
  char *info_box[] = {
    " RF Signal Generator Configuration ",
    "GPIB Device Address     >>  ",
    "Center Frequency (MHz)  >>  ",
    "RF Output Power (dBm)   >>  ",
	 "",
    NULL
  };
  char *error_message1[] = {
    " GPIB Error ",
    "Unable to open connection to signal generator.",
    "Check the unit's power supply and cable connections.",
    " Press Any Key To Continue ",
    NULL
  };
  char readstr1[10],readstr2[10],readstr3[10];

  save_drop_siggen = menu_drop(12,20,drop_siggen_menu,&keypressed);
  switch (keypressed)  {
    case 1: /* Open/Reset connection to the signal generator */
      fsg_ud = gpib_open(siggen.dev_id);
      if (fsg_ud < 0) {
        error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
	     getch();
        menu_erase(error_message_box);
	     return(!TRUE);
      }
      fsg_reset_hpsl(fsg_ud);
      fsg_rf_hpsl(fsg_ud,RFOFF);
    break;
    case 2: /* Control RF output */
	   menu_erase(menu_drop(19,20,drop_toggle_menu,&keypressed2));
      if (keypressed2 == 1) {
        fsg_freqMHz_hpsl(fsg_ud,siggen.cfreq);
        fsg_ampdBm_hpsl(fsg_ud,siggen.rfampl);
        fsg_rf_hpsl(fsg_ud,RFON);
      }
      else if (keypressed2 == 2)
        fsg_rf_hpsl(fsg_ud,RFOFF);
    break;
    case 3:	/* Configure Signal Generator */
      save_box = menu_message(TEXT_ENTRY_ROW2,TEXT_ENTRY_COL2,info_box);
      _settextposition(TEXT_ENTRY_ROW2+1,TEXT_ENTRY_COL2+31);
      gets(readstr1);
      _settextposition(TEXT_ENTRY_ROW2+2,TEXT_ENTRY_COL2+31);
      gets(readstr2);
      _settextposition(TEXT_ENTRY_ROW2+3,TEXT_ENTRY_COL2+31);
      gets(readstr3);
      if (strlen(readstr1) == 0 || strlen(readstr2) == 0 || strlen(readstr3) == 0)
      {
        menu_erase(save_box);
        return(!TRUE);
      }
      siggen.dev_id = atoi(readstr1);
      siggen.cfreq = atof(readstr2);
      siggen.rfampl = atof(readstr3);
      menu_erase(save_box);
    break;
  }
  menu_erase(save_drop_siggen);
  return(TRUE);
}

/*****************************************************************************
*	Function:		int Spectrum_Analyzer_Operator()
*	Description:	Function to control the spectrum analyzer.  The analyzer
*	is used as a downconverter and detector in the measurement system.
*****************************************************************************/
int Spectrum_Analyzer_Operation()
{
  int i;
  static int rfsa_ud;
  int keypressed,keypressed2;
  int far  *save_box,*save_drop_siggen,*error_message_box;
  char *drop_siggen_menu[] = {
    " Operate Spectrum Analyzer ",
    "Configure Spectrum Analyzer",
	 "Activate Spectrum Analyzer",
    "Deactivate Spectrum Analyzer",
    "",
    NULL,
  };
  char *info_box[] = {
    " RF Signal Generator Configuration ",
    "GPIB Device Address        >>    ",
    "Center Frequency (MHz)     >>    ",
    "Frequency Span (MHz)       >>    ",
    "Resolution Bandwidth (kHz) >>    ",
    "Video Bandwidth (kHz)      >>    ",
	 "Trace Sweep Time (msec)    >>    ",
    "Reference Level (dBm)      >>    ",
    "Input Attenuation (dB)     >>    ",
	 "",
    NULL
  };
  char *error_message1[] = {
    " GPIB Error ",
    "Unable to open connection to signal generator.",
    "Check the unit's power supply and cable connections.",
    " Press Any Key To Continue ",
    NULL
  };
  char *disable_box[] = {
    " Disable Spectrum Analyzer ",
    "GPIB Address >>  ",
    " Enter the GPIB Address ",
    NULL
  };

  char readstr[10][10];

  save_drop_siggen = menu_drop(10,10,drop_siggen_menu,&keypressed);
  switch (keypressed)  {
    case 1:	/* Configure Signal Generator */
      save_box = menu_message(TEXT_ENTRY_ROW,TEXT_ENTRY_COL,info_box);
		for (i = 1; i <= 8; i++) {
        _settextposition(TEXT_ENTRY_ROW+i,TEXT_ENTRY_COL+32);
        gets(readstr[i]);
      }
      for (i = 1; i <= 8; i++) {
        if (strlen(readstr[i]) == 0)
        {
          menu_erase(save_box);
          menu_erase(save_drop_siggen);
          return(!TRUE);
        }
      }
      specan.dev_id = atoi(readstr[1]);
      specan.cfreq = atof(readstr[2]);
	   specan.span = atof(readstr[3]);
      specan.resbw = atof(readstr[4]);
      specan.vidbw = atof(readstr[5]);
		specan.sweep = atof(readstr[6]);
      specan.reflvl = atof(readstr[7]);
      specan.atten = atoi(readstr[8]);
      menu_erase(save_box);
    break;
    case 2: /* Open connection to the signal generator */
      rfsa_ud = gpib_open(specan.dev_id);
      if (rfsa_ud < 0) {
        error_message_box = menu_message(ERROR_MESSAGE_ROW,ERROR_MESSAGE_COL,error_message1);
	     getch();
        menu_erase(error_message_box);
	     return(!TRUE);
      }
      hsa_cf(rfsa_ud,specan.cfreq*1.0E6);
      hsa_span(rfsa_ud,specan.span*1.0E6);
      hsa_sweep_time(rfsa_ud,specan.sweep/1.0E3);
      hsa_rb(rfsa_ud,specan.resbw*1.0E3);
      hsa_vb(rfsa_ud,specan.vidbw*1.0E3);
      hsa_atten(rfsa_ud,specan.atten); 
      hsa_ref_level(rfsa_ud,specan.reflvl);
 		if (specan.dev_id == 11)
        gpib_write(rfsa_ud,"ADJIF OFF");
    break;
    case 3:  /* Close spectrum analyzer connection */
      gpib_local(rfsa_ud);
    break;  
  }
  menu_erase(save_drop_siggen);
  return(TRUE);
}

/*****************************************************************************
*	Function:		Restore_State()
*	Description:	Resotore the screen to an original state before quitting the 
*	program.  This is necessary to clear out the menu based graphic screen.
*****************************************************************************/
int Restore_State()
{
   tans_restore();
   _setbkcolor(T_BLACK);
	_clearscreen(_GCLEARSCREEN);
}

/*****************************************************************************
*	Function:		int Wait(int tdelay)
*****************************************************************************/
int Wait(int tdelay)
{
  time_t start_time,curr_time;
  double curr_delay;

  curr_delay = 0.0;
  time(&start_time);
  while (curr_delay <= tdelay) {
    time(&curr_time);
    curr_delay = difftime(curr_time,start_time);
  }     
  return(TRUE);
}

/*****************************************************************************
*	Function:		main()
*****************************************************************************/
main()
{
  int keypressed, keypressed1;
  int bar_choice = TRUE;
  int quit_flag = !TRUE;
  int first_time = TRUE;
  int calflag = 0;
  int daflag = 0;
  char *configname;

char *intro_headr[] =
   {
   "",
   "Southwestern Bell Technology Resources, Inc.",
   "       Narrow Band Measurement Software",
   "",
   NULL
   };
char *intro_descr[] =
	{
   "",
	"This software is used to capture narrow band signal strength",
	"data.  The software is totally automated and can be configured",
	"to acquire data (voltage samples) from up to 8 channels at a",
	"sampling rate of up to 1 Msamples/sec.  The samples are recorded",
	"with a multichannel National Instruments Data Acquistion Board.",
	"For moving measurements position fixes are provided by a Global",
   "Positioning System (GPS).  Specific measurement parameters are",
   "defined in a configuration file or can be entered by the operator.",
   "",
	"<Press any key to continue>",
	NULL
	};

char *bar_main = "  Calibration  Data acquistion  Input/output  Measurement  Quit  ";

char *drop_calibration[] =
	{
	" Receiver Calibration ",
	"Output Filename",
   "Data Acquisition Parameters",
   "Frequency of Calibration",
   "Range of Calibration",
   "Calibration Increment",
   "Begin Calibration",
	"",
	NULL
	};

char *drop_DA_configuration[] =
	{
	" Data Acquisition Board",
	"DA Board Configuration",
   "Analog Channel Configuration",
	"Channel Sampling Configuration",
	"Muliple Channel Scan Configuration",
	"",
	NULL
	};

char *drop_IO_configuration[] =
	{
	"  I/O Configuration ",
	"Header File Path",
   "Temporary File Path",
   "Output Data File Path",
	"Calibration File Path",
	"Control Double Buffering",
	"Specify Buffer Size",
	"",
	NULL
	};

char *drop_measurement[] =
	{
   "Measurement",
	"Get Configuration Data",
	"Toggle GPS Receiver",
	"Operate Signal Generator",
   "Set Spectrum Analyzer",
	"Begin Measurement",
   "",
	NULL
	};

char *drop_quit[] =
	{
	" Quit? ",
	"No",
	"Yes",
	"",
	NULL
	};

  int far *save_intro_headr;
  int far *save_bar_main;
  int far *save_drop_DA_configuration;
  int far *save_intro_descr;
  int far *save_drop_cal_menu;
  int far *save_drop_meas_menu;
  int far *save_drop_IO_menu;

  /* initialize video */
  _setvideomode(_TEXTC80);
  _clearscreen(_GCLEARSCREEN);
  _setbkcolor(T_BLUE);
  box_color(1,1,25,80);

  /* main loop begins here */
  while(!quit_flag)
  {
    /* display the information box */
     if (first_time)
     {
       first_time = 0;
       save_intro_headr = menu_message(4, 16, intro_headr);
       save_intro_descr = menu_message(10, 6, intro_descr);
       getch();
  	    _clearscreen(_GCLEARSCREEN);
     }

     /* the main menu bar */
     save_bar_main = menu_bar(2, 2, bar_main, &bar_choice);
     switch(bar_choice)
     {
       case 1:
		   save_drop_cal_menu = menu_drop(4, 6, drop_calibration, &keypressed);
         switch (keypressed) 
         {
           case 1:
             calflag += Get_Calfilename();
           break;
           case 2:
             calflag += Set_DA_Parameters();
           break;
           case 3:
             calflag += Set_Calibration_Frequency();
           break;
           case 4:
             calflag += Set_Calibration_Range();
           break;
           case 5:
             calflag += Set_Calibration_Increment();
           break;
           case 6:
             if (calflag >= 5)
               Calibrate_Receiver();
				 calflag = 0;
           break;
         }
         menu_erase(save_drop_cal_menu);     
       break;
		 case 2:
         save_drop_DA_configuration = menu_drop(4, 19, drop_DA_configuration, &keypressed);
         switch (keypressed)
         {
           case 1:
             daflag += DA_Board_Config();
			  break;
			  case 2:
				 daflag += Channel_Config();
           break;
           case 3:
			    daflag += Sampling_Config();
           break;       
           case 4:
			    daflag += Scan_Config();
           break;
         }	/* switch n */
         menu_erase (save_drop_DA_configuration);
       break;
       case 3:
			save_drop_IO_menu = menu_drop(4, 36, drop_IO_configuration, &keypressed);
         switch (keypressed) {
           case 1:
             Get_Header_Path();
           break;
           case 2:
             Get_Tempfile_Path();
           break;
           case 3:
             Get_Datafile_Path();
           break;
           case 4:
             Get_Calfile_Path();
           break;
           case 5:
             Control_Double_Buffering();
           break;
           case 6:
             Get_Buffer_Size();
           break;
 		   }
         menu_erase(save_drop_IO_menu);
			break;
		case 4:
			save_drop_meas_menu = menu_drop(4, 48, drop_measurement, &keypressed);
         switch (keypressed)
         {
           case 1:
             configname = Get_Config_Filename();
             Read_Config_File(configname);
           break;
           case 2:
             GPS_Receiver_Operation();
           break;
           case 3:
             Signal_Generator_Operation();
           break;
           case 4:
             Spectrum_Analyzer_Operation();
           break;
           case 5:
             GPSreadflag = TRUE;
				 menu_erase(save_bar_main);
             Do_Measurement();
           break;
         }
         menu_erase(save_drop_meas_menu);
      break;
      case 5:
			menu_erase(menu_drop(4, 63, drop_quit, &keypressed));
			if(keypressed == 2)
				quit_flag = 1;
			break;
		default:
			/*  ignore the Esc keypress at this level */
			break;
		} /* switch barchoice */
  }	/* while */
  Restore_State();
}



