/* MENUTEST.C */
/* Demonstrates the MENU toolbox functions */

#include <stdio.h>
#include <graph.h>
#include "t_colors.h"
#include "menu.h"
#include "menu.c"
#include	"box.h"
#include "box.c"
#include "getkey.h"
#include "getkey.c"

int far *save_intro_headr;
int far *save_bar_main;
int far *save_drop_DA_configuration;
int far *save_intro_descr;

char *intro_headr[] =
   {
   "",
   "Southwestern Bell Technology Resources, Inc.",
   "       Narrow Band Measurement Software",
   "",
   NULL
   };
char *intro_descr[] =
	{
   "",
	"This software is used to capture narrow band signal strength",
	"data.  The software is totally automated and can be configured",
	"to acquire data (voltage samples) from up to 8 channels at a",
	"sampling rate of up to 1 Msamples/sec.  The samples are recorded",
	"with a multichannel National Instruments Data Acquistion Board.",
	"For moving measurements position fixes are provided by a Global",
   "Positioning System (GPS).  Specific measurement parameters are",
   "defined in a configuration file or can be entered by the operator.",
   "",
	"<Press any key to continue>",
	NULL
	};

char *bar_main = "  Calibration  Data acquistion  Input/output  Measurement  Quit  ";

char *drop_calibration[] =
	{
	" Calibration ",
	"Receiver Calibration",
   "Configuration Filename",
   "Output Filename",
   "Analog Channel",
   "Calibration Frequency",
   "Calibration Range",
   "Calibration Increment",
	" Select ",
	NULL
	};

char *drop_DA_configuration[] =
	{
	" Data Acquisition Board",
	"Specify Slot Number",
   "Specify Number of Channels",
	"Specify Sampling Rate",
	"Specify Sampling Interval",
	"Specify Scanning Rate",
	"Specify Scanning Interval",
	" Up Dn Ltr Enter Esc ",
	NULL
	};

char *drop_IO_configuration[] =
	{
	"  I/O Configuration ",
	"Enable Double Buffering",
	"Specify Buffer Size",
	"",  /* no prompt */
	NULL
	};

char *drop_measurement[] =
	{
	"Open Configuration File",
	"Enable GPS Receiver",
	"Go",
	NULL
	};

char *drop_GPS_receiver[] =
	{
	" GPS Receiver Operation ",
	"GPS Receiver On",
	"GPS Rceiever Off",
	"",
	NULL
	};

char *drop_quit[] =
	{
	" Quit? ",
	"No",
	"Yes",
	"",
	NULL
	};

main()
{
	int n, n1;
	int bar_choice = 1;
	int quit_flag = 0;
	int first_time = 1;

   /* initialize video */
   _setvideomode(_TEXTC80);
	_clearscreen(_GCLEARSCREEN);

   _setbkcolor(T_BLUE);
   box_color(1,1,25,80);

	/* main loop begins here */
	while(!quit_flag)
   {
		/* display the information box */
      if (first_time)
      {
        first_time = 0;
		  save_intro_headr = menu_message(4, 16, intro_headr);
        save_intro_descr = menu_message(10, 6, intro_descr);
        getch();
		  _clearscreen(_GCLEARSCREEN);
      }
		
		/* the main menu bar */
		save_bar_main = menu_bar(2, 2, bar_main, &bar_choice);
		switch(bar_choice)
			{
			case 1:
				menu_erase(menu_drop(4, 6, drop_calibration, &n));
				break;
			case 2:
				save_drop_DA_configuration = menu_drop(4, 19, drop_DA_configuration, &n);
				if(n > 1 && n < 8)
					{
					menu_erase (menu_drop (4, 19, drop_DA_configuration, &n1));
					n1--;
					switch (n)
						{
						case 2:
							menu_line_color(n1);
							break;
						case 3:
							menu_title_color(n1);
							break;
						case 4:
							menu_text_color(n1);
							break;
						case 5:
							menu_prompt_color(n1);
							break;
						case 6:
							menu_hilight_letter(n1);
							break;
						case 7:
							menu_hilight_text(n1);
							break;
						}	/* switch n */
					}	/* if(n > 1 && n < 8) */
			else if(n == 1 || n == 8)
				{
				menu_erase(menu_drop(4, 29, drop_measurement, &n1));
				n1--;
				switch(n)
					{
					case 1:
						menu_back_color((long int)n1);
						break;
					case 8:
						menu_hilight_back((long int)n1);
						break;
					}	/* switch n */
				}	/* else if */
			menu_erase (save_drop_DA_configuration);
			break;
		case 3:
			menu_erase(menu_drop(4, 36, drop_IO_configuration, &n));
			if(n)
				menu_box_shadow(--n);
			break;
		case 4:
			menu_erase(menu_drop(4, 50, drop_measurement, &n));
			break;
      case 5:
			menu_erase(menu_drop(4, 63, drop_quit, &n));
			if(n == 2)
				quit_flag = 1;
			break;
		default:
			/*  ignore the Esc keypress at this level */
			break;
		} /* switch barchoice */
	}	/* while */

	/* clear screen and reset color before quitting */
   _setbkcolor(0);
	_clearscreen(_GCLEARSCREEN);
}
