#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <graph.h>

/* Includes for National Instruments Data Acquisition Board */
#include "c:\lw\include\dataacq.h"
#include "c:\lw\include\formatio.h"
#include "c:\lw\include\lw_const.h"

/* Includes and Defines for National Instruments GPIB Controller Card */
#include "c:\gpib488\gpib_lib.c"
#include "c:\gpib488\fsg_prog.c"
#define  HP_FSG			7

#define	TRUE				1
#define	CAL_PATH			"c:\\krs\\adprogs\\calfiles\\"
#define  MAXCHANS			5
#define	TRUE				1

struct calibration_data
{
  int			channel;
  float		frequency,
  				mindBmlvl,
         	maxdBmlvl,
         	dBmstep;
  char      calfilename[96];
};

struct DABoardParams
{
 int	board,
		boardCode,
		baseAddr,
		irq1Lvl,
		irq2Lvl,
		irqTrigMode,
		dma1Lvl,
      dma2Lvl,
		daqMode,
      daqBufMode,
		inputMode,
		inputRange,
		polarity;
};
 
struct MeasParams
{
  int					sampTimebase,
      				scanTimebase,
						scanchannel[MAXCHANS],
						gain[MAXCHANS];
  unsigned int		samples,
                  sampInterval,
						scanInterval;
  float				sampleRate;
};

struct	calibration_data caldata;
struct 	DABoardParams daqbrd;
struct 	MeasParams params;

/*****************************************************************************
*	Function:		int Process_Error_Code(int errNum)
*	Description:	Function process the error codes returned by the LabWindows
*	Data Acquisition C Libraries.  The warning and error codes are described in
*	the LabWindows documentation.
*****************************************************************************/
int Process_Error_Code(int errNum)
{
  switch (errNum)
  {
    case 0:
      //  Operation completed.  No error(s) detected.
      return(TRUE);
    break;
    case 5:
      // Warning message - calibrationFailed.
      printf("Warning - Analog input channel calibration failed.\n");
      return(TRUE);
    break;
    case 12:
      // Warning - overWriteBeforeCopy.
      printf("Warning - Buffer overwritten before copied.\n");
      return(!TRUE);
    break;
    case -60:
      //  Operation incomplete - NotOurBrdErr.
      printf("Error - Data Acquisition board not recognized.\n");
      return(!TRUE);
    break;
    case -61:
      //  Operation incomplete - badBrdNumErr.
      printf("Error - Incorrect data acquisition board number.\n");
      return(!TRUE);
    break;
    case -62:
      //  Operation incomplete - badGainErr.
      printf("Error - Incorrect A/D gain value specified.\n");
      return(!TRUE);
    break;
    case -63:
      // Operation incomplete - badChanErr.
      printf("Error - Invalid analog input channel specified.\n");
      return(!TRUE);
    break;
    case -64:
      // Operation incomplete - noSupportErr.
      printf("Error - No support available.\n");
      return(!TRUE);
    break;
    case -69:
      // Operation incomplete - badInputValError
		printf("Error - Bad input value\n");
      return(!TRUE);
    break;
    case -70:
      // Operation incomplete - timeOutErr.
      printf("Error - Time out error.\n");
      return(!TRUE);
    break;
    case -71:
      // Operation incomplete - outOfRangeErr.
      printf("Error - Data out of range.\n");
      return(!TRUE);
    break;
    case -72:
      // Operation incomplete - daqInProgErr.
      printf("Error - Data acquisition in progress.\n");
      return(!TRUE);
    break;
    case -73:
      // Operation incomplete - counterInUseErr.
      printf("Error - Counter in use.\n");
      return(!TRUE);
    break;
    case -75:
      // Operation incomplete - overFlowErr.
      printf("Error - Buffer overflow error.\n");
      return(!TRUE);
    break;
    case -76:
      // Operation incomplete - overRunErr.
      printf("Error - Buffer overrun error.\n");
      return(!TRUE);
    break;
    case -77:
      // Operation incomplete - badCntErr.
      printf("Error - Bad counter error\n");
      return(!TRUE);
    break;
    case -91:
      // Operation incomplete - badPreTrigCntError.
      printf("Error - Bad pretrigger counter error\n");
      return(!TRUE);
    break;
    case -93:
      // Operation incomplete - intLevelNoSupportErr.
      printf("Error - No internal level support\n");
      return(!TRUE);
    break;
    case -94:
      // Operation incomplete - extConvErr.
      printf("Error - External conversion error\n");
      return(!TRUE);
    break;
    case -96:
      // Operation incomplete - noDbDaqErr.
      printf("Error - Double buffered data acquisition not initialized.\n");
      return(!TRUE);
    break;
    case -97:
      // Operation incomplete - overWriteErr.
      printf("Error - Buffer overwrite error.\n");
      return(!TRUE);
	 break;
    case -98:
      //  Operation incomplete - memErr.
      printf("Error - Memory error.\n");
      return(!TRUE);
    break;
    case -99:
      //  Operation incomplete - noConfigFile
      printf("Error - Cannot find configuration file.\n");
      return(!TRUE);
    break;
 	 case -101:
      //  Operation incomplete - intLevelInUse
    	printf("Error - Level in use.\n");
      return(!TRUE);
    break;
    case -102:
      // Operation incomplete - DMAChanInUse
      printf("Error - DMA channel in use.\n");
      return(!TRUE);
    break;
    case -104:
      // Operation incomplete - lowScanIntervalErr
      printf("Error - Low scan interval error.\n");
      return(!TRUE);
    break;
    case -118:
      // Operation incomplete - DMADisabledErr
      printf("Error - DMA channel disabled.\n");
      return(!TRUE);
    break;
    case -119:
      //  Operation incomplete - invalidConfigErr.
      printf("Error - Invalid configuration data.\n");
      return(!TRUE); 
    break;
    case -127:
      // Operation incomplete - keyNotFoundErr.
      printf("Error - Key code not found.\n");
      return(!TRUE);
    break;
    default:
      //  Operation incomplete - default error code
      printf("Error - Error unknown.\n");
      exit(0);
    break;
  }
}

/*****************************************************************************
*	Function:		int Default_Parameters()
*	Description:	Set up default DA board parameters and data acquisition
*	parameters.  This is hard coded so that parameters not specified in the
*	configuration file will have a "workable" value. 
*****************************************************************************/
int Default_Parameters()
{
  daqbrd.board = 2;				// Board installed on slot 2 of EISA Bus
  daqbrd.daqBufMode = 1; 		// Enable double buffering
  daqbrd.inputRange = 10;
  daqbrd.polarity = 1;
  daqbrd.inputMode = 0;

  params.samples = 15;

  params.sampleRate = 0.25;   // Smapling rate for single channel acquistions
  params.sampTimebase = 3;		// Timebase (resolution) for sample interval counter
  params.sampInterval = 2;		// Length of sample interval (elapsed time between A/D conversions)
  params.scanTimebase = 4;    // Timebase for scan interval counter
  params.scanInterval = 0;    // Length of scan interval (elasped time between scan sequences)
  params.scanchannel[0] = 0;	// Analog channels to scan
  params.scanchannel[1] = 1;
  params.gain[0] = 1;		   // Default analog channel gain factors
  params.gain[1] = 1;
  return(TRUE);
} 

/****************************************************************************
*	Function:		Calibrate_Receiver()
*	Description:	Perform a receiver calibration 
****************************************************************************/
Calibrate_Receiver()
{
  int index,errNum;
  int fsg_ud;
  char calfilename[96];
  FILE *calfileptr;
  long numTimeOutTicks;
  int *dataBuffer;
  double *voltageArray;
  double avgval;
  float numSteps;
  float currdBmlvl;
  int count;
  char message[40];

  fsg_ud = gpib_open(HP_FSG);
  if (fsg_ud < 0) {
    printf("Unable to open connection to the signal generator - program terminated\n");
	 return(!TRUE);
  }
  else if (fsg_ud >= 0)
    printf("Connection to signal generator established.\n");

  fsg_rf_hpsl(fsg_ud,RFOFF);
 
  if ( ( calfileptr = fopen(caldata.calfilename,"w+") ) == NULL) {
    printf("Unable to open output data file - program terminated\n");
    return(!TRUE);
  }

  if (!Default_Parameters()) {
    printf("Problem setting default parameters - program terminated\n");
    exit(0);
  }
  errNum = Get_DA_Brds_Info(daqbrd.board,&daqbrd.boardCode,&daqbrd.baseAddr,
                            &daqbrd.irq1Lvl,&daqbrd.irq2Lvl,&daqbrd.irqTrigMode,
                            &daqbrd.dma1Lvl,&daqbrd.dma2Lvl,&daqbrd.daqMode);
  Process_Error_Code(errNum);
  printf("Data acquisition board parameters retrieved\n");
  errNum = Init_DA_Brds(daqbrd.board,&daqbrd.boardCode);
  Process_Error_Code(errNum);
  printf("Data acquistion board initialized\n");
  errNum = AI_Config(daqbrd.board,daqbrd.inputMode,daqbrd.inputRange,daqbrd.polarity);
  Process_Error_Code(errNum);
  printf("Analog channel input initialized\n");

  numSteps = (caldata.maxdBmlvl - caldata.mindBmlvl)/caldata.dBmstep;

  for (count = 0; count <= (int)numSteps; count++) {
    avgval = 0;
    dataBuffer = (int *)calloc(params.samples,sizeof(int));
    voltageArray = (double *)calloc(params.samples,sizeof(int));
    currdBmlvl = caldata.mindBmlvl + count*caldata.dBmstep;
    printf("Calibrating at %.2f for %.2f dBm input signal level\n",caldata.frequency,currdBmlvl);
    fsg_freqMHz_hpsl(fsg_ud,caldata.frequency);
    fsg_ampdBm_hpsl(fsg_ud,currdBmlvl);
    errNum = DAQ_Op(daqbrd.board,params.scanchannel[caldata.channel],params.gain[caldata.channel],dataBuffer,params.samples,params.sampleRate);
    Process_Error_Code(errNum);
    errNum = DAQ_Scale(daqbrd.board,params.gain[caldata.channel],params.samples,dataBuffer,voltageArray);
    Process_Error_Code(errNum);
    for (index = 0; index < params.samples; index++)
      avgval += voltageArray[index];
    avgval = avgval/(float)params.samples;  
    fprintf(calfileptr,"%f\t%lf\n",currdBmlvl,avgval); 
    free(voltageArray);
    free(dataBuffer);
  }
  printf("Receiver calibration complete.  Press any key to continue.");
  errNum = DAQ_Clear(daqbrd.board);
  fsg_rf_hpsl(fsg_ud,RFOFF);
  gpib_local(fsg_ud);
  fclose(calfileptr);
}  
 
main()
{
  char readstr[80];

  printf("Enter output filename: ");
  scanf("%s",&readstr);
  strcpy(caldata.calfilename,readstr);
  printf("Enter the analog channel to calibrate: ");
  scanf("%s",&readstr);
  caldata.channel = atoi(readstr);
  printf("Enter the calibration frequency: ");
  scanf("%s",&readstr);
  caldata.frequency = atof(readstr);
  printf("Enter the minimum input signal level: ");
  scanf("%s",&readstr);
  caldata.mindBmlvl = atof(readstr);
  printf("Enter the maximum input signal level: ");
  scanf("%s",&readstr);
  caldata.maxdBmlvl = atof(readstr);
  printf("Enter the calibration increment: ");
  scanf("%s",&readstr);
  caldata.dBmstep = atof(readstr);
  Calibrate_Receiver();
}



