/* Box.c */
#include "box.h"

static void determine_video(void);
static unsigned int video_seg = 0;
static char far *videoptr;
static int columns;

/* box_get - saves contents of a rectangular area of screen in dynamically allocated buffer */

unsigned far *box_get(unsigned row1, unsigned col1, unsigned row2, unsigned col2)
{
	unsigned i, width, height, bytes;
	unsigned far *buf, far *bufptr;
	unsigned video_off;

	/* calculate the dimensions (in bytes) */
	width = (col2 - col1 + 1) * 2;
	height = row2 - row1 + 1;
	bytes = height * width + 8;

	/* allocate storage space */
	if ((buf = (int far *) malloc ( (size_t) bytes)) == NULL)
		{
		printf ("box_get(): malloc() failed\n");
		exit (0);
		}

	/* save the box coordinates i the buffer */
	bufptr = buf;
	*bufptr++ = row1;
	*bufptr++ = col1;
	*bufptr++ = row2;
	*bufptr++ = col2;

	/* determine the text mode video segment and number of columns */
	determine_video();

	/* calcuate starting location in video memory */
	video_off = (unsigned) (( columns * (row1 -1) + (col1 - 1)) * 2);

	/* grab each line of the video */
	for (i = 0; i < height; i++)
		{
		movedata (video_seg, video_off,
			FP_SEG( bufptr ), FP_OFF (bufptr ), width);
		bufptr += width / 2;
		video_off += columns * 2;
		}

	/* return the buffer */
	return (buf);
}

void box_put (unsigned far *buf)
{
	unsigned row1, col1, row2, col2;
	unsigned i, width, height, bytes;
	unsigned video_off;
	unsigned far *workbuf;

	/* get the box coordinates */
	workbuf = buf;
	row1 = *workbuf++;
	col1 = *workbuf++;
	row2 = *workbuf++;
	col2 = *workbuf++;

	/* calculate the dimensions in bytes */
	width = ( col2 - col1 + 1) * 2;
	height = row2 - row1 + 1;
	bytes = height * width;

	/* determine the text mode video segment and number of columns */
	determine_video();

	/* calcuate starting location in video memory */
	video_off = ( columns * (row1 - 1) + (col1 - 1)) * 2;

	/* put each line out to video */
	for (i = 0; i < height; i++)
		{
		movedata (FP_SEG( workbuf), FP_OFF(workbuf),
			video_seg, video_off, width);
		workbuf += width / 2;
		video_off += columns * 2;
		}
}

void box_color ( unsigned row1, unsigned col1, unsigned row2, unsigned col2)
{
	unsigned x, y, fore;
	unsigned long back;
	unsigned char attr;

	/* determine the text mode video segment and number of columns */
	determine_video();

	/* build the attribute byte */
	fore = _gettextcolor();
	back = _getbkcolor();
	attr = (unsigned char)(( fore & 0xf) |
	(((( fore & 0x10) >> 1) | back ) << 4));

	/* work through the box */
	for (x = row1 - 1; x < row2; x++)
		for (y = col1 - 1; y < col2; y++)
			*( videoptr + (columns * x + y ) * 2 + 1) = attr;
}

void box_charfill ( unsigned row1, unsigned col1, unsigned row2, unsigned col2, char c)
{
	unsigned x,y;

	/* determine the text mode video segment and number of columns */
	determine_video();

	/* work through the box */
	for (x = row1 - 1; x < row2; x++)
		for (y = col1 - 1; y < col2; y++)
			*( videoptr + (columns * x + y ) * 2 ) = c;
}


void box_draw ( unsigned row1, unsigned col1, unsigned row2, unsigned col2, unsigned line_type)
{
	unsigned x,y,dx,dy,c;

	/* determine the text mode video segment and number of columns */
	determine_video();

	/* work around the box */
	x = col1;
	y = row1;
	dx = 1;
	dy = 0;
	do
		{

		/* set the devault character for unbordered areas */
		c = ' ';

		/* set the single-line drawing character */
		if (line_type == 1)
			if (dx )
				c = 196;
			else
				c = 179;

		/* set the double-line drawing character */
		if (line_type == 2)
			if (dx )
				c = 205;
			else
				c = 186;

		/* change direction at top right corner */
		if (dx == 1 && x == col2)
			{
			dx = 0;
			dy = 1;
			if (line_type == 1)
				c = 191;
			else if (line_type == 2)
				c = 187;
			}

		/* change direction at bottom right corner */
		if (dy == 1 && y == row2)
			{
			dx = -1;
			dy = 0;
			if (line_type == 1)
				c = 217;
			else if (line_type == 2)
				c = 188;
			}

		/* change direction at bottom left corner */
		if (dx == -1 && x == col1)
			{
			dx = 0;
			dy = -1;
			if (line_type == 1)
				c = 192;
			else if (line_type == 2)
				c = 200;
			}

		/* check for top left corner */
		if (dy == -1 && y == row1)
			{
			if (line_type == 1)
				c = 218;
			else if (line_type == 2)
				c = 201;
			}

		/* put new charcter to video */
		*(videoptr + (columns * (y-1) + (x-1)) * 2 ) = (char) c;

		/* move to next position */
		x += dx;
		y += dy;

		}
	while (dy != -1 || y >= row1) ;
}

void box_erase(unsigned row1, unsigned col1, unsigned row2, unsigned col2)
{
	unsigned i;
	char buf[81];

	/* fill the buffer with spaces */
	sprintf(buf, "%*s", col2 - col1 +1, "");

	/* put each line out to video */
	for(i=row1; i<=row2; i++)
		{
		_settextposition(i, col1);
		_outtext(buf);
		}
}

static void determine_video(void)
{
	if(!video_seg)
		{
		/* determine the text mode video segment */
		switch( *((char far *)0x449))
			{
			case 0:
			case 1:
			case 2:
			case 3:
				video_seg = 0xB800;
				videoptr = (char far *)0xB8000000;
				break;
			case 7:
				video_seg = 0xB000;
				videoptr = (char far *)0xB0000000;
				break;
			default:
				printf("BOX.C:  not in text mode\n");
				exit(0);
			}

			/* determine number of columns for current text mode */
			columns = *((int far *)0x44A);
	}
}












		
	
