#define PROGRAM_NAME				"NBMEAS.EXE - Version 1.0"
#define TRUE						1
#define DEBUG						!TRUE

#define TMPEXT						".raw"
#define DATAEXT					".acq"
#define HDREXT						".hdr"
#define GPSEXT						".gps"
#define TMPROOT					"temp"
#define TMPPATH					"c:\\tmp\\"
#define DATAPATH					"c:\\krs\\adprogs\\data\\"
#define HDRPATH					"c:\\krs\\adprogs\\headers\\"
#define CONFIGPATH				"c:\\krs\\adprogs\\config\\"

#define MIN_FREE_DISK_SIZE		10				// req'd free disk space in kbytes
#define MAX_SAMPLES				3000U			// max # of samples for D/A operations
#define MAX_TRANSFER_PTS      500			// max # of points to read and scale
#define MAXCHANS					3				// max # of channels to scan	

// GPS variable definitions, functions, and global variables
#define		GPS_WARNING_TIME	120		/* warning bell every 10 (or setting) seconds */
#include		"tans_def.h"					/* declare variables for tans gps routines */
#include		"tans_pro.c"					/* tans procedures */
int			gps_state;						/* GPS state marker */
time_t		gps_last_warning_time;		/* holds time of last gps warning */
struct		TANS_BUFFER	gps_info;		/* store the results here */
long int		gps_rec_count = 0;			/* keep track of GPS record count */

// Graphics information
int 			display_mode;
int			graphics_mode = !TRUE;
struct		videoconfig  videoInfo;

// Function prototypes
int check_free_disk_space (void);
unsigned long Disk_Free_kb(void);
int Initialize_GPS_Receiver(void);
int Display_GPS_Status(void);
int Check_Free_Disk_Space (void);
int Display_GPS_Status(void);
unsigned long Disk_Free_kb(void);
int Open_Data_File();
int Open_Temporary_File();
double Scale_Data(int readval,int gain);

struct DABoardParams
{
 int	board,
		boardCode,
		baseAddr,
		irq1Lvl,
		irq2Lvl,
		irqTrigMode,
		dma1Lvl,
      dma2Lvl,
		daqMode,
      daqBufMode,
		inputMode,
		inputRange,
		polarity;
};
 
struct MeasParams
{
  int					buffer,
                  channels,
      				sampTimebase,
      				scanTimebase,
						scanchannel[MAXCHANS],
						gain[MAXCHANS];
  unsigned int		points,
						samples,
                  sampInterval,
						scanInterval,
						ptsTfr;
  float				sampleRate;
};
     
struct IOParams
{
  char				tmpfilepath[64],
						datafilepath[64],
						tmpfilename[MAXCHANS][96],
						datafilename[MAXCHANS][96],
						gpsfilename[96],
						calfilepath[64],
						headerfilepath[64],
						configfilename[96];
};

struct calibration_data
{
  int				channel,
					dev_id;
  unsigned int	samples;
  float			frequency,
  					mindBmlvl,
         		maxdBmlvl,
					sampleRate,
         		dBmstep;
  char      	calfilename[96];
};

struct signal_generator
{
  int				dev_id;
  float			cfreq,
					rfampl;
};

struct spectrum_analyzer
{
	int			dev_id;
	float			cfreq,
					span,
					sweep,
               resbw,
               vidbw,
               reflvl;
	int         atten;
};

FILE		*hdrfileptr,*tmpfileptr[MAXCHANS],*datafileptr[MAXCHANS],*gpsfileptr;
char 		hdrfilename[64];
struct 	DABoardParams daqbrd;
struct 	MeasParams params;
struct   calibration_data caldata; 
struct	signal_generator siggen;
struct	spectrum_analyzer specan;
struct	IOParams iodata;

int far *save_gps_status;
int far *save_gps_error;
int far *save_DA_message;

char *status_message[] = {
  "GPS Status",
  "  GPS        Sats    PDOP    Lat      Lon  ",
  "                                           ",
  "",
  NULL
};

char *status_message2[] = {
  "GPS Status",
  " Key     GPS        Sats    PDOP    Lat      Lon  ",
  "                                                  ",
  "",
  NULL
};

char *error_message[] = {
  "GPS Error",
  "                                             ",
  " Press 'Esc' to Exit or 'Enter' to Continue ",
  NULL
};

char *error_message2[] = {
  "GPS Error",
  "                                             ",
  "",
  NULL
};

char *DA_error_message[] = {
    " National Instruments Data Acqusition Error ",
    "                                              ",
	 "",
    NULL
  };

int GPSinitflag = !TRUE;
int GPSreadflag = !TRUE;
