/*   MS_FILE.C                                                          */
/*                                                                      */
/*   Measurement System File Definitions for output file                */
/*                                                                      */
/*   This file contains the definitions for the output file:            */
/*       record type numbers                                            */
/*       file formats                                                   */
/*                                                                      */
/*   See doc.doc for fuller explanations of fields                      */
/*		Version 0.081 6/16/92                                             */
/*			08.02 Added indoor record type (#72)                        	*/
/*		Version 0.08  4/12/92                                             */
/* 		08.01	made the arguments of ms_type_argn as longs	            */
/*		Version 0.07  4/11/92													      */
/*			0.07.01  Added peak hold flag to MS_BAND_RECORD as 2nd entry,	*/
/*			0.07.02	added five system arguments to MS_PARAMETER_TYPE		*/
/*			0.07.03  added van1 type (diversity) format string             */
/*		Version 0.05  4/04/92  GPS functions                              */
/*		Version 0.04  3/30/92  Autoattenuate functions                    */
/*    Started  3/20/92  csp                                             */
/*    Modified for TelMex application 2/2/93 krs                        */
/*                                                                      */
/*                                                                      */
/* ==================================================================== */
/*   Define Record types here                                           */
/* ==================================================================== */

#define	MS_COMMENT_PROGRAM_ID	   0  /* Measurement System General Information */
#define	MS_COMMENT_ECHO_HEADER_ID	1  /* Echo of input file */
#define	MS_COMMENT_ECHO_ID	      2  /* Echo of input file */
#define	MS_COMMENT_END_HEADER_ID	8  /* End of data file record */
#define	MS_COMMENT_END_RECORD_ID	9  /* End of data file record */

#define	MS_SYSTEM_PARAM_HEADER_ID	   10  /* System Parameter header */
#define	MS_SYSTEM_PARAM_TYPE_ID	      11  /* System Parameter type */
#define	MS_SYSTEM_PARAM_OPERATOR_ID	12  /* System Parameter Operator Name */
#define	MS_SYSTEM_PARAM_NUM_PASSES_ID	13  /* System Parameter Number passes/location */
#define	MS_SYSTEM_PARAM_SAT_ATTEN_ID	14  /* Auto attenuate spec. analyzer level */

#define	MS_BAND_PARAM_HEADER_ID	      30  /* Parameter header */
#define	MS_BAND_PARAM_NUMBER_ID	      31  /* Number of bands id */
#define	MS_BAND_PARAM_DEFINITION_ID	32  /* Band definition record */

#define	MS_PATH_PARAM_HEADER_ID	      40  /* Parameter header */
#define	MS_PATH_PARAM_NUMBER_ID	      41  /* Number of bands id */
#define	MS_PATH_PARAM_DEFINITION_ID	42  /* Signal band definition record */
#define	MS_PATH_PASSBAND_DEF_ID	      43  /* Signal path definition record */

#define	MS_SCAN_PARAM_HEADER_ID	         50  /* Parameter header */
#define	MS_SCAN_PARAM_NUMBER_ID	         51  /* Number of bands id */
#define	MS_SCAN_PARAM_DEFINITION_ID	   52  /* System Parameter Operator Name */

#define	MS_POSITION_INDEX_ID	            70  /* Position--Index number*/
#define	MS_POSITION_VAN1_ID	            71  /* Position Van (type 1)*/
#define	MS_POSITION_CART_ID	            72  /* Position Cart (type 2)*/
#define	MS_POSITION_FIXED_ID	            73  /* Position fixed (type 3)*/
#define	MS_POSITION_OPERATOR_KEY_ID	   81  /* Position--Operator key */
#define	MS_POSITION_OPERATOR_TEXT_ID	   82  /* Position--Operator text comments */

#define	MS_AUTOATTEN_ID	               90	 /* auto attenuator sweep values */

#define	MS_FREQUENCY_RECORD_ID_BASE	  200  /* frequency record (base) */

#define	MS_BAND_RECORD_ID_BASE	        300  /* Band record (when, number, etc) */

#define	MS_DATA_RECORD_ID_BASE	        400  /* data record (base) */


/* ====================================================================*/
/* Each line starts with an integer line type                          */
/* ====================================================================*/
#define	MS_REC_TYPE	"%d\t"

/* =================================================================== */
/*  0-9    Comment and End of data file                                */
/* ====================================================================*/
#define	MS_COMMENT_HEADER1	"            SOUTHWESTERN BELL TECHNOLOGY RESOURCES\n"
#define	MS_COMMENT_HEADER2	"                    -- PROPRIETARY -- \n"
#define	MS_COMMENT_HEADER3	"WARNING:  This data is considered PROPRIETARY and is property of\n"
#define	MS_COMMENT_HEADER4	"Southwestern Bell Technology Resources(SBTR) and Southwestern Bell\n"
#define  MS_COMMENT_HEADER5   "International Holdings (SBIH) and shall not be distributed\n"
#define	MS_COMMENT_HEADER6	"or used without the written permission of SBTR or SBIH.\n"
#define	MS_COMMENT_HEADER7	"Data Generated by: %s  Version %.2f\n"
#define	MS_COMMENT_HEADER8	"Starting Date/Time %s  %s\n"
#define	MS_COMMENT_HEADER9	"Source Configuration file: %s\n"
#define	MS_COMMENT_HEADER10	"Output file name: %s\n"
#define	MS_COMMENT_HEADER11	"\n"

#define	MS_COMMENT_ECHO_HEADER1	"=====  Contents of config file <%s> ==========\n"  
#define	MS_COMMENT_ECHO_HEADER2	" === END FILE   <%s> === END === \n"
#define	MS_COMMENT_ECHO	"config > %s"  /* for echo of configurationf file */

#define	MS_COMMENT_END_HEADER	"END OF FILE RECORD FOLLOWS: Ended at %s %s\n"
#define	MS_COMMENT_END_RECORD	"%ld\t%ld\t%ld\t%d\n"	/* End of data file record */

/* =================================================================== */
/*  10-29    System Parameters                                         */
/* ====================================================================*/
#define	MS_SYSTEM_PARAM_HEADER	"====== System Information ===========================\n" /* System Parameter header */
#define	MS_SYSTEM_PARAM_TYPE	"%d\t%ld\t%ld\t%ld\t%ld\t%ld\t<%s>\n"  /* System Parameter type */
#define	MS_SYSTEM_PARAM_OPERATOR	"Operator: %s\n"	               /* System Parameter Operator Name */
#define	MS_SYSTEM_PARAM_NUM_PASSES	"%d\n"                           /* System Parameter Number passes/location */
#define	MS_SYSTEM_PARAM_SAT_ATTEN	"%d\n"                           /* Auto attenuate spec. analyzer level */

/* =================================================================== */
/*  30-39    Band (frequency) Parameters                               */
/* ====================================================================*/
#define	MS_BAND_PARAM_HEADER1	"====== Frequency Band Information ===========================\n" /* System Parameter header */
#define	MS_BAND_PARAM_HEADER2	"start_f(MHz) width_f(MHz) rbw(kHz) vbw(kHz) atten segments span/segment\n" /* System Parameter header */
#define	MS_BAND_PARAM_NUMBER	"%d\n"  /* number band Parameter type */
#define	MS_BAND_PARAM_DEFINITION	"%d\t%lf\t%lf\t%lf\t%lf\t%d\t%d\t%lf\n"  /* definition */

/* =================================================================== */
/*  40-49    Path pameters                                             */
/* ====================================================================*/
#define	MS_PATH_PARAM_HEADER	"====== Signal Path Information ===========================\n" /* System Parameter header */
#define	MS_PATH_PARAM_NUMBER	"%d\n"                               /* Number band Parameter type */
#define	MS_PATH_PARAM_DEFINITION	"%d\t%lf\t%d\t[%s]\n"          /* Signal path definition */
#define	MS_PATH_PASSBAND_DEFINITION	"%d\t%lf\t%lf\t%lf\t%lf\n"  /* Signal path definition record */

/* =================================================================== */
/*  50-69    Scan Table pameters                                       */
/* ====================================================================*/
#define	MS_SCAN_PARAM_HEADER1	"====== Scan Table Band Information ===========================\n" /* System Parameter header */
#define	MS_SCAN_PARAM_HEADER2	"Number Band Path Index Data_Record\n" /* System Parameter header */
#define	MS_SCAN_PARAM_NUMBER	"%d\n"                                    /* number scans */
#define	MS_SCAN_PARAM_DEFINITION	"%d\t%d\t%d\t%d\t%d\n"              /* definition */

/* =================================================================== */
/*  70-89    Position Parameters                                       */
/* ====================================================================*/
#define	MS_POSITION_INDEX 	"%d\n"       /* Position Index number */
#define	MS_POSITION_VAN1 	"%d\t%d\t%d\n"  /* Position Van (type 1) */
#define	MS_POSITION_CART "%d\t%d\t%d\t%d\t%d\t%d\t%lf\t%lf\t%d\t%d\n"	  /* Position Cart (type 2)*/
#define	MS_POSITION_GPS	"%d\t%d\t%d\t%f\t%lf\t%lf\t%lf\t%f\t%d\t%d\t%d\t%d\n"	/* GPS position record */
#define	MS_POSITION_OPERATOR_KEY 	"%d\n"  /* Position--Operator key */
#define	MS_POSITION_OPERATOR_TEXT 	"%s\n"  /* Position--Operator text comments */

/* =================================================================== */
/*  90-99    AutoAttenuator Parameters                                 */
/* ====================================================================*/
#define	MS_AUTOATTEN	"%d\t%d\t%d\t%d\n"	/* auto attenuator sweep values */

/* =================================================================== */
/*  200-299    Frequency RECORD                                        */
/*   Composed of:                                                      */
/*   		(int) number of frequency points in record                    */
/*   		(long) measurement index (ignored, to be consistent with 300  */
/*			(double) array of frequencies                                 */
/* ====================================================================*/
#define	MS_DATA_FREQUENCY_1	"%d\t%ld\t"         /* number of pts, index */
#define	MS_DATA_FREQUENCY_POINT	"%g\t"           /* regular frequency point */
#define	MS_DATA_RECORD_FREQUENCY_POINT	"%g\n"  /* last frequency point */

/* =================================================================== */
/*  300-399    Band Information Record                                 */
/* ====================================================================*/
#define	MS_BAND_RECORD	"%d\t%d\t%ld\t%d\t%d\t%ld\t%d\t%d\n"  /* record */

/* ====================================================================*/
/*  400-499    DATA RECORD                                             */
/*   Composed of:                                                      */
/*   		(int) number of measurement points in record(not incl index)  */
/*   		(long) measurement index                                      */
/*			(int) array of measured points                                */
/* ====================================================================*/
#define	MS_DATA_RECORD_1	"%d\t%ld\t"      /* number of pts, index */
#define	MS_DATA_RECORD_POINT	"%d\t"        /* regular measurement point */
#define	MS_DATA_RECORD_END_POINT	"%d\n"  /* last measurement point */

