/*  These routines came out of Microsoft C Programmers Toolkit  */
/*    Typed in 4/21/92 csp */

/* Revision #1 -- moved the variable declaration from menu.c to
	menu.h.  This way, the variables are accessible from application
	progams that link to menu.obj (an declare menu.h). 4/28/92 csp

	NOTE:
	You must include t_colors.h before declaring menu.h */
/* ---------------------------------------------------------------
	ROUTINES:
	menu_box_lines ()


   --------------------------------------------------------------- 
*/

/* Necessary includes (pg 248) */
#include "box.h"
#include "getkey.h"
#include "t_colors.h"
#include "menu.h"

// the following removed with revision #1 4/28/92 csp
/* default menu color */
//	static	int	c_lines = T_BLACK;
//	static	int	c_title = T_BLACK;
//	static	int	c_text = T_BLACK;
//	static	int	c_prompt = T_BLACK;
//	static	int	c_hitext = T_WHITE;
//	static	int	c_hiletter = T_WHITE | T_BRIGHT;
//	static	long	int	c_back = BK_WHITE;
//	static	long	int	c_hiback = BK_BLACK;
//	
//	/* Default border lines and shadow control */
//	static	int	mb_lines = 1;
//	static int mb_shadow = 1;


/* =============================== */
void menu_box_lines(int line_type)
/*  line_type = 0,1,2 (outline) */
{
	mb_lines = line_type;
}

/* =============================== */
void menu_box_shadow (int on_off)
/*  on_off = 0 for off */
{
	mb_shadow = on_off;
}

/* =============================== */
void menu_back_color (long back)
/* set background color for boxes */
{
	c_back = back;
}

/* =============================== */
void menu_line_color (int lines)
{
	c_lines = lines;
}

/* =============================== */
void menu_title_color (int title)
{
	c_title = title;
}

/* =============================== */
void menu_text_color (int text)
{
	c_text = text;
}

/* =============================== */
void menu_prompt_color(int prompt)
{
	c_prompt = prompt;
}

/* =============================== */
void menu_hilight_letter (int hiletter)
{
	c_hiletter = hiletter;
}

/* =============================== */
void menu_hilight_text (int hitext)
{
	c_hitext = hitext;
}

/* =============================== */
void menu_hilight_back (long hiback)
{
	c_hiback = hiback;
}

/* =============================== */
int far *menu_bar (int row, int col, char *string, int *choice)
/*  Create a pop-up menu
Parameters
	INPUT	row, col	row and columnt to locate menu
	INPUT string (string of menu selections, separated by spaces)
	OUTPUT choice (number of item slected by user)
*/
{
	int	len;
	int	fore;
	int	maxchoice;
	int	i,j;
	int	cpos;
	int	quit_flag = 0;
	int far	*savebuf;
	int	fstr[81];
	char	lastc, thisc;
	long int bstr[81];
	unsigned key;
	long int	back;
	struct rccoord oldpos;

	/* save the current settings */
	fore = _gettextcolor();
	back = _getbkcolor();
	oldpos = _gettextposition();

	len = strlen (string );
	if (mb_shadow)
		savebuf = box_get (row, col, row+1, col + len+1);
	else
		savebuf = box_get (row, col, row, col + len - 1);

	/* put the menu bar on the screen */
	_settextposition (row, col);
	_outtext (string);

	/* cast a shadow */
	if (mb_shadow)
		{
		_settextcolor ( T_GRAY);
		_setbkcolor (BK_BLACK);
		box_color (row+1, col+2, row+1, col + len + 1);
		}

	/* initialize choice if necessary */
	if (*choice < 1)
		*choice = 1;

	/* process each keypress */
	while (!quit_flag)
		{
		/* determine the color attributes */
		j = 0;
		maxchoice = 0;
		lastc = 0;
		for (i=0; i<len; i++)
			{
			thisc = string[i];
			if (lastc == ' ' && thisc == ' ' && i < len - 1)
				{
				j++;
				maxchoice++;
				}
			if (j == *choice  && i < len - 1)
				{
				fstr[i] = c_hitext;
				bstr[i] = c_hiback;
				}
			else
				{
				fstr[i] = c_text;
				bstr[i] = c_back;
				}
			if (isupper(thisc))
				{
				fstr[i] = c_hiletter;
				if (j == *choice )
					cpos = i;
				}
			lastc = thisc;
			}

		/* put attributes to video */
		for (i = 0; i < len; i++)
			{
			_settextcolor (fstr[i]);
			_setbkcolor (bstr[i]);
			box_color (row, col + i, row, col + i);
			}

		/* put cursor at appropriate position */
		_settextposition (row, col + cpos);

//		key = getkey_or_mouse();
		key = getkey();

		/* convert to uppercase */
		if (key >= 'a' && key <= 'z')
			key -= 32;

		/* check for alpha key */
		if (key >= 'A' && key <= 'Z')
			{
			for (i = 0; i < len; i++)
				{
				if ( ++cpos >= len)
					{
					cpos = 0;
					*choice = 0;
					}
				if (isupper (string[cpos] ))
					*choice += 1;
				if (string[cpos] == (char) key)
					break;
				}
			}

		/* check for control keys */
		switch (key)
			{
			case KEY_LEFT:
				if (*choice > 1)
					*choice -= 1;
				break;
			case KEY_RIGHT:
			case KEY_TAB:
					if (*choice < maxchoice)
					*choice += 1;
				break;
			case KEY_HOME:
					*choice = 1;
				break;
			case KEY_END:
					*choice = maxchoice;
				break;
			case KEY_ESCAPE:
			case KEY_UP:
				*choice = 0;
				quit_flag = 1;
				break;
			case KEY_ENTER:
			case KEY_DOWN:
				quit_flag = 1;
				break;
			}
		}

	/* restore original settings */
	_settextposition (oldpos.row, oldpos.col);
	_settextcolor (fore);
	_setbkcolor (back);
	return (savebuf);
}

/* =============================== */
int far *menu_drop (int row, int col, char **strary, int *choice)
/*  Create a pop-up pull-down menu
Parameters
	INPUT	row, col	row and columnt to locate menu
	INPUT strary (string array of menu selections)
	OUTPUT choice (number of item slected by user)
*/
{
	int	n=0;
	int	len = 0;
	int	fore;
	int	tmpcol;
	int	maxchoice;
	int	i;
	int	quit_flag = 0;
	int far	*savebuf;
	unsigned key;
	long int	back;
	struct rccoord oldpos;

	/* save the current settings */
	fore = _gettextcolor();
	back = _getbkcolor();
	oldpos = _gettextposition();

/* Determine the number of strings in the menu */
	while (strary[n] != NULL)
		n++;

	maxchoice = n - 2;	/* maximum number of choices */

	/* determine the maximum menu string length */
	for (i = 0; i < n; i++)
		if (strlen (strary[i]) > len)
			len = strlen (strary[i]);

	/* save the menu background */
	if (mb_shadow)
		savebuf = box_get (row, col, row + n, col + len + 5);
	else
		savebuf = box_get (row, col, row + n - 1, col + len + 3);

	/* create the menu box */
	_settextcolor (c_lines);
	_setbkcolor (c_back);
	box_erase (row, col, row + n - 1, col + len + 3);
	box_draw (row, col, row + n - 1, col + len + 3, mb_lines);

	/* cast a shadow */
	if (mb_shadow)
		{
		_settextcolor ( T_GRAY);
		_setbkcolor (BK_BLACK);
		box_color (row+n, col+2, row+n, col + len + 3);
		box_color (row+1, col+len+4, row+n, col + len + 5);
		}

	/* put the title at the top */
	tmpcol = col + (len - strlen(strary[0]) + 4) / 2;
	_settextposition (row, tmpcol);
	_settextcolor (c_title);
	_setbkcolor (c_back);
	_outtext (strary[0]);

	/* print the choices */
	_settextcolor (c_text);
	for (i = 1; i <= maxchoice; i++)
		{
		_settextposition (row + i, col + 2);
		_outtext (strary[i]);
		}

	/* put the prompt at the bottom */
	tmpcol = col + ( len - strlen(strary[n - 1]) + 4 ) / 2;
	_settextposition (row+n-1, tmpcol);
	_settextcolor (c_prompt);
	_outtext (strary[n-1]);

	/* initialize choice if necessary */
	*choice = 1;

	/* process each keypress */
	while (!quit_flag)
		{
		/* determine and set the color attributes */
		for (i=1; i<=maxchoice; i++)
			{
			if (i == *choice)
				{
				_setbkcolor (c_hiback);
				_settextcolor (c_hiletter);
				box_color (row + i, col + 1, row + i, col + 2);
				_settextcolor (c_hitext);
				box_color (row + i, col + 3, row + i, col + len + 2);
				}
			else
				{
				_setbkcolor (c_back);
				_settextcolor (c_hiletter);
				box_color (row + i, col + 1, row + i, col + 2);
				_settextcolor (c_text);
				box_color (row + i, col + 3, row + i, col + len + 2);
				}
			}

		key = getkey();

		/* convert to uppercase */
		if (key >= 'a' && key <= 'z')
			key -= 32;

		/* check for alpha key */
		if (key >= 'A' && key <= 'Z')
			{
			for (i = 1; i <= maxchoice; i++)
				{
				*choice+= 1;
				if (*choice > maxchoice)
					*choice = 1;
				if (strary[*choice][0] == (char) key )
					break;
				}
			}

		/* check for control keys */
		switch (key)
			{
			case KEY_UP:
				if (*choice > 1)
					*choice -= 1;
				break;
			case KEY_DOWN:
					if (*choice < maxchoice)
					*choice += 1;
				break;
			case KEY_HOME:
					*choice = 1;
				break;
			case KEY_END:
					*choice = maxchoice;
				break;
			case KEY_ESCAPE:
				*choice = 0;
				quit_flag = 1;
				break;
			case KEY_ENTER:
				quit_flag = 1;
				break;
			}
		}

   /* put cursor at appropriate position */
   _settextposition (row + *choice, col + 2);

	/* restore original settings */
	_settextposition (oldpos.row, oldpos.col);
	_settextcolor (fore);
	_setbkcolor (back);
	return (savebuf);
}

/* =============================== */
int far *menu_message (int row, int col, char **strary)
/*  Create a pop-up message box            */
{
	int	n = 0;
	int	len = 0;
	int	fore;
	int	tmpcol;
	int	i;
	int	far	*savebuf;
	unsigned key;
	long	 int back;
	struct rccoord oldpos;

	/* save the current settings */
	fore = _gettextcolor();
	back = _getbkcolor();
	oldpos = _gettextposition();

/* Determine the number of strings in the menu */
	while (strary[n] != NULL)
		n++;

	/* determine the maximum menu string length */
	for (i = 0; i < n; i++)
		if (strlen (strary[i]) > len)
			len = strlen (strary[i]);

	/* save the menu packground */
	if (mb_shadow)
		savebuf = box_get (row, col, row+n, col + len+5);
	else
		savebuf = box_get (row, col, row+n-1, col + len + 3);

	/* create the message box */
	_settextcolor (c_lines);
	_setbkcolor (c_back);
	box_erase (row, col, row + n -1, col + len + 3);
	box_draw (row, col, row + n - 1, col + len + 3, mb_lines);

	/* cast a shadow */
	if (mb_shadow)
		{
		_settextcolor ( T_GRAY);
		_setbkcolor (BK_BLACK);
		box_color (row+n, col+2, row+n, col + len + 3);
		box_color (row+1, col+len+4, row+n, col + len + 5);
		}

	/* put the title at the top */
	tmpcol = col + (len - strlen(strary[0]) + 4) / 2;
	_settextposition (row, tmpcol);
	_settextcolor (c_title);
	_setbkcolor (c_back);
	_outtext (strary[0]);

	/* print the choices */
	_settextcolor (c_text);
	for (i = 1; i < n-1; i++)
		{
		_settextposition (row + i, col + 2);
		_outtext (strary[i]);
		}

	/* put the prompt at the bottom */
	tmpcol = col + ( len - strlen (strary[n-1]) + 4 ) /2;
	_settextposition (row+n-1, tmpcol);
	_settextcolor (c_prompt);
	_outtext (strary[n-1]);

	/* restore original settings */
	_settextposition (oldpos.row, oldpos.col);
	_settextcolor (fore);
	_setbkcolor (back);
	return (savebuf);


}

/* =============================== */
void menu_erase (int far *buf)
{
	box_put (buf);
	_ffree (buf);
}
