#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* necessary definitions */
#define	TRUE	1
#define MIN_FREE_DISK_SIZE 0

/* gps parameters */
#include	"tans_def.h"	/* declare variables for tans gps routines */
#include	"tans_pro.c"	/* tans procedures */
#define	GPS_WARNING_TIME	10		/* 07.04 warning bell every 10 (or setting) seconds */
time_t	gps_last_warning_time;	/* holds time of last gps warning */
struct	TANS_BUFFER	gps_info;	/* store the results here */

/* Function prototypes */
int check_free_disk_space (void);
unsigned long disk_free_kb(void);

int		ms_gps;

main(int argc, char **argv)
{
   int i,exit_loop;

   ms_gps = 2;

	/*  Initialize GPS Receiver */
	if (ms_gps > 0) {
		tans_init();
		time (&gps_last_warning_time);	/* initialize warning timer */
		if (ms_gps == 2) {					/* wait for lock in warning mode */
			printf("Waiting for GPS to lock onto satellites\n");
			printf("ESC to exit, RET to continue\n");
			exit_loop = !TRUE;				/* wait for a reply or until */
			Empty_Keyboard_Buffer();
			while (!exit_loop) {
				if (display_gps_status() == 0) exit_loop = TRUE;	/* 07.08 wait for last/lon to display */
				if (kbhit()) {
					i = getch();
					if (i == 0x1b) {
						tans_restore();
						exit(0);	/* abort program */
					}
					else if (i == '\r')
						exit_loop = TRUE;
				}	/* endif */
			}	/* end while waiting for lock */
		}	/* end if warning set */
	} /* if gps is enabled */

	display_gps_status();

   /* reset the GPS receiver */
	tans_restore();

}		/* end main() */

int display_gps_status(void)
/* take the current GPS reading and load the strcutre (through gans_get_gps_status
	and display the result on the GPS status lines (standardized display) 
	based on ms_gps, use the warning or standard line.

	Returns current gps status byte (0 == locked o.k.) */
{
	char	descr[50];
	time_t	now;	/* for current time */
	int	i, j;	/* used for delay loop */
	int	ret_status;	/* returned status, if =-1, then not all information correct */

	if (ms_gps == 2) /* warning line */
		printf("GPS_TEXT_LINE_WARN\n");
	else
		printf("GPS_TEXT_LINE\n");

	switch (ms_gps) {
		case 1:	/* gps on */
		case 2:	/* gps set to warning */
			ret_status = tans_get_gps_status (&gps_info);	/* get the gps information 07.08 */

			if (ms_gps == 2) {	/* do warning checks */
				time(&now);	/* get current time */
				if (ret_status == 0)		/* 07.08 */
				{ /* doing fixes */
					gps_last_warning_time = now;
				}
				else
				{	/* gps not locked, beep if time exceeded */
					if (fabs(difftime(now, gps_last_warning_time)) > (double) GPS_WARNING_TIME) 
					{  /* time to warn them, do a nasty display thing too... */
						/* do a funky message here */
						for (i = 0; i < 20; i++ ){
							strnset (descr, '.', 40);
							strcpy (&descr[i], "GPS NOT LOCKED.");
							printf("%s\n",descr);
							for (j=0; j < 15000; j++)	;	/* delay loop */
						}	/* end of funky message */
						printf ("\a");	/* sound bell here */
						for (i = 20; i > 0; --i ){ /* now do backwards */
							strnset (descr, '.', 40);
							strcpy (&descr[i], "GPS NOT LOCKED.");
							printf("%s\n",descr);
							for (j=0; j < 15000; j++)	;	/* delay loop */
						}	/* end of funky message */

						gps_last_warning_time = now;
					}
				}
			}	/* end gps warning check */
			switch (ret_status) {  /* 07.08 */
				case -1:	/* still waiting for all packets info to accompany a fix 07.08 */
					sprintf (descr, "Wait   %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 0:	/* doing fixes */
					sprintf (descr, "Locked %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 1:	/* no GPS time yet */
					sprintf (descr, "NoTime %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 8:	/* no sats */
					sprintf (descr, "NO Sat %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 9:	/* 1 satellite */
					sprintf (descr, "1 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 0xa:	/* 2 satellites */
					sprintf (descr, "2 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				case 0xb:	/* 3 satellites */
					sprintf (descr, "3 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
				default:
					sprintf (descr, "Unknwn %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						printf("%s\n",descr);
					break;
			}	/* end switch on status */
			break;
		case 0:  /* no gps in use */
			strcpy (descr, "Off");
			printf("%s\n",descr);
			break;
	} /* end switch on ms_gps */
	if (ms_gps == 0) /* no gps */
		return (0);	/* return all o.k. in this case */
	else
		return (ret_status);	/* return current status (including -1) 07.08 */
}	/* end display_gps_status */
	
int check_free_disk_space (void)
/* gets the free disk space (from disk_free_kb procedure which checks
	disk C:) and returns true if the available space is less than the level
	specified by MIN_FREE_DISK_SIZE. Also display message and waits for operator
	to acknowledge this error. version 0.06.07 */
{
	int	ret = !TRUE;
	if (disk_free_kb() <= (long) MIN_FREE_DISK_SIZE)
	{	/* low disk space condition is here */
		ret = TRUE;
		printf ("\a");	/* alert */
		printf("The data disk is nearly full\n");
		printf("Program will stop.  PRESS RETURN\n");
		printf ("\a");	/* alert */
		getch();
	}	/* end low disk space */
	return (ret);
}	/* end check_free_disk_space */

unsigned long disk_free_kb(void)
/* returns kbytes free (rounded down) as long integer value */
/*  Only checks the C drive (disk 3) */
/* Source Microcsoft C Bible  pg 608 */

{
//unsigned long total_space, free_space, bytes_per_cluster;
	unsigned long free_space, bytes_per_cluster;
	struct	diskfree_t	dfinfo;

	if (_dos_getdiskfree(3, &dfinfo) != 0) /* can't do this disk */
	{
		printf ("Error in function\n");
		return (0L);
	}
	bytes_per_cluster = dfinfo.sectors_per_cluster * dfinfo.bytes_per_sector;
	free_space = dfinfo.avail_clusters * bytes_per_cluster;
	free_space = free_space / 1000L;
	return (free_space);
}	/* end disk_free_kb */

Empty_Keyboard_Buffer(void)
{
  while( kbhit() )
    getch();
}


