/* necessary definitions */
#define	TRUE	1
#include	"tans_def.h"	/* declare variables for tans gps routines */
#include	"tans_pro.c"	/* tans procedures */

/* gps parameters */
#define	GPS_WARNING_TIME	10	/* 07.04 warning bell every 10 (or setting) seconds */
time_t	gps_last_warning_time;	/* holds time of last gps warning */
struct	TANS_BUFFER	gps_info;	/* store the results here */

//define	BLANKLINE			"1234567890123456789012345678901234567890"
//define	BLANKLINE			"xxxxxx xx xx xx xx x.x xx.xxxx xxxx.xxxx"
#define	GPS_TEXT_LINE		"GPS        Sats    PDOP    Lat      Lon "
#define	GPS_TEXT_LINE_WARN "GPS(w)     Sats    PDOP    Lat      Lon "
//define	BLANKLINE			" %6d     %6d    %14s          %11s"
//define	BLANKLINE			"xxxxxx xxxxxx aaaaaaaaaaaaaa aaaaaaaaaaa"
#define	SYS_TEXT_LINE		" Meas#   Pos#   Out File(free)    Status"
//define	BLANKLINE			"xx/xx xx/xx x xx  x.xxx to x.xxx (xx/xx)"
#define	MEAS_TEXT_LINE		" Pass  Scan A dB     Frequency(GHz)     "


main(int argc, char **argv)
{
/* If gps is needed, initialize unit here 07.06 */
	if (ms_gps > 0) {
		_clearscreen (_GCLEARSCREEN);	/* clear the screen */
		display_message (1,"Initializing the GPS receiver.");
		tans_init();
		time (&gps_last_warning_time);	/* initialize warning timer */
		if (ms_gps == 2) {	/* wait for lock in warning mode */
			display_message (7,"Waiting for GPS to lock onto satellites");
			display_message (8,"ESC to exit, RET to continue");
			exit_loop = !TRUE;	/* wait for a reply or until */
			empty_keyboard_buffer();
			while (!exit_loop) {
/* display status and only proceed if doing fixes (and all info present) */
/* the next two lines were replaced with the following one line */
//				display_gps_status();	/* display current */
//				if ((gps_info.last_status == 0) & (gps_info.last_lon != 0.0)) exit_loop = TRUE;	/* wait for last/lon to display */
				if (display_gps_status() == 0) exit_loop = TRUE;	/* 07.08 wait for last/lon to display */

				if (kbhit()) {
					i = getch();
					if (i == 0x1b) {
						tans_restore();
						reset_instruments (hsa_ud, att1_ud, att2_ud);
						_clearscreen (_GCLEARSCREEN);	/* clear the screen */
						exit(0);	/* abort program */
					}
					else if (i == '\r')
						exit_loop = TRUE;
				}	/* endif */
			}	/* end while waiting for lock */
		_clearscreen (_GCLEARSCREEN);	/* clear the screen */
		}	/* end if warning set */
	} /* if gps is enabled */

			case 4:	/* moving mobile measurements */
				exit_loop = ask_position_record4(); /* wait for cmd to start measure */
				if (!exit_loop) {
/* set the last attenuation time and the last position time such that they trigger
	on the first pass through the loop */
					time (&time_last_atten);  /* time of auto-attenuate function */
					time_last_atten -= ms_type_arg2 + 10L;	/* this should force first attenuate  08.04 */
					time (&time_last_position);  /* time of auto-attenuate function */
					time_last_position -= ms_type_arg1 + 10L;	/* 08.04 this should force first measurement */
					time (&ending_time);	/* ending time (type 3 only) */
					if (ms_type_arg4 == 0L)	/* 08.04 if 0, then run for a month */
						ending_time += 30L * 24L *3600L;	/* d0 days * 24 hrs * 3600 sec/hr = 1 month */
					else
						ending_time += ms_type_arg4;	/* 08.04 duration in arg4 */

					display_sys_status ("WAITING");
					display_message (7, "hold (h/CR), ESC= abort");
					while (!exit_loop) {
						display_gps_status();
						time (&now);
						if (difftime(now, time_last_atten) > (double) ms_type_arg2) {  /* time to autoattenuate */
							time (&time_last_atten);  /* time of auto-attenuate function */
							get_attenuator_settings (hsa_ud, att1_ud, att2_ud);	/* determine attenuator settings */
							display_sys_status ("WAITING");
							display_message (7, "hold (h/CR), ESC= abort");
						} /* end if time to autoattenuate again */
						time (&now);
						if (difftime(now, time_last_position) > (double) ms_type_arg1) {  /* time to autoattenuate */
							time (&time_last_position);  /* time of auto-attenuate function */
							fprintf (data_file, MS_REC_TYPE, MS_POSITION_INDEX_ID); /* 08.07 bug fix */
							fprintf (data_file, MS_POSITION_INDEX, number_positions_measured); /* write position index */
							do_position_record(hsa_ud, att1_ud, att2_ud);  /* do an entire position */
							number_positions_measured++;
							display_sys_status ("WAITING");
							display_message (7, "hold (h/CR), ESC= abort");
							if (ms_graphics) {
								display_position_graph();
							}  /* end if grapics display */
						} /* end do a position */
					/* see if kbhit and act on it */
						if (kbhit()) {	/* some key was pressed */
							switch ((int) getch()) {	/* get the character */
								case 'h':	/* hold */
									empty_keyboard_buffer();	/* dump any other keystrokes */
									display_sys_status ("HOLD");
									display_message (7,"Holding (h/CR=cont or ESC=abort)");
									i = 0;
									while (i != 'h' && i != '\r' && i != 0x1b) { /* only exit with RET, ESC, or 'h' */
										while (!kbhit()) display_gps_status(); /* constantly update GPS */
										i = getch();
									}
									if (i == 0x1b) exit_loop = TRUE;
									display_message (7, "hold (h/CR), ESC= abort");
									break;
								case 0x1b:	/* escape */
									exit_loop = TRUE;
									break;
								default:
									empty_keyboard_buffer();	/* dump any other keystrokes */
									printf ("\a");
									break;
							}	/* end switch */
							clr_line (7);	/* clear this line */
						}	/* end kbhit */
						if (ms_type == 3) {	/* check to see if time expired (type 3) */
							time (&now);
							if (now > ending_time) {
								display_message (7,"Running time completed");
								exit_loop = TRUE;
							}	/* end check of time */
						}	/* end type 3 (/
					if (!exit_loop) exit_loop = check_free_disk_space();	/* chk only if not exiting 06.07 */
					} /* end while */
					reset_graphics();
				}  /* end if exit_loop */
				break;
			default:	/* not implemented */
				printf ("Case %d Not Supported...Press RET to exit\n");
				exit_loop = TRUE;
				break;
		}	/* end switch ms_type */
	}	/* end while not exit */

/* reset the GPS receiver (if enabled ) */
	if (ms_gps > 0) tans_restore();

}		/* end main() */


write_gps_record()
/* write a gps record (get the record here into global variables gps_info) */
/*  Note, also does update of the sceen (which updates the structure) */
{
//	tans_get_gps_status (&gps_info);	/* get the gps information */
	int	ret_status;

	ret_status = display_gps_status();

	fprintf (data_file, MS_REC_TYPE, MS_POSITION_GPS_ID);
	fprintf (data_file, MS_POSITION_GPS, 
		number_positions_measured,
		gps_info.stale,
//			gps_info.c_status,	/* replace c_status with the returned status which */
		ret_status,		/* may be -1 if not all packets are in to accompany a fix 07.08 */
		gps_info.c_pdop,
		gps_info.last_lat,
		gps_info.last_lon,
		gps_info.last_alt,
		gps_info.last_pdop,
		gps_info.last_sats[0],
		gps_info.last_sats[1],
		gps_info.last_sats[2],
		gps_info.last_sats[3]);
}	/* end write_gps_record */
int display_gps_status(void)
/* take the current GPS reading and load the strcutre (through gans_get_gps_status
	and display the result on the GPS status lines (standardized display) 
	based on ms_gps, use the warning or standard line.

	Returns current gps status byte (0 == locked o.k.) */
{
	char	descr[50];
	time_t	now;	/* for current time */
	int	i, j;	/* used for delay loop */
	int	ret_status;	/* returned status, if =-1, then not all information correct */

/* Do header line */
	_settextposition(GPS_LINE1_ROW, 1);
	rev_video();
	if (ms_gps == 2) /* warning line */
		_outtext (GPS_TEXT_LINE_WARN);
	else
		_outtext (GPS_TEXT_LINE);

/* Now do information */
	std_video();
	_settextposition(GPS_LINE2_ROW, 1);
	switch (ms_gps) {
		case 1:	/* gps on */
		case 2:	/* gps set to warning */
			ret_status = tans_get_gps_status (&gps_info);	/* get the gps information 07.08 */

			if (ms_gps == 2) {	/* do warning checks */
				time(&now);	/* get current time */
				if (ret_status == 0)		/* 07.08 */
//				if (gps_info.c_status == 0)	
				{ /* doing fixes */
					gps_last_warning_time = now;
				}
				else
				{	/* gps not locked, beep if time exceeded */
					if (fabs(difftime(now, gps_last_warning_time)) > (double) GPS_WARNING_TIME) 
					{  /* time to warn them, do a nasty display thing too... */
						/* do a funky message here */
						for (i = 0; i < 20; i++ ){
							strnset (descr, '.', 40);
							strcpy (&descr[i], "GPS NOT LOCKED.");
							display_message (6, descr);
							for (j=0; j < 15000; j++)	;	/* delay loop */
						}	/* end of funky message */
						printf ("\a");	/* sound bell here */
						for (i = 20; i > 0; --i ){ /* now do backwards */
							strnset (descr, '.', 40);
							strcpy (&descr[i], "GPS NOT LOCKED.");
							display_message (6, descr);
							for (j=0; j < 15000; j++)	;	/* delay loop */
						}	/* end of funky message */

						_settextposition(GPS_LINE2_ROW, 1);
						gps_last_warning_time = now;
					}
				}
			}	/* end gps warning check */
			switch (ret_status) {  /* 07.08 */
//			switch (gps_info.c_status) {
				case -1:	/* still waiting for all packets info to accompany a fix 07.08 */
					sprintf (descr, "Wait   %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 0:	/* doing fixes */
					sprintf (descr, "Locked %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 1:	/* no GPS time yet */
					sprintf (descr, "NoTime %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 8:	/* no sats */
					sprintf (descr, "NO Sat %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 9:	/* 1 satellite */
					sprintf (descr, "1 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 0xa:	/* 2 satellites */
					sprintf (descr, "2 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				case 0xb:	/* 3 satellites */
					sprintf (descr, "3 Sat  %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
				default:
					sprintf (descr, "Unknwn %2d.%2d.%2d.%2d %3.1f %7.4lf %9.4lf",
						gps_info.c_sats[0],
						gps_info.c_sats[1],
						gps_info.c_sats[2],
						gps_info.c_sats[3],
						gps_info.c_pdop,
						gps_info.last_lat,
						gps_info.last_lon);
						_outtext (descr);
					break;
			}	/* end switch on status */
			break;
		case 0:  /* no gps in use */
			strcpy (descr, "Off");
			_outtext (descr);
			break;
	} /* end switch on ms_gps */
	if (ms_gps == 0) /* no gps */
		return (0);	/* return all o.k. in this case */
	else
		return (ret_status);	/* return current status (including -1) 07.08 */
}	/* end display_gps_status */
	
int check_free_disk_space (void)
/* gets the free disk space (from disk_free_kb procedure which checks
	disk C:) and returns true if the available space is less than the level
	specified by MIN_FREE_DISK_SIZE. Also display message and waits for operator
	to acknowledge this error. version 0.06.07 */
{
	int	ret = !TRUE;
	if (disk_free_kb() <= (long) MIN_FREE_DISK_SIZE)
	{	/* low disk space condition is here */
		ret = TRUE;
		printf ("\a");	/* alert */
		display_message (7,"The data disk is nearly full");
		display_message (8,"Program will stop.  PRESS RETURN");
		printf ("\a");	/* alert */
		getch();
	}	/* end low disk space */
	return (ret);
}	/* end check_free_disk_space */

unsigned long disk_free_kb(void)
/* returns kbytes free (rounded down) as long integer value */
/*  Only checks the C drive (disk 3) */
/* Source Microcsoft C Bible  pg 608 */

{
//unsigned long total_space, free_space, bytes_per_cluster;
	unsigned long free_space, bytes_per_cluster;
	struct	diskfree_t	dfinfo;

	if (_dos_getdiskfree(3, &dfinfo) != 0) /* can't do this disk */
	{
		printf ("Error in function\n");
		return (0L);
	}
	bytes_per_cluster = dfinfo.sectors_per_cluster * dfinfo.bytes_per_sector;
	free_space = dfinfo.avail_clusters * bytes_per_cluster;
	free_space = free_space / 1000L;
	return (free_space);
}	/* end disk_free_kb */
