/***************************************************************
 *    Sample.c  - Used to develop and debug initial set of HP11759B
 *     fading simulator control procedures using the serial to GPIB
 *		 black box interface.
 *
 *
* ------------------------------------------------------------------------
*/


/* system and compiler include files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gpib_lib.c"
#include "hp11759b.c"

/* Define the GPIB address */
#define	HPFADESIM_DEV	11;		/* GPIB logical device number */

main()
{

	int hpfs_dev;
	int ud, ret, profile_num;

	hpfs_dev = HPFADESIM_DEV;

	/* Initialize the instruments */
	ud = gpib_open(hpfs_dev);		// get the ud for network analyzer
	if (ud <= 0)
	{  /* Open error for signal generator */
		printf ("  *** ERROR with Fading Simulator Interface\n");
		return(!TRUE);
	}

	/* Initialization Routines */

	/* Insert test procedures here */
	 hp11759b_set_simulation (ud);
	 printf("ENTER PROFILE NUMBER: ");
	 scanf("%d", &profile_num);
	 hp11759b_recall_user_profile (ud, profile_num);
    hp11759b_set_main_menu (ud);
	 hp11759b_exit_program (ud);
	/* Put Signal Generator back into local mode */
	gpib_local (ud);

	return (0);

}
