#include <stdio.h>					 
#include <stdlib.h>
#include	<math.h>
#include	<string.h>
#include	<time.h>
#include <conio.h>

#include "gpib_lib.c"		// basic library
#include "ifr_lib.c"

#define IFR_DEV 2

main(int argc, char **argv)
{
	int ifr_dev = IFR_DEV;		// GPIB logical device number for IFR 1600CSA
	int ifr_ud ;		// GPIB handler for new 488 routines for IFR
	char response[20];
	char message [128];
	int exit_loop = 0;
	int mask = TIMO;
	char *result;
	int i,message_len = MAX_MESSAGE_LENGTH;
	int num_l3m;
	int registered = 0;
	int continue_test = 1;

	ifr_ud = gpib_open(ifr_dev);		// get the ud for the IFR 

	ibtmo(ifr_ud,13);
	gpib_write(ifr_ud, "fdinit 771,7,1,1,1,1,0");
	printf ("Setting up DCCH, please wait ...\n");
	ibwait(ifr_ud,mask);

	ibtmo(ifr_ud,11);
	gpib_write(ifr_ud,":rdcch:length:normal");
	ibwait(ifr_ud,mask);
	printf("DCCH Setup \n");
	printf("Power up phone ...\n");

	while (continue_test){	
		gpib_write(ifr_ud, ":rdcch:nl3m?");
	   ibwait(ifr_ud,mask);
		strset(response,' ');
		gpib_read(ifr_ud,response, 20);
		num_l3m = atoi(response);
		printf("number layer 3 messages = %d\n", num_l3m);
	   
		if(num_l3m > -1) {
			gpib_write(ifr_ud,"reg_accept");
			while(continue_test){  
					for(i=0;i<num_l3m;i++){
						ibwait(ifr_ud,mask);
						strset(response,' ');
						strset(message,' ');
						sprintf (message, ":rdcch:l3data:sel %d\n", 1-i);
						gpib_write(ifr_ud,message);
					   ibwait(ifr_ud,mask);
						gpib_write(ifr_ud, ":rdcch:msgtype?");
					   ibwait(ifr_ud,mask);
						gpib_read(ifr_ud, response,20);
						printf("the response is %s\n", response);
						if((result = strstr(response,"REGISTRATION")) != NULL){
							registered = 1;
						}
  					exit_loop =kb_exit_loop();
					} /* for loop */

					exit_loop =kb_exit_loop();
					continue_test = ((!registered) & (!exit_loop));
		} /* inner while loop */

		} /* if */

		exit_loop =kb_exit_loop();
		continue_test = ((!registered) & (!exit_loop));
	}	/* outer while loop */

}
