//
// HP Attenuator Controller (HP11713A) Routines  488 VERSION!!!
//   3/17/92  Started
//
//  Routines
//		atten_set_x(dev, value);  /* set X attenuator to value (0-15) */
//		atten_set_y(dev, value);  /* set X attenuator to value (0-15) */
//		atten_set_s9(dev, 1/0);  /* set switch s9 */
//		atten_set_s0(dev, 1/0);  /* set switch s0 */

atten_set_s9 (int dev, int bvalue)		
/*  set switch port s9 to (1) ON or (0) off */
{
	int	i;
	switch (bvalue) {
		case 0:
			i = gpib_write (dev, "B9");
			break;
		case 1:
			i = gpib_write (dev, "A9");
			break;
		default:
			printf ("atten_s9 error, unexpected argument: %d\n", bvalue);
			break;
	}  /* end switch */
}		/* end atten_set_s9 */

atten_set_s0 (int dev, int bvalue)		
/*  set switch port s0 to (1) ON or (0) off */
{
	int	i;
	switch (bvalue) {
		case 0:
			i = gpib_write (dev, "B0");
			break;
		case 1:
			i = gpib_write (dev, "A0");
			break;
		default:
			printf ("atten_s9 error, unexpected argument: %d\n", bvalue);
			break;
	}  /* end switch */
}		/* end atten_set_s0 */


atten_set_y (int dev, int dB)  /* set Y attenuator to value (0-11) */
/* set attenuator on unit, entry in dB (assume step of 10) */
/*  Note that lower number (5 in this case) is lsb, higher number (8) is
		msb (backwards from what I thought)  */
{
	struct COMMANDS {
		char cmd[16];
	};
	struct COMMANDS codes[] = { /* define the 12 steps of attenuation */
		"B5678", "B678A5", "B578A6", "B78A56", /* 0, 10, 20, 30 dB steps */
		"B567A8", "B67A58", "B57A68", "B7A568", /* 40, 50, 60, 70 dB */
		"B56A78", "B6A578", "B5A678", "A5678"};
	int	code;

	code = ceil(dB / 10);
//	printf("%d code = %s\n", code, codes[code].cmd);
	gpib_write (dev, codes[code].cmd);
}	/* end set_attenuator */

atten_set_x(int dev, int dB)  /* set X attenuator to value (0-11) */
/* set attenuator on unit, entry in dB (assume step of 10) */
/*  Note that lower number (5 in this case) is lsb, higher number (8) is
		msb (backwards from what I thought)  */
{

	struct COMMANDS {
		char cmd[16];
	};
	struct COMMANDS codes[] = { /* define the 12 steps of attenuation */
		"B1234", "B234A1", "B134A2", "B34A12", /* 0, 1, 2, 3 dB steps */
		"B123A4", "B23A14", "B13A24", "B3A124", /* 4, 5, 6, 7 dB */
		"B12A34", "B2A134", "B1A234", "A1234"};
	int	code;

	code = dB;
	gpib_write (dev, codes[code].cmd);
}	/* end set_attenuator */
