#include <stdio.h>
#include <stdlib.h>
#include "gpib_lib.c"		// basic library
#include "ifr_lib.c"		  // ifr routines

int process_command_line_arguments (int argc, char **argv, int *ifr_dev)
/* read and do any and all command line arguments from dos */
/*  Returns TRUE if all arguments were valid */
{
	/* Required are three arguments */
	if (argc != 2)
	{
		printf ("Arguments Required: number(1-99) \n");
		return (!TRUE);
	}

	/* Transfer device number and channel number back */
	*ifr_dev = atoi (argv[1]);
		

	return (TRUE);
}	/* end process_command_lines */

main(int argc, char **argv)
{
	int ifr_ud ;		// GPIB handler for new 488 routines for IFR
	int ifr_dev;		// GPIB logical device number for IFR 1600CSA
	int err_msg;
	int mask = TIMO;

	/* process any command line arguments */
	if (!process_command_line_arguments (argc, argv, &ifr_dev))
	{
		printf ("Command Line Error, Program aborted\n");
		exit (1);
	}

	ifr_ud = gpib_open(ifr_dev);		// get the ud for the IFR 

	gpib_err_msg(ifr_ud);
	err_msg = gpib_wait(ifr_ud, mask);

	printf ("ibsta = %d, err = %d, iberr = %d\n", ibsta, err_msg, iberr);

}

