#define	PROGRAM_NAME	"brcst_dcch.c"
#define	VERSION	1.01

// brcst_dcch.c
//
//   Broadcast DCCH Test
//
//   Loads IFR TMAC Code and runs procedure to broadcast DCCH
//   on specified channel with access parameters set to their maximum values
//
//		Usage:
//			brcst_dcch c n
//
//		Where:
//			n = gpib device number for IFR 
//			c = forward channel number (see below)
//

// =================================================================

#include <stdio.h>
#include <stdlib.h>
#include "gpib_lib.c"		// basic library
#include "ifr_lib.c"		  // ifr routines

int process_command_line_arguments (int argc, char **argv, int *ch_number, int *ifr_dev)
/* read and do any and all command line arguments from dos */
/*  Returns TRUE if all arguments were valid */
{
	/* Required are three arguments */
	if (argc != 3)
	{
		printf ("Arguments Required: number(1-99) \n");
		return (!TRUE);
	}

	/* Transfer device number and channel number back */
	*ch_number = atoi (argv[1]);
	*ifr_dev = atoi (argv[2]);
		

	return (TRUE);
}	/* end process_command_lines */

main(int argc, char **argv)
{
	int ifr_ud ;		// GPIB handler for new 488 routines for IFR
	int ch_number;
	int ifr_dev;		// GPIB logical device number for IFR 1600CSA

	/* Define IFR Data Structures */
	ACCESS_PARAMS acc;

	/* Initialize Access Parameters (IFR) */
	acc.MaxReps = 8;		 /* Max Repetitions */
	acc.MaxRetries = 3;	 /* Max Retries */
	acc.MaxBusy = 10;		 /* Max Busy/Reserved */
	acc.MaxStop = 2;		 /* Max Stop Counter */
	acc.DelayInterval =1; /* DIC */
	acc.burst =1;			 /* ARQ */

	/* process any command line arguments */
	if (!process_command_line_arguments (argc, argv, &ch_number, &ifr_dev))
	{
		printf ("Command Line Error, Program aborted\n");
		exit (1);
	}

	ifr_ud = gpib_open(ifr_dev);		// get the ud for the IFR 

	/* setup DCCH w/ appropriate access parameters */
	ifr_init_FDCCH(ifr_ud, &acc, ch_number);

}

