#include "\pcl\gpib_488\hp11713.c"	/* attenuator controller routines */

#define	HP_ATT1	12	/* HP attenuator controller #1 */


main()
{
 	int att1_ud;

	att1_ud = gpib_open (HP_ATT1);	/* get the handler (access number) */

	set_attenuator (att1_ud, 0);	/* set to 0 dB attenuation */

}





set_attenuator (int unit, int dB)
/* set attenuator on unit, entry in dB (assume step of 10) */
/*  Note that lower number (5 in this case) is lsb, higher number (8) is
		msb (backwards from what I thought)  */
{

	struct COMMANDS {
		char cmd[16];
	};
	struct COMMANDS codes[] = { /* define the 16 steps of attenuation */
		"B5678", "B678A5", "B578A6", "B78A56", /* 0, 10, 20, 30 dB steps */
		"B568A7", "B68A75", "B58A76", "B8A567", /* 40, 50, 60, 70 dB */
		"B567A8", "B67A58", "B57A86", "B7A865",
		"A78B56", "A578B6", "A876B5", "A5678"} ;
	int	code;

	code = dB / 10;
	gpib_write (unit, codes[code].cmd);
}	/* end set_attenuator */

