//
// HP Attenuator Controller (HP11713A) Routines  488 VERSION!!!
//   3/17/92  Started
//
//  Routines
//		atten_set_x(dev, value);  /* set X attenuator to value (0-15) */
//		atten_set_y(dev, value);  /* set X attenuator to value (0-15) */
//		atten_set_s9(dev, 1/0);  /* set switch s9 */
//		atten_set_s0(dev, 1/0);  /* set switch s0 */

atten_set_s9 (int dev, int bvalue)		
/*  set switch port s9 to (1) ON or (0) off */
{
	int	i;
	switch (bvalue) {
		case 0:
			i = gpib_write (dev, "B9");
			break;
		case 1:
			i = gpib_write (dev, "A9");
			break;
		default:
			printf ("atten_s9 error, unexpected argument: %d\n", bvalue);
			break;
	}  /* end switch */
}		/* end atten_set_s9 */

atten_set_s0 (int dev, int bvalue)		
/*  set switch port s0 to (1) ON or (0) off */
{
	int	i;
	switch (bvalue) {
		case 0:
			i = gpib_write (dev, "B0");
			break;
		case 1:
			i = gpib_write (dev, "A0");
			break;
		default:
			printf ("atten_s9 error, unexpected argument: %d\n", bvalue);
			break;
	}  /* end switch */
}		/* end atten_set_s0 */


