//  GPIB_LIB.C
//
//   Library routines for GPIB board.
//		 DOES NOT RUN UNDER ULI(Universal Language Interface).
//
//	02/05/93  Changed the include for decl.h to look to drive c:  csp
//
//  04-14-91  Copied from gpib_uli and modified for non-uli environment.
//
//	NOTE: This module should be included BEFORE other gpib handler includes
//
//
//  Routines:
//		ud = int gpib_open (logical_device); Opens a logical device, returns 'ud'
//		bytes_read = gpib_read (int ud, char string[], number_bytes); read from a device
//		bytes_written = gpib_write (int ud, char string[]);  write to a device
//    gpib_local(int ud);		set this device to local

// Declare the gpib variables and constants file
#include	"c:\at-gpib\decl.h"
#include	<string.h>

//  Declare stuff here

int gpib_open(int logical_device)
//  Open a specific instruement on logical device (1-15) specified.
//		returns the "ud", the device handler number for subsequent read/writes
//	If not found, or other error, program aborts
{
	int	ud;
	char	buffer[16];

	sprintf (buffer, "DEV%d", logical_device);
	ud = ibfind (buffer);
	if (ud < 0) {		// error occured
		printf ("gpib_open-FATAL-Error opening device <%s>\n", buffer);
		exit (1);
	}
	ibclr (ud);
	return (ud);
}	// end gpib_open

int gpib_read (int ud, char string[], int number_bytes)
// Read in a string of "number_bytes" characters from the device at ud.
//  The actual number of bytes ready (int value) is returned
{
	ibrd (ud, string, (long) number_bytes);
	return (ibcnt);		// return the actual number of bytes read
}

int gpib_write (int ud, char string[])
// Read in a string of "number_bytes" characters from the device at ud.
//  The actual number of bytes ready (int value) is returned
{
	ibwrt (ud, string, (long) strlen(string));
	return (ibcnt);		// return the actual number of bytes written
}

gpib_local(ud)
int ud;
{
	ibloc (ud);		// switch device to local
}

