// Defines for Fluke signal generators
#define	HZ400 0
#define	HZ1K 1
#define	NONE 0
#define	INTERNAL_MODE 1
#define	EXTERNAL_MODE 2

// Defines for various RF states
#define	STANDBY	0
#define	ON			1
#define	RFOFF		2		
#define	RFON		3

fsg_reset_hpsl (int dev);
fsg_freqHz (int dev, float freq);  // Set carrier frequency in Hz
fsg_freqHz_hpsl (int dev, float freq); // Set carrier frequency in Hz
fsg_freqMHz (int dev, float freq);  // Set carrier frequency in MHz
fsg_freqMHz_hpsl (int dev, float freq);  // Set carrier frequency in MHz
fsg_ampdBm (int dev, float value); // Set amplitude in dBm
fsg_ampdBm_hpsl (int dev, float value); // Set amplitude in dBm
fsg_ampV (int dev, float value);  // Set amplitude in Volts				
fsg_rf (int dev, int value); // Set system state (Standby/On/RF On/RF Off)
fsg_rf_hpsl (int dev, int value); // Set system state (Standby/On/RF On/RF Off)
fsg_ammod (int dev, int value);			// Set the AM modulation
fsg_fmmod (int dev,int value);	 // Set the FM modulation
fsg_fmdeviation(int dev, double value);  // Set the FM modulation
fsg_spcl(int dev, double value);  // Set special functions
fsg_text (int dev,char text[]);  // Set other text commands

fsg_reset_hpsl (int dev)
{
   char string[64];
	sprintf(string,"*RST");
// printf("GPIB write string <%s>\n",string);
   gpib_write (dev, string);
}

fsg_freqHz (int dev, float freq)  // Set carrier frequency in Hz
{
	char	string[64];
	sprintf (string, "FR%fHZ", freq);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}										

fsg_freqHz_hpsl (int dev, float freq) // Set carrier frequency in Hz
{
   char string[64];
   sprintf(string,"FREQ %fHZ", freq);
//	printf("GPIB write string <%s>\n",string);
   gpib_write(dev, string);
}

fsg_freqMHz (int dev, float freq)  // Set carrier frequency in MHz
{
	char	string[64];
	sprintf (string, "FR%.6fMZ", freq);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}

fsg_freqMHz_hpsl (int dev, float freq)  // Set carrier frequency in MHz
{
	char	string[64];
	sprintf (string, "FREQ %.6fMHZ", freq);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}

fsg_ampdBm (int dev, float value) // Set amplitude in dBm
{
	char	string[64];
	sprintf (string, "AP%.1fDM", value);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}										

fsg_ampdBm_hpsl (int dev, float value) // Set amplitude in dBm
{
	char	string[64];
	sprintf (string, "AMPL %.1fDBM",value);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}

fsg_ampV (int dev, float value)  // Set amplitude in Volts				
{
	char	string[64];
	sprintf (string, "AP%fV", value);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}										

fsg_rf (int dev, int value) // Set system state (Standby/On/RF On/RF Off)
{
	char	string[64];		  
	sprintf (string, "R%1d", value);
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}										

fsg_rf_hpsl (int dev, int value) // Set system state (Standby/On/RF On/RF Off)
{
	char	string[64];		  
	if (value == RFOFF)
	  strcpy(string, "AMPL:STATE OFF");
   if (value == RFON)
	  strcpy (string, "AMPL:STATE ON");
// printf("GPIB write string <%s>\n",string);
	gpib_write (dev, string);
}

fsg_ammod (int dev, int value)			// Set the AM modulation
{

	switch (value)
		{
			case NONE:
						gpib_write (dev, "AI0");
						gpib_write (dev, "AE0");
						break;
			case INTERNAL_MODE:
						gpib_write (dev, "AI1");
						gpib_write (dev, "AE0");
						break;
			case EXTERNAL_MODE:
						gpib_write (dev, "AI0");
						gpib_write (dev, "AE1");
						break;
		}

}

fsg_fmmod (int dev,int value)	 // Set the FM modulation
{
	switch (value)
		{
			case NONE:
						gpib_write (dev, "FI0");
						gpib_write (dev, "FE0");
						break;
			case INTERNAL_MODE:
						gpib_write (dev, "FI1");
						gpib_write (dev, "FE0");
						break;
			case EXTERNAL_MODE:
						gpib_write (dev, "FI0");
						gpib_write (dev, "FE1");
						break;
		}

}

fsg_fmdeviation(int dev, double value)  // Set the FM modulation
{
	char	string[64];		  
	sprintf (string, "FM%fHZ", value);
	gpib_write (dev, string);

}									

fsg_spcl(int dev, double value)  // Set special functions
{
	char	string[64];		  
	sprintf (string, "SP%2f", value);
	gpib_write (dev, string);

}

fsg_text (int dev,char text[])  // Set other text commands
{												
	char	string[64];		  
	gpib_write (dev, text);
}

