'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   This module contains the subroutine declarations,
'   function declarations and constants required to use
'   the National Instruments GPIB Dynamic Link Library
'   (DLL) for controlling IEEE-488 instrumentation.  This
'   file must be 'added' to your Visual Basic project
'   (by choosing Add File from the File menu or pressing
'   CTRL+F12) so that you can access the NI-488.2
'   subroutines and functions.
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   NI-488 subroutine codes

Const zIBWAIT = &H0
Const zIBONL = &H1
Const zIBRSC = &H2
Const zIBSIC = &H3
Const zIBSRE = &H4
Const zIBLOC = &H5
Const zIBRSV = &H6
Const zIBPPC = &H7
Const zIBPAD = &H8
Const zIBSAD = &H9
Const zIBIST = &HA
Const zIBDMA = &HB
Const zIBEOS = &HC
Const zIBTMO = &HD
Const zIBEOT = &HE
Const zIBGTS = &HF
Const zIBCAC = &H10
Const zIBRDF = &H11
Const zIBWRTF = &H12
Const zIBRPP = &H13
Const zIBPOKE = &H14
Const zIBSTOP = &H15
Const zIBCLR = &H16
Const zIBTRG = &H17
Const zIBPCT = &H18
Const zIBRSP = &H19
Const zIBBNA = &H1A
Const zIBFIND = &H1B
Const zIBRD = &H1C
Const zIBRDA = &H1D
Const zIBWRT = &H1E
Const zIBWRTA = &H1F
Const zIBCMD = &H20
Const zIBCMDA = &H21
Const zIBDIAG = &H22
Const zIBXTRC = &H23
Const zIBLN = &H25
Const zIBGDN = &H26
Const zIBSTF = &H27
Const zIBLINES = &H28
Const zWRTF_NEW = &H29
Const zRDF_NEW = &H2A
Const zF_IO_END = &H2B
Const zIBCONFIG = &H2C
Const zIBWRTKEY = &H2E
Const zIBRDKEY = &H2F
Const zIBRDI = &H30
Const zIBRDIA = &H31
Const zIBWRTI = &H32
Const zIBWRTIA = &H33
Const zIBEVENT = &H39
Const zIBASK = &H3A

' NI-488.2 function codes

Const zSENDCMDS = &H80
Const zSENDSETUP = &H81
Const zSENDDATABYTES = &H82
Const zSEND = &H83
Const zRCVSETUP = &H84
Const zRCVDATABYTES = &H85
Const zRECEIVE = &H86
Const zSENDIFC = &H87
Const zDEVICECLEAR = &H88
Const zENABLELOCAL = &H89
Const zENABLEREMOTE = &H8A
Const zSETRWLS = &H8B
Const zSENDLLO = &H8C
Const zPASSCONTROL = &H8D
Const zTRIGGER = &H8E
Const zPPOLLCONFIG = &H8F
Const zPPOLLUNCONFIG = &H90
Const zPARALLELPOLL = &H91
Const zRESET = &H92
Const zFINDRQS = &H93
Const zALLSPOLL = &H94
Const zFINDLSTN = &H95
Const zTESTSYS = &H96

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   Declare storage for ib-variables to pass into DLL
'
'   NOTE:  the ones declared in the global module are
'          NOT contiguous in memory so accessing them as
'          offsets from ibsta does not work.  Hence the
'          need to copy after each ib-call.

Dim ibvars(5) As Integer

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   NI-488 DLL entry function declarations

Declare Function route_1int Lib "gpib.dll" (ByVal fncode%, ibsta%, ByVal ud%) As Integer
Declare Function route_2int Lib "gpib.dll" (ByVal fncode%, ibsta%, ByVal ud%, ByVal v%) As Integer
Declare Function route_IBFIND Lib "gpib.dll" (ibsta%, ByVal bdname$) As Integer
Declare Function route_CONFIGnPOKE Lib "gpib.dll" (ByVal fncode%, ibsta%, ByVal ud%, ByVal field%, ByVal value%) As Integer
Declare Function route_IBDEV Lib "gpib.dll" (ibsta%, ByVal bdid%, ByVal pad%, ByVal sad%, ByVal tmo%, ByVal eot%, ByVal eos%) As Integer
Declare Function route_IBLN Lib "gpib.dll" (ibsta%, ByVal ud%, ByVal pad%, ByVal sad%, listen%) As Integer
Declare Function route_farptr Lib "gpib.dll" (ByVal fncode%, ibsta%, ByVal ud%, sstr As Any, ByVal cnt&) As Integer

Declare Sub route_488_2 Lib "gpib.dll" (ByVal fncode%, ibsta%, ByVal boardID%, arg1 As Any, arg2 As Any, arg3 As Any, arg4 As Any)

Declare Function dllibask Lib "gpib.dll" (ByVal ud%, ByVal opt%, rval%, ibsta%, iberr%, ibcntl&) As Integer
Declare Function dllibevent Lib "gpib.dll" (ByVal ud%, eevent%, ibsta%, iberr%, ibcntl&) As Integer
Declare Function dlliblines Lib "gpib.dll" (ByVal ud%, lines%, ibsta%, iberr%, ibcntl&) As Integer

Sub AllSpoll (ud%, addrs%(), results%())
    Call route_488_2(zALLSPOLL, ibvars(0), ud%, addrs%(0), results%(0), ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub copy_ibvars ()
    ibsta = ibvars(0)
    iberr = ibvars(1)
    ibcnt = ibvars(2)
    ibcntl = ibvars(3)
    ibcntl = ibcntl + (ibvars(4) * &H10000)
End Sub

Sub DevClear (ud%, addr%)
    Static addr_list%(2)
    addr_list%(0) = addr%
    addr_list%(1) = NOADDR
    Call route_488_2(zDEVICECLEAR, ibvars(0), ud%, addr_list%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub DevClearList (ud%, addrs%())
    Call route_488_2(zDEVICECLEAR, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub EnableLocal (ud%, addrs%())
    Call route_488_2(zENABLELOCAL, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub EnableRemote (ud%, addrs%())
    Call route_488_2(zENABLEREMOTE, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub FindLstn (ud%, addrs%(), results%(), limit%)
    longlimit& = limit%
    Call route_488_2(zFINDLSTN, ibvars(0), ud%, addrs%(0), results%(0), ByVal longlimit&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub FindRQS (ud%, addrs%(), result%)
    Call route_488_2(zFINDRQS, ibvars(0), ud%, addrs%(0), result%, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub ibask (ud%, opt%, rval%)
    tmp% = dllibask(ud%, opt%, rval%, ibsta%, iberr%, ibcntl&)
    ibcnt% = ibcntl&
End Sub

Sub ibbna (ud%, udname$)
    tmp% = route_farptr(zIBBNA, ibvars(0), ud%, ByVal udname$, 0)
    Call copy_ibvars
End Sub

Sub ibcac (ud%, v%)
    tmp% = route_2int(zIBCAC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibclr (ud%)
    tmp% = route_1int(zIBCLR, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibcmd (ud%, buf$)
    tmp% = route_farptr(zIBCMD, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibcmda (ud%, buf$)
    tmp% = route_farptr(zIBCMDA, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibconfig (bdid%, opt%, v%)
    tmp% = route_CONFIGnPOKE(zIBCONFIG, ibvars(0), bdid%, opt%, v%)
    Call copy_ibvars
End Sub

Sub ibdev (bdid%, pad%, sad%, tmo%, eot%, eos%, ud%)
    ud% = route_IBDEV(ibvars(0), bdid%, pad%, sad%, tmo%, eot%, eos%)
    Call copy_ibvars
End Sub

Sub ibdiag (ud%, buf$)
    tmp% = route_farptr(zIBDIAG, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibdma (ud%, v%)
    tmp% = route_2int(zIBDMA, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibeos (ud%, v%)
    tmp% = route_2int(zIBEOS, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibeot (ud%, v%)
    tmp% = route_2int(zIBEOT, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibevent (ud%, eevent%)
    tmp% = dllibevent(ud%, eevent%, ibsta%, iberr%, ibcntl&)
End Sub

Sub ibfind (udname$, ud%)
    ud% = route_IBFIND(ibvars(0), udname$)
    Call copy_ibvars
End Sub

Sub ibgts (ud%, v%)
    tmp% = route_2int(zIBGTS, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibist (ud%, v%)
    tmp% = route_2int(zIBIST, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub iblines (ud%, lines%)
     tmp% = dlliblines(ud%, lines%, ibsta%, iberr%, ibcntl&)
End Sub

Sub ibln (ud%, pad%, sad%, ln%)
    tmp% = route_IBLN(ibvars(0), ud%, pad%, sad%, ln%)
    Call copy_ibvars
End Sub

Sub ibloc (ud%)
    tmp% = route_1int(zIBLOC, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibonl (ud%, v%)
    tmp% = route_2int(zIBONL, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibpad (ud%, v%)
    tmp% = route_2int(zIBPAD, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibpct (ud%)
    tmp% = route_1int(zIBPCT, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibpoke (bdid%, opt%, v%)
    tmp% = route_CONFIGnPOKE(zIBPOKE, ibvars(0), bdid%, opt%, v%)
    Call copy_ibvars
End Sub

Sub ibppc (ud%, v%)
    tmp% = route_2int(zIBPPC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibrd (ud%, buf$)
    tmp% = route_farptr(zIBRD, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibrda (ud%, buf$)
    tmp% = route_farptr(zIBRDA, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibrdf (ud%, filename$)
    tmp% = route_farptr(zIBRDF, ibvars(0), ud%, ByVal filename$, 0)
    Call copy_ibvars
End Sub

Sub ibrdi (ud%, ibuf%(), cnt&)
    tmp% = route_farptr(zIBRD, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Sub

Sub ibrdia (ud%, ibuf%(), cnt&)
    tmp% = route_farptr(zIBRDA, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Sub

Sub ibrdkey (ud%, buf$)
    tmp% = route_farptr(zIBRDKEY, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibrpp (ud%, ppr%)
    Static tmp_str As String * 2
    tmp% = route_farptr(zIBRPP, ibvars(0), ud%, ByVal tmp_str$, 0&)
    ppr% = Asc(tmp_str$)
    Call copy_ibvars
End Sub

Sub ibrsc (ud%, v%)
    tmp% = route_2int(zIBRSC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibrsp (ud%, rsp%)
    Static tmp_str As String * 2
    tmp% = route_farptr(zIBRSP, ibvars(0), ud%, ByVal tmp_str$, 0&)
    rsp% = Asc(tmp_str$)
    Call copy_ibvars
End Sub

Sub ibrsv (ud%, v%)
    tmp% = route_2int(zIBRSV, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibsad (ud%, v%)
    tmp% = route_2int(zIBSAD, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibsic (ud%)
    tmp% = route_1int(zIBSIC, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibsre (ud%, v%)
    tmp% = route_2int(zIBSRE, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibstop (ud%)
    tmp% = route_1int(zIBSTOP, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibtmo (ud%, v%)
    tmp% = route_2int(zIBTMO, ibvars(0), ud%, v%)
    Call copy_ibvars
End Sub

Sub ibtrg (ud%)
    tmp% = route_1int(zIBTRG, ibvars(0), ud%)
    Call copy_ibvars
End Sub

Sub ibwait (ud%, mask%)
    tmp% = route_2int(zIBWAIT, ibvars(0), ud, mask)
    Call copy_ibvars
End Sub

Sub ibwrt (ud%, buf$)
    tmp% = route_farptr(zIBWRT, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibwrta (ud%, buf$)
    tmp% = route_farptr(zIBWRTA, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Sub ibwrtf (ud%, filename$)
    tmp% = route_farptr(zIBWRTF, ibvars(0), ud%, ByVal filename$, 0)
    Call copy_ibvars
End Sub

Sub ibwrti (ud%, ibuf%(), cnt&)
    tmp% = route_farptr(zIBWRT, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Sub

Sub ibwrtia (ud%, ibuf%(), cnt&)
    tmp% = route_farptr(zIBWRTA, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Sub

Sub ibwrtkey (ud%, buf$)
    tmp% = route_farptr(zIBWRTKEY, ibvars(0), ud%, ByVal buf$, Len(buf$))
    Call copy_ibvars
End Sub

Function ilask (ud%, opt%, rval%)
    ilask = dllibask(ud%, opt%, rval%, ibsta%, iberr%, ibcntl&)
    ibcnt% = ibcntl&
End Function

Function ilbna (ud%, udname$) As Integer
    ilbna% = route_farptr(zIBBNA, ibvars(0), ud%, ByVal udname$, 0)
    Call copy_ibvars
End Function

Function ilcac (ud%, v%) As Integer
    ilcac% = route_2int(zIBCAC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilclr (ud%) As Integer
    ilclr% = route_1int(zIBCLR, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function ilcmd (ud%, buf$, cnt&) As Integer
    ilcmd% = route_farptr(zIBCMD, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilcmda (ud%, buf$, cnt&) As Integer
    ilcmda% = route_farptr(zIBCMDA, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilconfig (bdid%, opt%, v%) As Integer
    ilconfig% = route_CONFIGnPOKE(zIBCONFIG, ibvars(0), bdid%, opt%, v%)
    Call copy_ibvars
End Function

Function ildev (bdid%, pad%, sad%, tmo%, eot%, eos%) As Integer
    ildev% = route_IBDEV(ibvars(0), bdid%, pad%, sad%, tmo%, eot%, eos%)
    Call copy_ibvars
End Function

Function ildiag (ud%, buf$, cnt&) As Integer
    ildiag% = route_farptr(zIBDIAG, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ildma (ud%, v%) As Integer
    ildma% = route_2int(zIBDMA, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ileos (ud%, v%) As Integer
    ileos% = route_2int(zIBEOS, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ileot (ud%, v%) As Integer
    ileot% = route_2int(zIBEOT, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilevent (ud%, eevent%) As Integer
    ilevent% = dllibevent(ud%, eevent%, ibsta%, iberr%, ibcntl&)
End Function

Function ilfind (udname$) As Integer
    ilfind% = route_IBFIND(ibvars(0), udname$)
    Call copy_ibvars
End Function

Function ilgts (ud%, v%) As Integer
    ilgts% = route_2int(zIBGTS, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilist (ud%, v%) As Integer
    ilist% = route_2int(zIBIST, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function illines (ud%, lines%) As Integer
    illines% = dlliblines(ud%, lines%, ibsta%, iberr%, ibcntl&)
End Function

Function illn (ud%, pad%, sad%, ln%) As Integer
    illn% = route_IBLN(ibvars(0), ud%, pad%, sad%, ln%)
    Call copy_ibvars
End Function

Function illoc (ud%) As Integer
    illoc% = route_1int(zIBLOC, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function ilonl (ud%, v%) As Integer
    ilonl% = route_2int(zIBONL, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilpad (ud%, v%) As Integer
    ilpad% = route_2int(zIBPAD, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilpct (ud%) As Integer
    ilpct% = route_1int(zIBPCT, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function ilpoke (bdid%, opt%, v%) As Integer
    ilpoke% = route_CONFIGnPOKE(zIBPOKE, ibvars(0), bdid%, opt%, v%)
    Call copy_ibvars
End Function

Function ilppc (ud%, v%) As Integer
    ilppc% = route_2int(zIBPPC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilrd (ud%, buf$, cnt&) As Integer
    ilrd% = route_farptr(zIBRD, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilrda (ud%, buf$, cnt&) As Integer
    ilrda% = route_farptr(zIBRDA, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilrdf (ud%, filename$) As Integer
    ilrdf% = route_farptr(zIBRDF, ibvars(0), ud%, ByVal filename$, 0)
    Call copy_ibvars
End Function

Function ilrdi (ud%, ibuf%(), cnt&) As Integer
    ilrdi% = route_farptr(zIBRD, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Function

Function ilrdia (ud%, ibuf%(), cnt&) As Integer
    ilrdia% = route_farptr(zIBRDA, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Function

Function ilrdkey (ud%, buf$, cnt&) As Integer
    ilrdkey% = route_farptr(zIBRDKEY, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilrpp (ud%, ppr%) As Integer
    Static tmp_str As String * 2
    ilrpp% = route_farptr(zIBRPP, ibvars(0), ud%, ByVal tmp_str$, 0&)
    ppr% = Asc(tmp_str$)
    Call copy_ibvars
End Function

Function ilrsc (ud%, v%) As Integer
    ilrsc% = route_2int(zIBRSC, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilrsp (ud%, rsp%) As Integer
    Static tmp_str As String * 2
    ilrsp% = route_farptr(zIBRSP, ibvars(0), ud%, ByVal tmp_str$, 0&)
    rsp% = Asc(tmp_str$)
    Call copy_ibvars
End Function

Function ilrsv (ud%, v%) As Integer
    ilrsv% = route_2int(zIBRSV, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilsad (ud%, v%) As Integer
    ilsad% = route_2int(zIBSAD, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilsic (ud%) As Integer
    ilsic% = route_1int(zIBSIC, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function ilsre (ud%, v%) As Integer
    ilsre% = route_2int(zIBSRE, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function ilstop (ud%) As Integer
    ilstop% = route_1int(zIBSTOP, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function iltmo (ud%, v%) As Integer
    iltmo% = route_2int(zIBTMO, ibvars(0), ud%, v%)
    Call copy_ibvars
End Function

Function iltrg (ud%) As Integer
    iltrg% = route_1int(zIBTRG, ibvars(0), ud%)
    Call copy_ibvars
End Function

Function ilwait (ud%, mask%) As Integer
    ilwait% = route_2int(zIBWAIT, ibvars(0), ud, mask)
    Call copy_ibvars
End Function

Function ilwrt (ud%, buf$, cnt&) As Integer
    ilwrt% = route_farptr(zIBWRT, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilwrta (ud%, buf$, cnt&) As Integer
    ilwrta% = route_farptr(zIBWRTA, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Function ilwrtf (ud%, filename$) As Integer
    ilwrtf% = route_farptr(zIBWRTF, ibvars(0), ud%, ByVal filename$, 0)
    Call copy_ibvars
End Function

Function ilwrti (ud%, ibuf%(), cnt&) As Integer
    ilwrti% = route_farptr(zIBWRT, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Function

Function ilwrtia (ud%, ibuf%(), cnt&) As Integer
    ilwrtia% = route_farptr(zIBWRTA, ibvars(0), ud%, ibuf%(0), cnt&)
    Call copy_ibvars
End Function

Function ilwrtkey (ud%, buf$, cnt&) As Integer
    ilwrtkey% = route_farptr(zIBWRTKEY, ibvars(0), ud%, ByVal buf$, cnt&)
    Call copy_ibvars
End Function

Sub PassControl (ud%, addr%)
    longaddr& = addr%
    Call route_488_2(zPASSCONTROL, ibvars(0), ud%, ByVal longaddr&, ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub Ppoll (ud%, result%)
    Call route_488_2(zPARALLELPOLL, ibvars(0), ud%, result%, ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub PpollConfig (ud%, addr%, lline%, sense%)
    longaddr& = addr%
    longline& = lline%
    longsense& = sense%
    Call route_488_2(zPPOLLCONFIG, ibvars(0), ud%, ByVal longaddr&, ByVal longline&, ByVal longsense&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub PpollUnconfig (ud%, addrs%())
    Call route_488_2(zPPOLLUNCONFIG, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub RcvRespMsg (ud%, buf$, term%)
    longlen& = Len(buf$)
    longterm& = term%
    Call route_488_2(zRCVDATABYTES, ibvars(0), ud%, ByVal buf$, ByVal longlen&, ByVal longterm&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub ReadStatusByte (ud%, addr%, result%)
    Static addr_list%(2)
    addr_list%(0) = addr%
    addr_list%(1) = NOADDR
    Call route_488_2(zALLSPOLL, ibvars(0), ud%, addr_list%(0), result%, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub receive (ud%, addr%, buf$, term%)
    longaddr& = addr%
    longlen& = Len(buf$)
    longterm& = term%
    Call route_488_2(zRECEIVE, ibvars(0), ud%, ByVal longaddr&, ByVal buf$, ByVal longlen&, ByVal longterm&)
    Call copy_ibvars
End Sub

Sub ReceiveSetup (ud%, addr%)
    longaddr& = addr%
    Call route_488_2(zRCVSETUP, ibvars(0), ud%, ByVal longaddr&, ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub ResetSys (ud%, addrs%())
    Call route_488_2(zRESET, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub send (ud%, addr%, buf$, term%)
    Static addr_list%(2)
    addr_list%(0) = addr%
    addr_list%(1) = NOADDR
    longlen& = Len(buf$)
    longterm& = term%
    Call route_488_2(zSEND, ibvars(0), ud%, addr_list%(0), ByVal buf$, ByVal longlen&, ByVal longterm&)
    Call copy_ibvars
End Sub

Sub SendCmds (ud%, cmdbuf$)
    longlen& = Len(cmdbuf$)
    Call route_488_2(zSENDCMDS, ibvars(0), ud%, ByVal cmdbuf$, ByVal longlen&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub SendDataBytes (ud%, buf$, term%)
    longlen& = Len(buf$)
    longterm& = term%
    Call route_488_2(zSENDDATABYTES, ibvars(0), ud%, ByVal buf$, ByVal longlen&, ByVal longterm&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub SendIFC (ud%)
    Call route_488_2(zSENDIFC, ibvars(0), ud%, ByVal 0&, ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub SendList (ud%, addr%(), buf$, term%)
    longlen& = Len(buf$)
    longterm& = term%
    Call route_488_2(zSEND, ibvars(0), ud%, addr%(0), ByVal buf$, ByVal longlen&, ByVal longterm&)
    Call copy_ibvars
End Sub

Sub SendLLO (ud%)
    Call route_488_2(zSENDLLO, ibvars(0), ud%, ByVal 0&, ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub SendSetup (ud%, addrs%())
    Call route_488_2(zSENDSETUP, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub SetRWLS (ud%, addrs%())
    Call route_488_2(zSETRWLS, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub TestSRQ (ud%, result%)
    Call ibwait(ud%, 0)
    If ibsta% And &H1000 Then
        result% = 1
    Else
        result% = 0
    End If
End Sub

Sub TestSys (ud%, addrs%(), results%())
    Call route_488_2(zTESTSYS, ibvars(0), ud%, addrs%(0), results%(0), ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub Trigger (ud%, addr%)
    Static addr_list%(2)
    addr_list%(0) = addr%
    addr_list%(1) = NOADDR
    Call route_488_2(zTRIGGER, ibvars(0), ud%, addr_list%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub TriggerList (ud%, addrs%())
    Call route_488_2(zTRIGGER, ibvars(0), ud%, addrs%(0), ByVal 0&, ByVal 0&, ByVal 0&)
    Call copy_ibvars
End Sub

Sub WaitSRQ (ud%, result%)
    Call ibwait(ud%, &H5000)
    If ibsta% And &H1000 Then
        result% = 1
    Else
        result% = 0
    End If
End Sub

