'  VISUAL BASIC Example Program 1 -- Basic Communication

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine

   
'  Bring the digital multimeter on-line

   CALL ibdev(0, 1, 0, T10s, 1, 0, dmm%)
   IF (dmm% < 0) THEN
	CALL ReportError(dmm%, "Could not open device DMM")
   END IF

'  Set up dmm to measure VDC, autorange

   CALL ibwrt(dmm%, "VOLTS DC;AUTO")
   IF (ibsta% AND EERR) THEN
	CALL ReportError(dmm%, "Could not initialize DMM")
   END IF

'  Take 100 readings

   FOR i% = 1 TO 100
	
	' Request voltage reading from dmm

	  CALL ibwrt(dmm%, "VOLTS?")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(dmm%, "Could not trigger multimeter")
	  END IF

	' Read data from dmm

	  Reading$ = SPACE$(20)

	  CALL ibrd(dmm%, Reading$)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(dmm%, "Could not read data from multimeter")
	  END IF

	' Remove blank spaces in READING$ and assign resulting buffer to RD$.

	  rd$ = LEFT$(Reading$, IBCNT%)

          Print "Data read: ", rd$

   NEXT i%

'  Take dmm off-line

   CALL ibonl(dmm%, 0)

   END


SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (fd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(fd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

