'  VISUAL BASIC Example Program 7 -- Serial Polls with 488.2 Calls

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (errmsg$)      ' Error subroutine

   CONST RUNNING=   1             ' state1 = runnin
   CONST DONE=      2             ' state2 = done
   CONST THRESHOLD= 9             ' internally defined consistency threshold

   DIM instruments%(1 TO 4)       ' Array of primary addresses


'  Make board controller in charge

   CALL SendIFC(0)
   IF ibsta% AND EERR THEN
	CALL ReportError("Could not send Interface Clear")
   END IF

'  Initialize array of primary addresses

   instruments%(1) = 1
   instruments%(2) = 4
   instruments%(3) = 8
   instruments%(4) = NOADDR

'  Configure the strain gauges to request service when they have a
'  significant pressure reading or a mechanical failure occurs

   CALL SendList(0, instruments%(), "SRQ=HI", NLend)
   IF (ibsta% AND EERR) THEN
	CALL ReportError("Could not send SRQ=HI to devices")
   END IF

'  While more data to collect

   State% = RUNNING

   WHILE (State% = RUNNING)

      ' Wait for one or more of the strain gauges to request service

	CALL WaitSRQ(0, SRQseen%)
	IF (ibsta% AND EERR) THEN
	     CALL ReportError("Error occurred while waiting for Service Request")
	END IF
  
      ' Determine which of the strain gauges requested service

	CALL FindRQS(0, instruments%(), result%)
	IF (ibsta% AND EERR) THEN
	     CALL ReportError("Error occurred while determining who requested service")
	END IF

	buffer$ = SPACE$(10)

	IF (result% AND &H40) = &H40 THEN
             Call Receive(0, instruments%(ibcnt%), buffer$, STOPend)
	END IF

      ' Now print the type of service requested

	IF VAL(LEFT$(Reading$, 1)) = THRESHOLD THEN
	     PRINT "The syrup in gauge "; instruments%(ibcnt%); " is ready"
	ELSE
	     PRINT "Gauge "; instruments%(ibcnt); " requires service"
	END IF

      ' Call external routine to update the state of the gauges

	CALL UpdateState(State%)

   WEND

'  Take the GPIB interface board off-line

   CALL ibonl(0, 0)

END

SUB ReportError (errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$
   CALL ibonl(0, 0)
   STOP              ' Abort program

END SUB

