'  VISUAL BASIC Example Program 4 -- Service Requests

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine


'  Bring the film recorder on-line

   CALL ibdev(0, 1, 0, T10s, 1, 0, cam%)
   IF (cam% < 0) THEN CALL ReportError(cam%, "Could not open device")

'  Clear the film recorder

   CALL ibclr(cam%)
   IF (ibsta% AND EERR) THEN CALL ReportError(cam%, "Could not clear camera")

'  Advance to first frame of film

   CALL ibwrt(cam%, "FRM+")
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(cam%, "Could not write to camera")
   END IF

'  Wait for Service Request (or Timeout)

   CALL ibwait(cam%, RQS OR TIMO)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(cam%, "Error waiting for film to load")
   END IF

' Get serial poll byte -- if 0x44, film loaded OK

   CALL ibrsp(cam, spr%)
   IF (spr% <> &H44) THEN
	 CALL ReportError(cam%, "Problem loading film -- check film recorder")
   END IF

   Done% = 0

   WHILE Done% = 0

	' Perform red pass

	  CALL ibwrt(cam%, "R1")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Could not write to camera(red pass)")
	  END IF

	' Wait for Service Request

	  CALL ibwait(cam%, RQS OR TIMO)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Error occurred in red pass")
	  END IF

	' Get serial poll byte -- if 0x46, pass succeeded

	  CALL ibrsp(cam%, spr%)
	  IF (spr% <> &H46) THEN
	       CALL ReportError(cam%, "Problem with red pass")
	  END IF

	' Perform green pass

	  CALL ibwrt(cam%, "G1")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Could not write to camera(green pass)")
	  END IF

	' Wait for Service Request

	  CALL ibwait(cam%, RQS OR TIMO)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Error occurred in green pass")
	  END IF

	' Get serial poll byte -- if 0x46, pass succeeded

	  CALL ibrsp(cam%, spr%)
	  IF (spr% <> &H46) THEN
	       CALL ReportError(cam%, "Problem with green pass")
	  END IF

	' Perform blue pass

	  CALL ibwrt(cam%, "B1")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Could not write to camera(blue pass)")
	  END IF

	' Wait for Service Request
	
	  CALL ibwait(cam%, RQS OR TIMO)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Error occurred in blue pass")
	  END IF

	' Get serial poll byte -- if 0x46, pass succeeded

	  CALL ibrsp(cam%, spr%)
	  IF (spr% <> &H46) THEN
	       CALL ReportError(cam%, "Problem with blue pass")
	  END IF

	' Advance film by one frame

	  CALL ibwrt(cam%, "ADV")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, "Could not write to camera")
	  END IF

	' Wait for Service Request

	  CALL ibwait(cam%, RQS OR TIMO)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(cam%, " Frame advance failed")
	  END IF

	' Get serial poll byte -- 0x41= advance succeeded, 0x42= end of film

	  CALL ibrsp(cam%, spr%)

	  IF ((spr% <> &H41) AND (spr% <> &H42)) THEN
		CALL ReportError(cam%, "Problem with frame advance")
	  END IF

	  IF (spr% = &H42) THEN
	       done% = 1
	       PRINT "DONE"
	  END IF

   WEND

'  Take camera off-line

   CALL ibonl(cam%, 0)

   END

SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (fd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(fd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

