'  VISUAL BASIC Example Program 8 -- Parallel Polls with 488.2 Calls

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (errmsg$)     ' Error subroutine

   DIM instruments%(1 TO 4)        ' Primary addresses of mixers


'  Initialize the GPIB interface

   CALL SendIFC(0)
   IF (ibsta% AND EERR) THEN
	CALL ReportError("Could not send IFC")
   END IF

'  Initialize array of primary addresses

   instruments%(1) = 7
   instruments%(2) = 8
   instruments%(3) = 9
   instruments%(4) = NOADDR

'  Configure each of the three mixers for parallel polls.  Mixer 1 will
'  assert dataline 1, Mixer 2 dataline 2, and Mixer 3 dataline 3.  Sense
'  is set to 1, which means the mixer will assert its line if its individual
'  status bit is 1.

   CALL PPollConfig(0, instruments%(1), 1, 1)
   IF (ibsta% AND EERR) THEN
        CALL ReportError("Could not configure mixer 1 for PPoll")
   END IF

   CALL PPollConfig(0, instruments%(2), 2, 1)
   IF (ibsta% AND EERR) THEN
        CALL ReportError("Could not configure mixer 2 for PPoll")
   END IF

   CALL PPollConfig(0, instruments%(3), 3, 1)
   IF (ibsta% AND EERR) THEN
        CALL ReportError("Could not configure mixer 3 for PPoll")
   END IF

'  Loop until all three mixers have heated their alloy to the proper
'  temperature (determined via parallel poll).  While waiting for
'  mixers to finish heating, run internal routine UpdateScreen.

   Done% = 0

   WHILE Done% = 0                ' continue looping while metals heat 

      CALL UpdateScreen           ' do screen update while metals heated

      CALL PPoll(0, ppresp%)      ' get PPoll response                 

      ppresp% = ppresp% AND &HFF  ' only interested in low byte

      IF (ppresp% = &H7) THEN
	 Done% = 1                ' if all metals heated, we are finished
      END IF

   WEND

'  All mixers are now ready, so send command to turn on motors

   CALL SendList(0, instruments%(), "MIX ON;", DABend)

'  Unconfigure (disable) parallel polls

   CALL PPollUnconfig(0, instruments%())

'  Take devices off-line

   CALL ibonl(0, 0)

   END


Sub ReportError(errmsg$)

   PRINT "Error = ", iberr%; errmsg$
   CALL ibonl(0, 0)
   STOP              ' Abort program

END SUB

