'  VISUAL BASIC Example Program 9 -- Non-controller example

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine

   CONST DEFAULT = 0         ' default (cleared) state
   CONST LISTENING = 1       ' addressed as talker   
   CONST TALKING = 2         ' addressed as listener 


'  Store internal state of device

   state% = DEFAULT

'  Bring the board on-line

   CALL ibfind("gpib0", bd%)
   IF (bd% < 0) THEN
	 CALL ReportError(bd%, "Could not open gpib0")
   END IF

   CALL ibpad(bd%, 8)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(bd%, "Could not set the GPIB primary address")
   END IF

   
   DO                       ' loop forever

	'  Wait for 0 -- updates status

	   CALL ibwait(bd%, 0)
	   IF (ibsta% AND EERR) THEN
		CALL ReportError(bd%, "ibwait call failed")
	   END IF

	'  Check whether device has been talk-addressed, listen-addressed
	'  or cleared

	   IF (ibsta% AND DCAS) THEN     ' Device has been cleared

	      state% = DEFAULT           ' Reset state
	      CALL ibwait(bd%, DCAS)     ' Removes DCAS from ibsta
	      IF (ibsta% AND EERR) THEN
		 CALL ReportError(bd%, "error waiting for DCAS")
	      END IF
      
	   ELSEIF ((NOT (ibsta% AND AATN)) AND (ibsta% AND TACS)) THEN

	      state% = TALKING           ' Update state
	      reading$ = SPACE$(13)
	      CALL GetVal(reading$)      ' Call internal measurement
					 ' routine
	      CALL ibwrt(bd, reading$)   ' Send 13-byte reading to
					 ' controller
	      IF (ibsta% AND EERR) THEN
		   CALL ReportError(bd%, "Could not write to controller")
	      END IF
  
	   ELSEIF ((NOT (ibsta% AND AATN)) AND (ibsta% AND LACS)) THEN

	       state% = LISTENING        ' Update state
	       reading$ = SPACE$(100)
	       CALL ibrd(bd%, reading$)  ' We never expect strings > 100 bytes
	       IF ((ibsta% AND EERR) AND (iberr AND EABO)) THEN
		   EXIT DO
	       ELSEIF (ibsta% AND EERR) THEN
		   CALL ReportError(bd%, "Could not read from controller")
	       END IF
	       CALL ProcessVal(reading$) ' Call internal routine to
					 ' process data
	   END IF

   LOOP
 
   END

SUB ReportError (bd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (bd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(bd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

