'  VISUAL BASIC Example Program 6 -- EOS mode

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine


'  Bring the scanner on-line

   CALL ibdev(0, 1, 0, T10s, 1, 0, scanner%)
   IF (scanner% < 0) THEN
	 CALL ReportError(scanner%, "Could not find SCN_001 device")
   END IF

'  Clear scanner

   CALL ibclr(scanner%)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not clear scanner")
   END IF

'  Read and write terminate on &H0A (linefeed character)
'  XEOS and REOS are defined in QBDECL.BAS, MBDECL.BAS, and NIGLOBAL.BAS

   CALL ibeos(scanner%, XEOS OR REOS OR &H0A)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not set EOS mode")
   END IF

'  Change scanner resolution -- CR LF terminator

   CALL ibwrt(scanner%, "RES:3\r\n")
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not change scanner resolution")
   END IF

'  Read result of command

   resp$ = SPACE$(2)

   CALL ibrd(scanner%, resp$)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not read from scanner")
   END IF
   
   IF resp$ <> "OK" THEN
	 CALL ReportError(scanner%, resp$)       ' scanner not ready
   END IF

'  Begin scan

   CALL ibwrt(scanner%, "SCAN\r\n")
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not initiate scan")
   END IF

'  Read image from scanner

   image$ = SPACE$(1000)
   
   CALL ibrd(scanner%, image$)
   IF (ibsta% AND EERR) THEN
	 CALL ReportError(scanner%, "Could not read image from scanner")
   END IF

'  Take scanner off-line

   CALL ibonl(scanner%, 0)

   END

SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (fd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(fd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

