'  VISUAL BASIC Example Program 5 -- 488.2 Communication

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine

   DIM instruments%(31)                 ' Array of primary addresses
   DIM result%(30)                      ' Array of listen addresses
   DIM SHARED buffer AS STRING * 101    ' Data received from the *IDN? query


'  Initialize the GPIB interface

   CALL SendIFC(0)
   IF (ibsta% AND EERR) THEN
	CALL ReportError(0, "Could not send IFC")
   END IF

'  Create an array containing all valid GPIB primary addresses.  Address 0
'  is used by the GPIB interface board by default.   This array (INSTRUMENTS)
'  will be given to the function FindLstn to find all listeners.  The constant
'  NOADDR, defined in QBDECL.BAS, MBDECL.BAS, and NIGLOBAL.BAS signifies the
'  end of the array.

   FOR k% = 0 TO 30
	instruments%(k%) = k%
   NEXT k%
   instruments%(31) = NOADDR

'  Print message to tell user that the program is searching for all active
'  listeners.  Find all of the listeners on the bus.   Store the listen
'  addresses in the array RESULT. 

   PRINT "Finding all listeners on the bus..."
   PRINT

   CALL FindLstn(0, instruments%(), result%(), 31)
   IF (ibsta% AND EERR) THEN
	CALL ReportError(0, "Could not find listeners")
	STOP
   END IF

'  Assign the value of IBCNT to the variable NUM_LISTENERS.  The GPIB
'  interface board is detected as a listener on the bus; however, it is
'  not included in the final count of the number of listeners.   Print
'  the number of listeners found.

   num.listeners% = ibcnt% - 1
   result%(num.listeners%) = NOADDR

   PRINT "No. of instruments found = ", num.listeners%

'  Send the identification query to all addresses in the array RESULT.
'  The constant DABend, defined in QBDECL.BAS, MBDECL.BAS, and NIGLOBAL.BAS,
'  instructs the function SendList to assert the GPIB EOI line with the last
'  byte of the message.

   CALL SendList(0, result%(), "*IDN?", DABend)
   IF (ibsta% AND EERR) THEN
      CALL ReportError(0, "could not send *IDN? to devices")
   END IF

   FOR i% = 1 TO num.listeners%

	' Read the name identification response returned from each device. 
	' Store the response in the array BUFFER.  The constant STOPend,
	' defined in QBDECL.BAS, MBDECL.BAS, and NIGLOBAL.BAS instructs 
        ' the function Receive to terminate the read when END is detected. 

	  CALL Receive(0, result%(i%), buffer$, STOPend)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(0, "Could not receive from devices")
	  END IF

	' The low byte of the listen address is the primary address.
	' Assign the variable PAD% the primary address of the device.

	  pad% = result%(i%) AND &HFF

	' Print the primary address and the name identification of the
	' device.

	  PRINT "The instrument at address "; pad%; " is: ", LEFT$(Reading$, IBCNT%)
      
   NEXT i%

'  Take the board off-line

   CALL ibonl(0, 0)

END

SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$
   CALL ibonl(0, 0)
   STOP              ' Abort program

END SUB

