'  VISUAL BASIC Example Program 2 -- Clearing and Triggering

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine


'  Intake data buffer

   buffer$ = SPACE$(1024)

'  Bring the oscilloscope on-line

   CALL ibdev(0, 1, 0, T10s, 1, 0, osc%)
   IF (osc% < 0) THEN CALL ReportError(osc%, "Could not open OSC_01 device")

'  Clear oscilloscope

   CALL ibclr(osc%)
   IF (ibsta% AND EERR) THEN CALL ReportError(osc%, "Could not clear device")

'  Set up to acquire waveform on trigger

   CALL ibwrt(osc%, "WAV=TRIG")
   IF (ibsta% AND EERR) THEN
	CALL ReportError(osc%, "Could not write to device")
   END IF

'  Take 100 readings

   FOR i% = 1 TO 100

	' Trigger the scope -- will cause it to acquire data

	  CALL ibtrg(osc%)
	  IF (ibsta% AND EERR) THEN
               CALL ReportError(osc%, "Could not trigger device")
	  END IF

	' Request data from scope

	  CALL ibwrt(osc%, "CURV?")
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(osc%, "Could not write to device")
	  END IF
  
	' Read waveform

	  CALL ibrd(osc%, buffer$)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(osc%, "Could not read from device")
	  END IF

	' Call external routine to display waveform

	  CALL DispWav(buffer$)

   NEXT i%

'  Take the scope off-line

   CALL ibonl(osc%, 0)

   END

SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (fd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(fd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

