'  VISUAL BASIC Example Program 3 -- Asynchronous I/O

'  List NIGLOBAL.BAS and VBIB.BAS in the application project file.

   DECLARE FUNCTION CheckScan%()           ' User-defined external function
   DECLARE FUNCTION ScanRead%(data$)       ' User-defined external function
   DECLARE FUNCTION ScanProc%(data$)       ' User-defined external function
   DECLARE SUB ReportError (fd%, errmsg$)  ' Error subroutine


'  Intake data buffer

   DataIn$ = SPACE$(2000)

'  Open file for storing scan image

   Filenum% = FREEFILE
   OPEN "SCAN.DAT" FOR OUTPUT AS Filenum%

'  Bring the color printer on-line

   CALL ibdev(0, 1, 0, T10s, 1, 0, clp%)
   IF (clp% < 0) THEN
        CALL ReportError(clp%, "Could not open device P500C")
   END IF

'  While more data available from scanner

   WHILE (CheckScan% <> 0)
      
	' Read in data from CAT scanner, store in DataIn buffer

	  sta% = ScanRead%(DataIn$)
	  PRINT "IMAGE IN"

	' Asynchronously write the data to the color printer

	  CALL ibwrta(clp%, DataIn$)
	  IF (ibsta% AND EERR) THEN
	       CALL ReportError(clp%, "Error occurred while trying to print")
	  ELSE
	       PRINT "Printing image..."
	  END IF

	' Write data to disk file

	  WRITE #Filenum%, DataIn$

	' While previous I/O not complete

	     WHILE ((ibsta% AND CMPL) <> CMPL)

	     ' Null wait to update status word

	       CALL ibwait(clp%, 0)

	     ' Do some processing on current image

	       sta% = ScanProc%(DataIn$)

	     WEND

	PRINT "Done printing image- READY FOR NEXT IMAGE"

	WEND

'  Close data file

   CLOSE Filenum%

'  Take the color printer off-line

   CALL ibonl(clp%, 0)

   END


SUB ReportError (fd%, errmsg$) STATIC

   PRINT "Error = ", iberr%; errmsg$

   IF (fd% <> -1) THEN
      PRINT ("Cleanup: taking board off-line")
      CALL ibonl(fd%, 0)
   END IF

   STOP                 ' Abort program

END SUB

