/* C Example Program 4 -- Service Requests */

#include <stdio.h>
#include "windecl.h"

void main() {

   int   cam,        /* file descriptor for film recorder */
         done=0;     /* done flag                         */
   char  spr;        /* holds serial poll response byte   */

   if ((cam = ibdev(0, 1, 0, T10s, 1, 0)) < 0)
      report_error(cam, "Could not open device");

   /* Clear the film recorder */

   ibclr(cam);
   if (ibsta & ERR)
      report_error(cam, "Could not clear camera");

   /* Advance to first frame of film */

   ibwrt(cam, "FRM+", 4L);   
   if (ibsta & ERR) 
      report_error(cam, "Could not write to camera");

   /* Wait for Service Request (or Timeout) */

   ibwait(cam, RQS|TIMO);
   if (ibsta & ERR)
      report_error(cam, "Error waiting for film to load");

   /* Get serial poll byte -- if 0x44, film loaded OK */

   ibrsp(cam, &spr);                                                                  
   if (spr != 0x44)
      report_error(cam, "Problem loading film -- check film recorder");

   while (!done) {

      /* Perform red pass */

      ibwrt (cam, "R1", 2L);
      if (ibsta & ERR)
         report_error(cam, "Could not write to camera(red pass)");

      ibwait(cam, RQS | TIMO);    /* wait for Service Request */
      if (ibsta & ERR)
         report_error(cam, "Error occurred in red pass");

      /* Get serial poll byte -- if 0x46, pass succeeded */

      ibrsp(cam, &spr);    
      if (spr != 0x46)
         report_error(cam, "Problem with red pass");

      /* Perform green pass */

      ibwrt(cam, "G1", 2L);        
      if (ibsta & ERR)
         report_error(cam, "Could not write to camera(green pass)");

      ibwait(cam, RQS | TIMO);    /* wait for Service Request */
      if (ibsta & ERR)
         report_error(cam, "Error occurred in green pass");

      /* Get serial poll byte -- if 0x46, pass succeeded */

      ibrsp(cam, &spr);    
      if (spr != 0x46)
         report_error(cam, "Problem with green pass");

      /* Perform blue pass */

      ibwrt(cam, "B1", 2L);       
      if (ibsta & ERR)
         report_error(cam, "Could not write to camera(blue pass)");

      ibwait(cam, RQS | TIMO);    /* wait for Service Request */
      if (ibsta & ERR)
         report_error(cam, "Error occurred in blue pass");

      /* Get serial poll byte -- if 0x46, pass succeeded */

      ibrsp(cam, &spr);    
      if (spr != 0x46)
         report_error(cam, "Problem with blue pass");

      /* Advance film by one frame*/

      ibwrt(cam, "ADV", 3L);       
      if (ibsta & ERR)
         report_error(cam, "Could not write to camera");

      ibwait(cam, RQS | TIMO);    /* wait for Service Request */
      if (ibsta & ERR)
         report_error(cam, " Frame advance failed");

      /* Get serial poll byte -- 0x41= advance succeeded, 0x42= end of film */

      ibrsp(cam, &spr);            
      if ((spr != 0x41) && (spr != 0x42))
         report_error(cam, "Problem with frame advance");
      if (spr == 0x42)    {
         done = 1;
         printf("DONE\n");
      }
   }
  ibonl(cam, 0);        /* take camera off-line */
}

report_error(int fd, char *errmsg){

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);

   if (fd != -1) {
      printf("Cleanup: taking board off-line\n");
      ibonl(fd,0);
   }
   exit(1);              /* abort program */
}
