/* C Example Program 9 -- Non-controller example */

#include <stdio.h>
#include "windecl.h"

#define DEFAULT   0     /* default (cleared) state */
#define LISTENING 1     /* addressed as talker     */
#define TALKING   2     /* addressed as listener   */

void main() {

   int   bd,                     /* file descriptor for board         */
         state=DEFAULT;          /* to store internal state of device */
   char  reading[100];           /* for storing commands & data       */

   if ((bd = ibfind("gpib0")) < 0)
      report_error(bd, "Could not open gpib0");

   ibpad(bd,8);
   if (ibsta & ERR)
      report_error(bd, "Could not set the GPIB primary address");

   while (1)  {   /* loop forever */

      ibwait(bd, 0);                /* wait for 0 -- updates status */
      if (ibsta & ERR)
         report_error(bd, "ibwait call failed");

      /*
       * Check whether device has been talk-addressed, listen-addressed
       * or cleared
       */
      
      if (ibsta & DCAS) {      /*  device has been cleared */
         state = DEFAULT;           /* reset state */
         ibwait(bd, DCAS);          /* removes DCAS from ibsta*/
         if (ibsta & ERR)
            report_error (bd, "error waiting for DCAS");
      }
      else if ((!(ibsta & ATN)) && (ibsta & TACS)) {
         state = TALKING;           /* update state */
         GetVal(reading);           /* call internal measurement routine */
         ibwrt(bd, reading, 13L);   /* send 13-byte reading to controller */
         if ((ibsta & ERR) && (iberr & ENOL))
            continue;
         else if (ibsta & ERR)
            report_error(bd, "Could not write to controller");
      }
      else if ((!(ibsta & ATN)) && (ibsta & LACS)) {
         state = LISTENING;         /* update state */
         ibrd(bd, reading, 100L);   /* we never expect strings > 100 bytes */

         if ((ibsta & ERR) && (iberr & EABO))
            continue;
         else if (ibsta & ERR)
            report_error(bd, "Could not read from controller");
         ProcessVal(reading);       /* call internal routine to process data */
      }
   }    
}

report_error(int bd, char *errmsg){

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   if (bd != -1)
      ibonl (bd, 0);
   exit(1);              /* abort program */
}
