/* C Example Program 6 -- EOS mode */

#include <stdio.h>
#include "windecl.h"

void main() {

   int    scanner;        /* file descriptor for scanner */
   char   resp[3],
          image[1000];

   if ((scanner = ibdev(0, 1, 0, T10s, 1, 0)) < 0)
      report_error(scanner, "Could not find SCN_001 device");

   /* Clear scanner */

   ibclr(scanner);  
   if (ibsta & ERR)
      report_error(scanner, "Could not clear scanner");

   /* 
    * Read and write terminate on 0xA (linefeed character)
    * XEOS and REOS are defined in DECL.H 
    */

   ibeos(scanner, XEOS | REOS | 0x0A);
   if (ibsta & ERR)
      report_error(scanner, "Could not set EOS mode");

   /* Change scanner resolution -- CR LF terminator */

   ibwrt(scanner, "RES:3\r\n", 7L);       
   if (ibsta & ERR)
      report_error(scanner, "Could not change scanner resolution");

   /* Read result of command */

   ibrd(scanner, resp, 2L);
   if (ibsta & ERR)
      report_error(scanner, "Could not read from scanner");
   resp[2] = '\0';
   if (strcmp(resp, "OK") != 0)
      report_error(scanner, resp);   /* scanner not ready */

   /* Begin scan */

   ibwrt(scanner, "SCAN\r\n", 6L);
   if (ibsta & ERR)
      report_error(scanner, "Could not initiate scan");

   /* Read image from scanner */

   ibrd(scanner, image, 1000L);     
   if (ibsta & ERR)
      report_error(scanner, "Could not read image from scanner");

   /* Take scanner off-line */

   ibonl(scanner, 0);              
}

report_error(int fd, char *errmsg)
{
   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   if (fd != -1)  {
      printf("Cleanup: taking board off-line\n");
      ibonl(fd,0);
   }
   exit(1);              /* abort program */
}
