/* C Example Program 5 -- 488.2 Communication */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "windecl.h"

char            buffer[101];       /* Data received from the *IDN? query  */
int             i,                 /* Loop control variable               */ 
                num_listeners;     /* Number of listeners on GPIB         */
unsigned short  pad;               /* Primary address of listener on GPIB */
Addr4882_t      instruments[32],   /* Array of primary addresses          */
                result[31];        /* Array of listen addresses           */


void main() {

   /* Initialize the GPIB interface */

   SendIFC(0);         
   if (ibsta & ERR)
      report_error(0,"Could not send IFC");

   /*
    * Create an array containing all valid GPIB primary addresses except
    * address 0.  Address 0 is used by the GPIB interface board by default.
    * This array (INSTRUMENTS) will be given to the function FindLstn to find
    * all listeners.  The constant NOADDR, defined in DECL.H, signifies the
    * end of the array.
    */

   for (i = 1; i <= 30; i++) 
       instruments[i] = i;
    
   instruments[31] = NOADDR;    

   /*
    * Print message to tell user that the program is searching for all active
    * listeners.  Find all of the listeners on the bus.   Store the listen 
    * addresses in the array RESULT.  
    */
    
   printf("Finding all listeners on the bus...\n\n");

   FindLstn(0, instruments, result, 31);
   if (ibsta & ERR) 
      report_error(0,"Could not find listeners");

   /*
    * Assign the value of IBCNT to the variable NUM_LISTENERS.  The GPIB
    * interface board is detected as a listener on the bus; however, it is
    * not included in the final count of the number of listeners.   Print
    * the number of listeners found.
    */

    num_listeners = ibcnt - 1;
    result[num_listeners] = NOADDR;
    printf("Number of instruments found = %d\n", num_listeners);

   /*
    * Send the identification query to all addresses in the array RESULT.
    * The constant DABend, defined in DECL.H, instructs the function SendList
    * to assert the GPIB EOI line with the last byte of the message.
    */

   SendList(0, result, "*IDN?\n", 6L, DABend);
   if (ibsta & ERR)
      report_error(0,"could not send *IDN? to devices");

    for (i = 0; i <= num_listeners; i++) {

      /*
       * Read the name identification response returned from each device.  
       * Store the response in the array BUFFER.  The constant STOPend,
       * defined in DECL.H, instructs the function Receive to terminate the
       * read when END is detected.  
       */

        Receive(0, result[i], buffer, 10L, STOPend);
        if (ibsta & ERR)
           report_error(0,"Could not receive from devices");

      /*
       * The low byte of the listen address is the primary address.
       * Assign the variable PAD the primary address of the device.
       * The macro GetPAD, defined in DECL.H, returns the low byte
       * of the listen address.
       */

      pad = GetPAD(result[i]);

      /*
       * Use the null character to mark the end of the data received
       * in the array BUFFER.  Print the primary address and the name
       * identification of the device.  
       */

      buffer[ibcnt] = '\0';
      printf("The instrument at address %d is a %s\n", pad, buffer);
      
    }     /*  End of FOR loop */

   /* Take the board off-line */
   ibonl (0,0);              
}

report_error(int fd, char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);
   ibonl(0,0);
   exit(1);              /* abort program */
}
