;
;	  THIS PROGRAM IS A SKELETAL OUTLINE FOR A 128-BYTE PRIMARY
;	BOOTSTRAP FOR AUTOMATICALLY BOOTING TO UCSD PASCAL (TM).
;	  SET THE CORRECT ORIGIN FOR THIS PROGRAM FOR YOUR SYSTEM, SET
;	'MSIZE' FOR THE APPROPRIATE NUMBER OF KILOBYTES OF RAM MEMORY
;	FOR YOUR SYSTEM, SET THE APPROPRIATE PARAMETERS DESCRIBING YOUR
;	DISK ENVIRONMENT AND FINALLY WRITE A VERY LOW LEVEL DISK READ
;	ROUTINE TO ALLOW READING IN THE SECONDARY BOOTSTRAP AND YOUR
;	CBIOS OFF THE DISK AND INTO RAM.
;	  THE PROGRAM 'CPMBOOT' ON THE UCSD PASCAL DISTRIBUTION DISK WILL
;	THEN USE THIS PROGRAM AND YOUR CBIOS TO GENERATE AN AUTOMATICALLY
;	BOOTING UCSD PASCAL SYSTEM.
;
;	ADAPTED FOR Z80SIM, AUGUST 2008, UDO MUNK
;
BOOT	EQU	8200H		; SECONDARY BOOTSTRAP LOADED HERE
MSIZE	EQU	64		; MEMORY SIZE FOR ASSEMBLY
BIAS	EQU	(MSIZE*1024)-01900H
CBIOS	EQU	1500H+BIAS	; ORIGIN POINT
SECNUM	EQU	16		; SECONDARY BOOTSTRAP IS 16 SECTORS LONG
SECSEC	EQU	3		; SECONDARY BOOTSTRAP ON THIS SECTOR
BIOSNUM	EQU	8		; CBIOS IS 8 SECTORS LONG
BIOSSEC	EQU	19		; CBIOS IS ON THIS SECTOR
;
;	Z80SIM I/O PORTS
;
DRIVE	EQU	10		; FDC # OF DRIVE
TRACK	EQU	11		; FDC # OF TRACK
SECTOR	EQU	12		; FDC # OF SECTOR
FDCOP	EQU	13		; FDC COMMAND
FDCST	EQU	14		; FDC STATUS
DMAL	EQU	15		; DMA ADDRESS LOW
DMAH	EQU	16		; DMA ADDRESS HIGH
;
	ORG	0		; WHATEVER IS RIGHT FOR YOUR SYSTEM
;
PBOOT:	LD	HL,CBIOS	; CBIOS GOES HERE
	LD	SP,HL		; RESET THE STACK
	LD	D,BIOSNUM	; D - # OF SECTORS TO READ
	LD	E,BIOSSEC	; E - STARTING SECTOR
	CALL	READIT		; READ IN CBIOS
	LD	HL,BOOT		; LOAD BOOT BASE ADDRESS
	LD	D,SECNUM	; D - # OF SECTORS TO READ
	LD	E,SECSEC	; E - STARTING SECTOR
	CALL	READIT		; READ IN SECONDARY BOOTSTRAP
	LD	HL,128		; MAXIMUM NUMBER OF BYTES PER SECTOR
	PUSH	HL
	LD	HL,26		; MAXIMUM NUMBER OF SECTORS IN TABLE
	PUSH	HL
	LD	HL,0		; TRACK-TO-TRACK SKEW
	PUSH	HL
	LD	HL,1		; FIRST INTERLEAVED TRACK
	PUSH	HL
	LD	HL,1		; 1:1 INTERLEAVING
	PUSH	HL
	LD	HL,128		; BYTES PER SECTOR
	PUSH	HL
	LD	HL,26		; SECTORS PER TRACK
	PUSH	HL
	LD	HL,77		; TRACKS PER DISK
	PUSH	HL
	LD	HL,CBIOS-2	; TOP OF MEMORY (MUST BE WORD BOUNDARY)
	PUSH	HL
	LD	HL,0100H	; BOTTOM OF MEMORY
	PUSH	HL
	LD	DE,CBIOS+3	; START OF THE SBIOS (JMP WBOOT)
	PUSH	DE
	PUSH	HL		; STARTING ADDRESS OF INTERPRETER
	JP	BOOT		; ENTER SECONDARY BOOTSTRAP
;
;	  READIT MUST READ THE NUMBER OF SECTORS SPECIFIED IN THE D
;	REG, STARTING AT THE SECTOR SPECIFIED IN THE E REG, INTO THE
;	MEMORY LOCATION SPECIFIED IN THE HL PAIR.
;
READIT:	
;
;  PUT YOUR CODE IN HERE
;
	XOR	A		; SELECT DRIVE 0
	OUT	(DRIVE),A
	OUT	(TRACK),A	; SELECT TRACK 0
L1:
	LD	A,E		; SELECT SECTOR
	OUT	(SECTOR),A
	LD	A,L		; SET DMA ADDRESS LOW
	OUT	(DMAL),A
	LD	A,H		; SET DMA ADDRESS HIGH
	OUT	(DMAH),A
	XOR	A		; READ SECTOR
	OUT	(FDCOP),A
	IN	A,(FDCST)	; GET STATUS OF FDC
	OR	A		; READ SUCCESSFULL?
	JP	Z,L2		; YES, CONTINUE
	DI			; FAILURE, HALT CPU
	HALT
L2:
	DEC	D		; SECTORS = SECTORS - 1
	RET	Z		; RETURN IF ALL SECTORS LOADED
	INC	E		; NEXT SECTOR TO READ
	LD	BC,128		; 128 BYTES PER SECTOR
	ADD	HL,BC		; DMA ADDRESS + 128
	JP	L1		; GO READ NEXT
;
	END	
