/* rcsid[] = "$Header: acia.h,v 800.0 85/08/06 14:05:35 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */

/*
 * Synertek Asyncronous Communication Interface Adapter SY6551
 *
 *	Copyright 1981 UniSoft Corporation
 */


struct acia_device {
	unsigned char	ac_0;		/* fill */
	unsigned char	ac_data;
	unsigned char	ac_1;
	unsigned char	ac_stat;
#define ac_reset ac_stat
	unsigned char	ac_2;
	unsigned char	ac_cmd;
	unsigned char	ac_3;
	unsigned char	ac_ctrl;
	unsigned char	ac_4[24];
};

	/* status register bits */
#define S_PE	0x01	/* parity error */
#define S_FE	0x02	/* framing error */
#define S_OV	0x04	/* overrun error */
#define S_RRDY	0x08	/* data is available */
#define S_XEMP	0x10	/* transmitter is empty */
#define S_NDCD	0x20	/* negative data carrier detect */
#define S_NDSR	0x40	/* negative data set ready */
#define S_IRQ	0x80	/* interrupt */

	/* control register bits */
#define X_BAUD	0x0f	/* baudrate mask */
#define X_BEXT	0x00
#define X_B50	0x01
#define X_B75	0x02
#define X_B110	0x03
#define X_B134	0x04
#define X_B150	0x05
#define X_B300	0x06
#define X_B600	0x07
#define X_B1200	0x08
#define X_B1800	0x09
#define X_B2400	0x0a
#define X_B3600	0x0b
#define X_B4800	0x0c
#define X_B7200	0x0d
#define X_B9600	0x0e
#define X_B19200 0x0f
#define X_RCLK	0x10	/* receive clock, 0=extern 1=baudrate generator */
#define X_LEN	0x60	/* character length */
#define X_LEN5	0x60
#define X_LEN6	0x40
#define X_LEN7	0x20
#define X_LEN8	0x00
#define X_STOP	0x80	/* stop bits, 0=1 1=2 or 1 1/2 */
#define X_STOP1	0x00
#define X_STOP2	0x80

	/* command register bits */
#define C_DTR	0x01	/* data terminal ready */
#define C_RIND	0x02	/* receive interrupt disable */
#define C_XIN	0x0c	/* transmit interrupt mask */
#define C_XIN0	0x00	/* xmit intr off, RTS off */
#define C_XIN1	0x04	/* xmit intr on, RTS on */
#define C_XIN2	0x08	/* xmit intr off, RTS on */
#define C_XIN3	0x0c	/* xmit intr off, RTS on, send break */
#define C_ECHO	0x10	/* hardware echo */
#define C_PENBL	0x20	/* parity enable */
#define C_PMASK	0xe0	/* parity mask */
#define C_PODD	0x00	/* odd parity */
#define C_PEVEN	0x40	/* even parity */
#define C_PMARK	0x80	/* mark parity, no checking */
#define C_PSPC	0xc0	/* space parity, no checking */
