/* static char rcsid[] = "$Header: tables.c,v 1.4 85/07/03 09:45:18 root Exp $" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

#include <sys/types.h>
#include "erm.h"

int dummy();
int questioncmd();
int dispmem();
int dispbyte(), displong(), dispshort();
int modbyte(), modlong(), modshort();
int dispregs(), modregs();
int disass(), backtrace();
int gotocmd(), go_till();
int setbpt(), clrbpt();
int chgiradix(), chgoradix();
int showoffset();	/* Show offset from closest symbol */
#ifdef TRACE
int trace_next();
int trace_over();
#endif
int trace_cmd();

struct commtable commtable[] = {
	'b', 'r', setbpt,	ECM_ADDR,	"Set breakpoint",
	'b', 'c', clrbpt,	ECM_ADDR,	"Clear breakpoint",
	'b', 't', backtrace,	0,		"Stack Back Trace",
	'c', 'i', chgiradix,	ECM_ADDR,	"Change Input Radix",
	'c', 'o', chgoradix,	ECM_ADDR,	"Change Output Radix",
	'd', 'b', dispbyte,	ECM_ADDR,	"Display memory in bytes",
	'd', 'i', disass,	ECM_ADDR,	"Disassemble",
	'd', 'l', displong,	ECM_ADDR,	"Display memory in longs",
	'd', 'm', dispmem,	ECM_ADDR,	"Display block of 16 bytes",
	'd', 'r', dispregs,	0,		"Display registers",
	'd', 's', dispshort,	ECM_ADDR,	"Display memory in words",
	'g', 'o', gotocmd,	ECM_ADDR,	"Start executing code",
	'g', 't', go_till,	ECM_ADDR,	"Execute code till addr",
	'm', 'b', modbyte,	ECM_ADDR,	"Modify memory in bytes",
	'm', 'l', modlong,	ECM_ADDR,	"Modify memory in longs",
	'm', 'r', modregs,	0,		"Modify saved registers",
	'm', 's', modshort,	ECM_ADDR,	"Modify memory in words",
	's', 'h', showoffset,	0,		"Show offset from symbols",
#ifdef TRACE
	't', 'n', trace_next,	0,
	't', 'o', trace_over,	ECM_ADDR,
#endif
	't', 'r', trace_cmd,	ECM_ADDR,	"Trace 'value' instructions",
	'?', ' ', questioncmd,	0,		"menu",
	0, 0,     dummy,	0,		0
};
