/* rcsid[]="$Header: map.h,v 820.1 86/12/04 19:48:57 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	map.h	6.1	83/07/29	*/

#ifndef	MAP_ALREADY_DEFINED
#define	MAP_ALREADY_DEFINED

/*
 * Resource Allocation Maps.
 *
 * Associated routines manage sub-allocation of an address space using
 * an array of segment descriptors.  The first element of this array
 * is a map structure, describing the arrays extent and the name
 * of the controlled object.  Each additional structure represents
 * a free segment of the address space.
 *
 * A call to rminit initializes a resource map and may also be used
 * to free some address space for the map.  Subsequent calls to rmalloc
 * and rmfree allocate and free space in the resource map.  If the resource
 * map becomes too fragmented to be described in the available space,
 * then some of the resource is discarded.  This may lead to critical
 * shortages, but is better than not checking (as the previous versions
 * of these routines did) or giving up and calling panic().  The routines
 * could use linked lists and call a memory allocator when they run
 * out of space, but that would not solve the out of space problem when
 * called at interrupt time.
 *
 * N.B.: The address 0 in the resource address space is not available
 * as it is used internally by the resource map routines.
 */
struct map {
	struct	mapent *m_limit;	/* address of last slot in map */
	char	*m_name;		/* name of resource */
/* we use m_name when the map overflows, in warning messages */
};
struct mapent
{
	int	m_size;		/* size of this segment of the map */
	int	m_addr;		/* resource-space addr of start of segment */
};

#ifdef KERNEL
struct	map *swapmap;
int	nswapmap;
struct	map *argmap;
#define	ARGMAPSIZE	16
struct	map *kernelmap;
struct	map *mbmap;
#endif

#ifdef s32

#ifndef V_SKERNEL
#ifdef KERNEL
#include "../machine/cpu.h"
#else KERNEL
#include <machine/cpu.h>
#endif KERNEL
#endif V_SKERNEL

#define ENDDSKPG 0x100		/* RIMFIRE only accesses first Megabyte */

/*
 * Defines for the segment/page maps
 */

#define PAGES_PER_SEG	16		/* number of pages per segment */
#define PAGE_TO_SEG_SHIFT	4	/* convert pages <-> segments */
#define MYCTXT		(-2)
#define ALLCTXT		(-1)		/* special all contexts context */
#define SYSCTXT		0		/* system context */
#define NCONTEXTS	16		/* number of contexts */

/* Special segment table entry definitions */
#define SEG_FREE	0		/* segment is unused */
#define SEG_RESERVED	1		/* segment is invalid but reserved */
#define SEG_PAGE	0x00FF		/* mask for page field */
#define SEG_ACCMODE	0x0F00		/* mask for access mode */

/* Access modes */
#define SEG_ASYS	(V_SKERNEL)
#define SEG_AUR		(V_SUSER|V_SREAD|V_SEXEC)
#define SEG_AURW	(V_SUSER|V_SREAD|V_SEXEC|V_SWRITE)

/* Arguments to expand */
#define DATASEG		1		/* expand data segment */
#define STACKSEG	2		/* expand stack segment */

/* Arguments to alloc routines */
#define CLEAR	1			/* whether to zero allocated memory */
#define NOCLEAR	0			/* or to leave it intact. */
#define CONTIG	1			/* whether memory must be contiguous */
#define DISCONTIG 0			/* or doesn't have to be. */

#endif s32
#endif	MAP_ALREADY_DEFINED
