/* rcsid[]="$Header: reentrant.h,v 820.1 86/12/04 19:53:54 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/* ====================REENTRANT FUNCTION CALLS ON THE 68000==============

Author:         V.R.Pratt
Date:           Sept. 7, 1980.

This package permits the use of the expression
        reentrant(fun)
in place of the usual way to begin a function definition, namely
        fun()

Invoking reentrant(fun) generates a selfcontained function named fun which
pushes d0,d1,a0,a1 on the stack, calls _fun, then pops a1,a0,d1,d0 back off the
stack and does a rte (return from exception).  

Example usage:

reentrant(KbdServ)
{return(ACIA1Data&0177);}

*/

#define REENTRANT

extern chksoftclk();
extern struct vmmeter cnt;

#define reentrant(fun) reentrant_(fun,_/**/fun)

#define reentrant_(fun,_fun)\
asm("   .text ");\
asm("   .globl  fun");\
asm("fun:");\
asm("   moveml  #/c0c0,sp@-");\
asm("   jsr     _fun");\
asm("   moveml  sp@+,#/0303");\
asm("   addql   #1,cnt+12");       /* ++cnt.v_intr */   \
asm("   jmp     chksoftclk");\
int fun();\
_fun()
