/* rcsid[]="$Header: mem.h,v 820.1 86/12/04 19:53:42 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984, 1985			*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incorporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/*	mem.h	4.12	85/08/26	*/

#ifndef	BOARDMAP_ALREADY_DEFINED
#define	BOARDMAP_ALREADY_DEFINED

/*
 * Memory special file
 *
 * Minor device map:
 *		0	/dev/mem 	Physical memory device
 *		1	/dev/kmem	Kernel memory device
 *		2	/dev/null	Data sink
 *		4	/dev/iospace	mbio space for diagnostics
#ifndef	WHITE
 *		3	/dev/lasar	LASAR validation device
 *		16	/dev/realchip0	Realchip device #0
 *		17	/dev/realchip1	Realchip device #1
 *		18	/dev/realchip2	Realchip device #2
 *		19	/dev/realchip3	Realchip device #3
 *
 *		20	/dev/ffp	SKY FFP		-- in multibus i/o space
 *		21	/dev/colorctl	Color control
 *		22	/dev/colormem	Color memory
 *		23	/dev/realfast0	Realfast device #0
 *
 *		24	/dev/zoid	RealDraw Board #0
 *		25	/dev/gab0	Generalized Accellerator Board #0
 *		26	/dev/gab1	Generalized Accellerator Board #1
 *		27	/dev/gab2	Generalized Accellerator Board #2
 *		28	/dev/gab3	Generalized Accellerator Board #3
#endif	WHITE
 */

#include "../h/types.h"
#include "../machine/param.h"	/* MBIO_SIZE	*/
#include "../machine/cpu.h"	/* MBIO_VA	*/

#define	MEM_RAMDISK	22
/*
 * Enunciate the physical parameters
 * for the memory mapped h/w
 * that Valid supports.
 */
#ifndef WHITE
#define LASAR_HWADDR	0x17FFE
#define LASARADDR	((char *)LASAR_HWADDR)
#define LASARCONST	0x29C5
#define	LASAR_SIZE	0x0010000
#endif	WHITE

/*
 * Memory space taken up
 * by the various pieces of Valid's h/w
 */
#define	EC_SIZE		0x0002000	/* 3COM: Ethernet controller        */
#define	RC_SIZE		0x0020000	/* RealChip			    */
#define	RF_SIZE		0x0010000	/* RealFast		      	    */
#define	VGB_SIZE	0x0010000	/* VGB: Video Graphics Board	    */
#define	CCB_SIZE	0x0010000	/* CCB: Color Ctlr Board	    */
/* #define	CRB_SIZE	0x0100000	 CRB: Color RAM  Board    */
#define	CRB_SIZE	0x0280000	/* Try 2.5Mb for ramdisk  	    */
#define	PIB_SIZE	0x0010000	/* PIB: Periph. Interchange Board   */
#define	BAB_SIZE	0x0010000	/* BAB				    */
#define	CGB_SIZE	0x0040000	/* CGB: Color GRAPHICS Board	    */
#define	SKY_SIZE	0x0001000	/* SKY FFP			    */
#define	ZOID_SIZE	0x0040000	/* ZOID				    */
#define	GAB_SIZE	0x0020000	/* GAB: Generic Accellerator Board  */

/*
 * Hardware physical addresses
 */
#define	EC0PADDR	0x0380000	/* 3COM ec0	*/
#define	EC1PADDR	0x0382000	/* 3COM ec1	*/
#define	EC2PADDR	0x0384000	/* 3COM ec2	*/
#define	EC3PADDR	0x0386000	/* 3COM ec3	*/
#define	EC4PADDR	0x0388000	/* 3COM ec4	*/
#define	EC5PADDR	0x038A000	/* 3COM ec5	*/
#define	EC6PADDR	0x038C000	/* 3COM ec6	*/
#define	EC7PADDR	0x038E000	/* 3COM ec7	*/
#define	CCBPADDR	0x0390000	/* ColorCtl	*/
#define	VGB1PADDR	0x03A0000	/* VGB1		*/
#define	VGB2PADDR	0x03B0000	/* VGB2		*/
#define	VGB3PADDR	0x03C0000	/* VGB3		*/
#define	PIBPADDR	0x03D0000	/* PIB		*/
#define	BABPADDR	0x03E0000	/* BAB		*/
#define	VGB0PADDR	0x03F0000	/* VGB0		*/


#ifdef	HIGHBOARDS
/* #define	CRBPADDR	0x0800000	 ColorMem	*/
#define	CRBPADDR	0x0D80000	/* Try 2.5Mb for ramdisk	*/

#define	RC2PADDR	0x0DC0000	/* RealChip0	*/
#define	RC3PADDR	0x0DE0000	/* RealChip0	*/

#define	CGB0PADDR	0x0E00000	/* CGB0		*/
#define	CGB1PADDR	0x0E40000	/* CGB1		*/

#define	ZOIDPADDR	0x0E40000	/* ZoidBoard	*/
#define	CGB2PADDR	0x0E80000	/* CGB2		*/

#define	GAB0PADDR	0x0E80000	/* GAB0		*/
#define	GAB1PADDR	0x0EA0000	/* GAB1		*/

#define	GAB2PADDR	0x0EC0000	/* GAB2		*/
#define	CGB3PADDR	0x0EC0000	/* CGB3		*/

#define	GAB3PADDR	0x0EE0000	/* GAB3		*/


#define	RC0PADDR	0x0F00000	/* RealChip0	*/
#define	RC1PADDR	0x0F20000	/* RealChip0	*/

#define	RFPADDR		0x0FD0000	/* RealFast	*/

#define	SKYPADDR	0x1000		/* SKY FFP (i/o)*/
#endif	HIGHBOARDS

/*
 * The entries in the 'boardmap' array
 * are in increasing minor(dev) order.
 */
struct boardmap_t {
	u_long	paddr;		/* Physical address to be mapped	      */
	u_long	size;		/* Size to be mapped			      */
	u_long	offset;		/* Offset from paddr to test for board present*/
	u_short	mask;		/* Mask to test if board is present	      */
	u_short	value;		/* Value to test if board is present	      */
	char	*name;		/* Name by which device is known	      */

	u_char	number;		/* Entry # within this table:  minor(dev)     */

	u_char	flags;		/* Flags: used ONLY @ startup1()	      */
#define	BMF_BOTCHED	0x00	/* Should not occur!			      */
#define	BMF_IGNORE	0x01	/* No need to do ANYTHING with the entry      */
#define	BMF_DONTMAP_ATSTARTUP 0x02 /* Pages should NOT be mapped @ startup1() */

#ifdef	M68020
#define	BMF_CACHED	0x04	/* Pages SHOULD     be 68020-cached	      */
#define	BMF_NONCACHED	0x08	/* Pages should NOT be 68020-cached	      */

#else	M68020
#define	BMF_CACHED	BMF_IGNORE
#define	BMF_NONCACHED	BMF_IGNORE
#endif	M68020

#define	BMF_IOSPACE	0x10	/* Pages are in multibus i/o space	      */

	u_char	nonCached;	/* Results: 1 ==> addr space WASN'T cached    */
	u_char	isopen;		/* Set if device is open		      */
}


 boardmap[]
#ifdef	MemDotCSource
	= {
  /*
   * paddr    size	offset	mask	value	    name	   #  F C isopen
   * -----    ----	------	----	-----	    ----	   -  - - ------
   */
#define	MEM_MINOR						   0
  {0,		0,	0,	0,	0,	    "mem",	   0,
							BMF_IGNORE, 0, 0},

#define	KMEM_MINOR						   1
  {0,		0,	0,	0,	0,	    "kmem",	   1,
							BMF_IGNORE, 0, 0},

#define	NULL_MINOR						   2
  {0,		0,	0,	0,	0,	    "null",	   2,
							BMF_IGNORE, 0, 0},

#ifndef WHITE
#define	LASAR_MINOR						    3
  {LASAR_HWADDR, LASAR_SIZE,0x000,	0xFFFF,	LASARCONST, "LASAR",3,
							BMF_DONTMAP_ATSTARTUP |
							BMF_CACHED, 0, 0},
#else	WHITE
  {0,		0,		0,	0,	0,	    "undef3",	   3,
							BMF_IGNORE, 0, 0},
#endif	WHITE

  {MBIO_VA,	MBIO_SIZE,	0,	0,	0,	    "iospace",	   4,
							BMF_IGNORE, 0, 0},

  /*
   * Pad out to minor(dev)==16
   * to support the current rituals.
   */
  {0,		0,	0,	0,	0,	    "undef5",	   5,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef6",	   6,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef7",	   7,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef8",	   8,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef9",	   9,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef10",	  10,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef11",	  11,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef12",	  12,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef13",	  13,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef14",	  14,
							BMF_IGNORE, 0, 0},
  {0,		0,	0,	0,	0,	    "undef15",	  15,
							BMF_IGNORE, 0, 0}

#ifndef WHITE
			,
/*
 * Valid's memory mapped h/w
 * starts here at minor(dev)==16.
 */
#define BOARD_BASE						  16
#ifdef	HIGHBOARDS
  /*
   * The RealChip must be NONcached because accesses
   * can come from within the RealChip,
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   */
  {RC0PADDR, RC_SIZE,	0x000,	0x00FF,	0x0080,	    "RealChip0",  16,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  {RC1PADDR, RC_SIZE,	0x000,	0x00FF,	0x0080,	    "RealChip1",  17,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  {RC2PADDR, RC_SIZE,	0x000,	0x00FF,	0x0080,	    "RealChip2",  18,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  {RC3PADDR, RC_SIZE,	0x000,	0x00FF,	0x0080,	    "RealChip3",  19,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

#define	SKY_BOARDNUM						  20
  {SKYPADDR,SKY_SIZE,	0x282,	0x4000,	0x4000,	    "SKY FFP",    20,
							BMF_IOSPACE	      |
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

  /*
   * The CCB must be NONcached because accesses
   * can come from within the CCB
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   */
  {CCBPADDR, CCB_SIZE,	0x000,	0x00C0,	0x0040,	    "CCB:colorctl",   21,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  /*
   * The CRB can be cached because accesses
   * are always via the Multibus, thereby
   * updating the M68020 onboard cache.
   */
  {CRBPADDR, CRB_SIZE,	0x000,	0x0000,	0x0000,	    "CRB:colormem",   22,
							BMF_DONTMAP_ATSTARTUP |
							BMF_CACHED, 0, 0},

  {RFPADDR,  RF_SIZE,	0x030,	0x0000,	0x0000,	    "RealFast",   23,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  /*
   * The ZoidBoard must be NONcached because accesses
   * can come from within the ZoidBoard
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   *
   * We note that the ZoidBoard is an historical artifact
   * and is no longer used as a 'product',
   * having been supplanted by the GAB-s.
   */
  {ZOIDPADDR,ZOID_SIZE,	0x000,	0x0000,	0x0000,	    "zoid",       24,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},
  /*
   * The GAB-s must be NONcached because accesses
   * can come from within the GAB
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   */

  {GAB0PADDR,GAB_SIZE,	0x000,	0x0000,	0x0000,	    "gab0",       25,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

  {GAB1PADDR,GAB_SIZE,	0x000,	0x0000,	0x0000,	    "gab1",       26,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

  {GAB2PADDR,GAB_SIZE,	0x000,	0x0000,	0x0000,	    "gab2",       27,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

  {GAB3PADDR,GAB_SIZE,	0x000,	0x0000,	0x0000,	    "gab3",       28,
							BMF_DONTMAP_ATSTARTUP |
							BMF_NONCACHED, 0, 0},

#else	! HIGHBOARDS
  {0,		0,		0,	0,	0,	    "undef16",	   16,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef17",	   17,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef18",	   18,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef19",	   19,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef20",	   20,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef21",	   21,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef22",	   22,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef23",	   23,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef24",	   24,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef25",	   25,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef26",	   26,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef27",	   27,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef28",	   28,
							BMF_IGNORE, 0, 0},
#endif	! HIGHBOARDS
  /*
   * Pad out to minor(dev)==32
   * for future use.
   */
  {0,		0,	0,	0,	0,	    "undef@29",	  29,
							BMF_IGNORE, 0, 0},

  {0,		0,	0,	0,	0,	    "undef@30",	  30,
							BMF_IGNORE, 0, 0},

  {0,		0,	0,	0,	0,	    "undef@31",	  31,
							BMF_IGNORE, 0, 0},

  /*
   * Valid's ancient h/w.
   * There is no minor(dev) associated
   * with the following entries.
   *
   * VG's could be cached even though the onboard 8086
   * alters the onboard RAM, because nobody at all,
   * (except perhaps a Test Engineering program)
   * ever looks at the VGB's resources through the Multibus.
   */
  {VGB0PADDR, VGB_SIZE,	0x000,	0x0000,	0x0000,	    "VGB0",	32,
							BMF_IGNORE, 0, 0},
  {VGB1PADDR, VGB_SIZE,	0x000,	0x0000,	0x0000,	    "VGB1",	33,
							BMF_IGNORE, 0, 0},
  {VGB2PADDR, VGB_SIZE,	0x000,	0x0000,	0x0000,	    "VGB2",	34,
							BMF_IGNORE, 0, 0},
  {VGB3PADDR, VGB_SIZE,	0x000,	0x0000,	0x0000,	    "VGB3",	35,
							BMF_IGNORE, 0, 0},


  {PIBPADDR,  PIB_SIZE,	0x000,	0x0000,	0x0000,	    "PIB",	36,
							BMF_IGNORE, 0, 0},

  {BABPADDR,  BAB_SIZE,	0x000,	0x0000,	0x0000,	    "BAB",	37,
							BMF_IGNORE, 0, 0},


#ifdef	HIGHBOARDS
  /*
   * The CGB-s must be NONcached because accesses
   * can come from within the CGB,
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   */
  {CGB0PADDR, CGB_SIZE,	0x000,	0x0000,	0x0000,	    "CGB0",	38,
							BMF_IGNORE, 0, 0},
  {CGB1PADDR, CGB_SIZE,	0x000,	0x0000,	0x0000,	    "CGB1",	39,
							BMF_IGNORE, 0, 0},
  {CGB2PADDR, CGB_SIZE,	0x000,	0x0000,	0x0000,	    "CGB2",	40,
							BMF_IGNORE, 0, 0},
  {CGB3PADDR, CGB_SIZE,	0x000,	0x0000,	0x0000,	    "CGB3",	41,
							BMF_IGNORE, 0, 0},
#else	HIGHBOARDS
  {0,		0,		0,	0,	0,	    "undef38",	   38,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef39",	   39,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef40",	   40,
							BMF_IGNORE, 0, 0},
  {0,		0,		0,	0,	0,	    "undef41",	   41,
							BMF_IGNORE, 0, 0},
#endif	HIGHBOARDS


  /*
   * The EC-s must be NONcached because accesses
   * can come from within the 3Com EC-board,
   * altering its externally visible resources,
   * thereby conflicting with the M68020 onboard cache.
   */
  {EC0PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC0",	42,
							BMF_NONCACHED, 0, 0},
  {EC1PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC1",	43,
							BMF_NONCACHED, 0, 0},
  {EC2PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC2",	44,
							BMF_NONCACHED, 0, 0},
  {EC3PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC3",	45,
							BMF_NONCACHED, 0, 0},
  {EC4PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC4",	46,
							BMF_NONCACHED, 0, 0},
  {EC5PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC5",	47,
							BMF_NONCACHED, 0, 0},
  {EC6PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC6",	48,
							BMF_NONCACHED, 0, 0},
  {EC7PADDR, EC_SIZE,	0x000,	0x0000,	0x0000,	    "EC7",	49,
							BMF_NONCACHED, 0, 0}
#endif	WHITE
};

int	board_count = (sizeof(boardmap) / sizeof(struct boardmap_t));

#else	MemDotCSource

	;		/* Complete the declaration of 'boardmap[]' */
int	board_count;

#define	SKY_BOARDNUM	  20	/* minor(/dev/fpp): Note the duplicate above */

#endif	MemDotCSource


/*
 * Check to see if minor number corresponds
 * to that for the SKY FFP
 */
#define issky(n)	((n == SKY_BOARDNUM) ? 1 : 0)

#define BOARD_COUNT	board_count
#define BOARD_TOP	BOARD_COUNT	/* Firedoor */

#define isboard(m)	((BOARD_BASE <= (m)) && ((m) < BOARD_TOP))

#else	BOARDMAP_ALREADY_DEFINED
	;		/* Complete the declaration of 'boardmap[]' */
#endif	BOARDMAP_ALREADY_DEFINED
