/* rcsid[]="$Header: proc.h,v 820.1 86/12/04 19:49:05 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	proc.h	6.1	83/07/29	*/

/*
 * One structure allocated per active
 * process. It contains all data needed
 * about the process while the
 * process may be swapped out.
 * Other per process data (user.h)
 * is swapped with the process.
 */

#ifdef	KERNEL
#include "../h/time.h"
#include "../s32/context.h"
#else	KERNEL
#include <sys/time.h>
#include <s32/context.h>
#endif	KERNEL

struct	proc {
	struct	proc *p_link;	/* linked list of running processes */
	struct	proc *p_rlink;
	struct	pte *p_addr;	/* u-area kernel map address */
	char	p_usrpri;	/* user-priority based on p_cpu and p_nice */
	char	p_pri;		/* priority, negative is high */
	char	p_cpu;		/* cpu usage for scheduling */
	char	p_stat;
	char	p_time;		/* resident time for scheduling */
	char	p_nice;		/* nice for cpu usage */
	char	p_slptime;	/* time since last block */
	char	p_cursig;
	int	p_sig;		/* signals pending to this process */
	int	p_sigmask;	/* current signal mask */
	int	p_sigignore;	/* signals being ignored */
	int	p_sigcatch;	/* signals being caught by user */
	int	p_flag;
	short	p_uid;		/* user id, used to direct tty signals */
	short	p_pgrp;		/* name of process group leader */
	short	p_pid;		/* unique process id */
	short	p_ppid;		/* process id of parent */
	u_short	p_xstat;	/* Exit status for wait */
	struct	rusage *p_ru;	/* mbuf holding exit information */
	short	p_poip;		/* page outs in progress */
	short	p_szpt;		/* copy of page table size */
	size_t	p_tsize;	/* size of text (clicks) */
#ifdef s32
				/* p_tsize is rounded up to represent a whole
				   number of segments (x_size is the actual
				   number of clicks in the text segment) */
#endif s32
	size_t	p_dsize;	/* size of data space (clicks) */
	size_t	p_ssize;	/* copy of stack size (clicks) */
	size_t 	p_rssize; 	/* current resident set size in clicks */
	size_t	p_maxrss;	/* copy of u.u_limit[MAXRSS] */
	size_t	p_swrss;	/* resident set size before last swap */
	swblk_t	p_swaddr;	/* disk address of u area when swapped */
	caddr_t p_wchan;	/* event process is awaiting */
#ifdef	s32	/* WCHAN_CALLER */
	caddr_t p_wchanCaller;	/* Return addr to caller invoking sleep() */
#endif	s32	/* WCHAN_CALLER */
	struct	text *p_textp;	/* pointer to text structure */
	struct	pte *p_p0br;	/* page table base P0BR */
	struct	proc *p_xlink;	/* linked list of procs sharing same text */
	short	p_cpticks;	/* ticks of cpu time */
#ifdef s32	/* USE_FIXED_POINT */
	int	p_pctcpu;	/* %cpu for this process during p_time */
#else s32	/* USE_FIXED_POINT */
	float	p_pctcpu;	/* %cpu for this process during p_time */
#endif s32	/* USE_FIXED_POINT */
	short	p_ndx;		/* proc index for memall (because of vfork) */
	short	p_idhash;	/* hashed based on p_pid for kill+exit+... */
	struct	proc *p_pptr;	/* pointer to process structure of parent */
	struct	proc *p_cptr;	/* pointer to youngest living child */
	struct	proc *p_osptr;	/* pointer to older sibling processes */
	struct	proc *p_ysptr;	/* pointer to younger siblings */
	struct	itimerval p_realtimer;
	struct	quota *p_quota;	/* quotas for this process */

#ifdef s32
#ifdef	VALID_RPC
	caddr_t p_rpcresults;	/* Results from RPC call */
	u_short	p_rpcXXX;
	u_char	p_rpcflags;	/* Flags used with RPC */
	u_char	p_rpcerror;	/* Error from RPC call */
#endif	VALID_RPC

#ifndef	M68020_REV_B
	/*
	 *
	 * Note - If you change the ordering in the dlist structure, in
	 *	  machine/context.h, you had better change it here too ...
	 *	  or YOU'LL BE SORRY!!!
	 * 
	 */
	struct dlist *p_lru;	/* least recently used link (context list) */
	struct dlist *p_mru;	/* most recently used link (context list) */
	struct ctxt *p_ctxt;	/* current context */
#else	M68020_REV_B
	ctxt_dlist_t	p_dlist; /* Used in sureg(); binds procs and ctxts */

#define	p_lru		p_dlist.d_lru
#define	p_mru		p_dlist.d_mru
#define	p_ctxt		p_dlist.D_ctxt		/* Shorthand:  (p)->p_ctxt */
#define	p_procp		p_dlist.D_procp
#endif	M68020_REV_B

	u_short	p_smaps;	/* Head of list of segment maps owned */
	u_short	p_needmap;	/* How many more segment maps needed  */

	u_short	p_mmuStatRegBits;/* Status reg bits for A<26..24> -> ctxtReg */
	char	p_mmuIndx;	/* Index into mmu_sizing table for virt. addr */
#endif s32
};

/*
 * Process slot-# definitions.
 */
#define	SWAPPER_SLOTNUM		0
#define	ETC_INIT_SLOTNUM	1
#define	PAGE_DAEMON_SLOTNUM	2

/*
 * Proc-table entry hashing technology
 */
#define	PIDHSZ		63
#define	PIDHASH(pid)	((pid) % PIDHSZ)

#ifdef KERNEL
short	pidhash[PIDHSZ];
struct	proc *pfind();
struct	proc *proc, *procNPROC;	/* the proc table itself */
int	nproc;
int	procsPerUser;

#define	NQS	32		/* 32 run queues */
struct	prochd {
	struct	proc *ph_link;	/* linked list of running processes */
	struct	proc *ph_rlink;
} qs[NQS];
int	whichqs;		/* bit mask summarizing non-empty qs's */
#ifdef s32
struct proc *runq;		/* linked list of runnable processes */
#endif s32
#endif

/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SWAIT	2		/* (abandoned state) */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */

/* flag codes */
#define	SLOAD	0x0000001	/* in core */
#define	SSYS	0x0000002	/* swapper or pager process */
#define	SLOCK	0x0000004	/* process being swapped out */
#define	SSWAP	0x0000008	/* save area flag */
#define	STRC	0x0000010	/* process is being traced */
#define	SWTED	0x0000020	/* another tracing flag */
#define	SULOCK	0x0000040	/* user settable lock in core */
#define	SPAGE	0x0000080	/* process in page wait state */
#define	SKEEP	0x0000100	/* another flag to prevent swap out */
#define	SOMASK	0x0000200	/* restore old mask after taking signal */
#define	SWEXIT	0x0000400	/* working on exiting */
#define	SPHYSIO	0x0000800	/* doing physical i/o (bio.c) */
#define	SVFORK	0x0001000	/* process resulted from vfork() */
#define	SVFDONE	0x0002000	/* another vfork flag */
#define	SNOVM	0x0004000	/* no vm, parent in a vfork() */
#define	SPAGI	0x0008000	/* init data space on demand, from inode */
#define	SSEQL	0x0010000	/* user warned of sequential vm behavior */
#define	SUANOM	0x0020000	/* user warned of random vm behavior */
#define	STIMO	0x0040000	/* timing out during sleep */
/* was SDETACH */
#define	SOUSIG	0x0100000	/* using old signal mechanism */
#define	SOWEUPC	0x0200000	/* owe process an addupc() call at next ast */
#define	SSEL	0x0400000	/* selecting; wakeup/waiting danger */
#define	SLOGIN	0x0800000	/* a login process (legit child of init) */
#define	SPTECHG	0x1000000	/* pte's for process have changed */
#ifdef INTERMEDSIG
#define SNUSIG	0x2000000	/* using intermediate signal mechanism */
#endif INTERMEDSIG

#ifdef s32
/*
 * Values for proc.p_rpcflags
 */
#define RPCFLAG_CLIENT	0x01	/* Process is an RPC client */
#define RPCFLAG_AGENT	0x02	/* Process is an RPC agent process */
#define RPCFLAG_SIGNAL	0x04	/* Signal sent to agent for current call */
#define RPCFLAG_ABORTED	0x08	/* Call being served was aborted */
#define RPCFLAG_SIGERR	0x10	/* Signal error recovery in progress */
#define RPCFLAG_EFS_VCD	0x80	/* Non-DFS network 'cd' for this process */
#endif s32
