/*
 *	Created from file META
 *	By mkdt version $Header: dk_types.h,v 820.1 86/12/04 19:48:44 root Exp $
 *	On Mon Oct 27 10:31:49 1986
 */

#include "sys/types.h"
#include "s32/dkio.h"

enum interface {smd=1, st506, esdi, ansi};
enum media {fixed=1, removable};

typedef u_char	flag;

typedef struct name_list {
	char			*nl_name;
	struct name_list	*nl_next;
	struct model		*nl_model;
}name_list_t;

typedef struct model {
	struct name_list	*m_name;
	char			*m_Manufact;
	u_short			m_nCyl;
	u_short			m_aCyl;
	u_short			m_nHead;
	u_short			m_nSectors;
	u_short			m_Gap1,
				m_Gap2,
				m_Gap3;
	u_short			m_Interleave;
	u_short			m_Skew;
	u_short			m_DiskType;
	u_short			m_Grouping;
	u_short			m_HeadLoad;
	u_short			m_SeekTime;
	u_short			m_Precomp;
	u_short			m_RedWrite;
	u_short			m_StepWidth;
	u_short			m_StepInt;
	int			m_Root;
	int			m_Swap;
	int			m_LgSwap;
	int			m_User;
	int			m_LgUser;
	struct dk_sizes		m_PartSizes[DK_NSIZES];
	int			m_BlockSize;
	int			m_FSBlockSize;
	int			m_FragSize;
	enum interface		m_Interface;
	enum media		m_Media;
	flag			m_Cache;
	flag			m_BufStep;
	flag			m_ZeroLat;
	struct model		*m_next;
}model_t;

#define	WHOLE_DISK		0
#define SINGLE_PART		1
#define SMALL_SWAP		2
#define LG_SWAP			3
#define BOOT_PART		5
#define ROOT_PART		6
#define FIRST_USER_PART		7
#define LAST_USER_PART		14
#define	MAX_PART		16

#define BOOT_START		1
#define BOOT_LEN		2	/* Cylinders */
#define ROOT_START		BOOT_START + BOOT_LEN

extern name_list_t dk_names[];
extern model_t dk_models[];

#ifdef	STRUCT_INIT

name_list_t dk_names [] = {
	{ "eagle", &dk_names[1], &dk_models[0] },
	{ "f2351", &dk_names[2], &dk_models[0] },
	{ "fujitsu-2351",             0, &dk_models[0] },
	{ "OLDeagle",             0, &dk_models[1] },
	{ "f2284", &dk_names[5], &dk_models[2] },
	{ "F2284", &dk_names[6], &dk_models[2] },
	{ "fujitsu-2284",             0, &dk_models[2] },
	{ "f2243as", &dk_names[8], &dk_models[3] },
	{ "fujitsu-2243as",             0, &dk_models[3] },
	{ "f2246e", &dk_names[10], &dk_models[4] },
	{ "fujitsu-2246e",             0, &dk_models[4] },
	{ "h511", &dk_names[12], &dk_models[5] },
	{ "H511", &dk_names[13], &dk_models[5] },
	{ "hitachi-511",             0, &dk_models[5] },
	{ "h512", &dk_names[15], &dk_models[6] },
	{ "H512", &dk_names[16], &dk_models[6] },
	{ "hitachi-512",             0, &dk_models[6] },
	{ "m1085", &dk_names[18], &dk_models[7] },
	{ "maxtor-1085",             0, &dk_models[7] },
	{ "m2190", &dk_names[20], &dk_models[8] },
	{ "maxtor-2190",             0, &dk_models[8] },
	{ "m4175", &dk_names[22], &dk_models[9] },
	{ "maxtor4175",             0, &dk_models[9] },
	{ "m4380", &dk_names[24], &dk_models[10] },
	{ "maxtor4380",             0, &dk_models[10] },
	{ "p3450", &dk_names[26], &dk_models[11] },
	{ "P3450", &dk_names[27], &dk_models[11] },
	{ "priam-3450",             0, &dk_models[11] },
	{ "p7050", &dk_names[29], &dk_models[12] },
	{ "P7050", &dk_names[30], &dk_models[12] },
	{ "priam-7050",             0, &dk_models[12] },
	{ "tm56fa", &dk_names[32], &dk_models[13] },
	{ "tohiba-m56fa",             0, &dk_models[13] },
	{ "mf1300", &dk_names[34], &dk_models[14] },
	{ "megafile", &dk_names[35], &dk_models[14] },
	{ "megafile-1300",             0, &dk_models[14] },
};


model_t dk_models [] = {
/*
 *	 Fujitsu Model eagle
 */
	{ &dk_names [0], "Fujitsu", 842, 38, 20, 44, 20, 30, 0, 3,
	  0, 0, 0, 0, 0, 0, 0, 0,0, 47, 94, 326, 140, 233,
		/* Partitioning Info */
			740960, 0,	/* 842 (0x34a) Cylinders */
			704880, 3,	/* 801 (0x321) Cylinders */
			82720, 50,	/* 94 (0x5e) Cylinders */
			286880, 50,	/* 326 (0x146) Cylinders */
			124080, 3,	/* 141 (0x8d) Cylinders */
			1760, 1,	/* 2 (0x2) Cylinders */
			41360, 3,	/* 47 (0x2f) Cylinders */
			204160, 144,	/* 232 (0xe8) Cylinders */
			123200, 376,	/* 140 (0x8c) Cylinders */
			123200, 516,	/* 140 (0x8c) Cylinders */
			130240, 656,	/* 148 (0x94) Cylinders */
			205040, 376,	/* 233 (0xe9) Cylinders */
			171600, 609,	/* 195 (0xc3) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			376640, 376,	/* 428 (0x1ac) Cylinders */
			580800, 144,	/* 660 (0x294) Cylinders */
			512, 4096, 512, smd, fixed, 0, 0, 0, &dk_models [1] }, 
/*
 *	 Fujitsu Model OLDeagle
 */
	{ &dk_names [3], "Fujitsu", 842, 38, 20, 44, 20, 30, 0, 3,
	  0, 0, 0, 0, 0, 0, 0, 0,0, 0, 0, 0, 0, 0,
		/* Partitioning Info */
			740960, 0,	/* 842 (0x34a) Cylinders */
			2640, 0,	/* 3 (0x3) Cylinders */
			703120, 3,	/* 799 (0x31f) Cylinders */
			1760, 802,	/* 2 (0x2) Cylinders */
			33440, 804,	/* 38 (0x26) Cylinders */
			36080, 3,	/* 41 (0x29) Cylinders */
			37840, 44,	/* 43 (0x2b) Cylinders */
			163680, 44,	/* 186 (0xba) Cylinders */
			125840, 87,	/* 143 (0x8f) Cylinders */
			125840, 230,	/* 143 (0x8f) Cylinders */
			125840, 373,	/* 143 (0x8f) Cylinders */
			125840, 516,	/* 143 (0x8f) Cylinders */
			125840, 659,	/* 143 (0x8f) Cylinders */
			199760, 3,	/* 227 (0xe3) Cylinders */
			463760, 230,	/* 527 (0x20f) Cylinders */
			667040, 44,	/* 758 (0x2f6) Cylinders */
			512, 4096, 512, smd, fixed, 0, 0, 0, &dk_models [2] }, 
/*
 *	 Fujitsu Model f2284
 */
	{ &dk_names [4], "Fujitsu", 823, 42, 9, 34, 20, 22, 0, 2,
	  0, 0, 0, 0, 0, 0, 0, 1,1, 134, 268, 0, 402, 0,
		/* Partitioning Info */
			251838, 0,	/* 823 (0x337) Cylinders */
			238068, 3,	/* 778 (0x30a) Cylinders */
			82008, 137,	/* 268 (0x10c) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			123012, 3,	/* 402 (0x192) Cylinders */
			612, 1,	/* 2 (0x2) Cylinders */
			41004, 3,	/* 134 (0x86) Cylinders */
			115056, 405,	/* 376 (0x178) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			115056, 405,	/* 376 (0x178) Cylinders */
			512, 4096, 512, smd, fixed, 0, 0, 0, &dk_models [3] }, 
/*
 *	 Fujitsu Model f2243as
 */
	{ &dk_names [7], "Fujitsu", 754, 38, 11, 17, 21, 21, 16, 1,
	  3, 6, 0, 0, 8, 65535, 65535, 1,1, 220, 220, 439, 658, 0,
		/* Partitioning Info */
			140998, 0,	/* 754 (0x2f2) Cylinders */
			133331, 3,	/* 713 (0x2c9) Cylinders */
			41140, 223,	/* 220 (0xdc) Cylinders */
			82093, 223,	/* 439 (0x1b7) Cylinders */
			82280, 3,	/* 440 (0x1b8) Cylinders */
			374, 1,	/* 2 (0x2) Cylinders */
			41140, 3,	/* 220 (0xdc) Cylinders */
			51051, 443,	/* 273 (0x111) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			10098, 662,	/* 54 (0x36) Cylinders */
			51051, 443,	/* 273 (0x111) Cylinders */
			512, 4096, 512, st506, fixed, 1, 1, 1, &dk_models [4] }, 
/*
 *	 Fujitsu Model f2246e
 */
	{ &dk_names [9], "Fujitsu", 823, 42, 10, 32, 13, 17, 32, 1,
	  3, 47, 0, 0, 8, 65535, 65535, 1,1, 128, 256, 0, 384, 0,
		/* Partitioning Info */
			263360, 0,	/* 823 (0x337) Cylinders */
			248960, 3,	/* 778 (0x30a) Cylinders */
			81920, 131,	/* 256 (0x100) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			122880, 3,	/* 384 (0x180) Cylinders */
			640, 1,	/* 2 (0x2) Cylinders */
			40960, 3,	/* 128 (0x80) Cylinders */
			126080, 387,	/* 394 (0x18a) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			126080, 387,	/* 394 (0x18a) Cylinders */
			512, 4096, 512, esdi, fixed, 1, 0, 1, &dk_models [5] }, 
/*
 *	 Hitachi Model h511
 */
	{ &dk_names [11], "Hitachi", 823, 42, 10, 17, 17, 17, 16, 1,
	  3, 6, 0, 0, 8, 65535, 65535, 1,1, 241, 241, 0, 723, 0,
		/* Partitioning Info */
			139910, 0,	/* 823 (0x337) Cylinders */
			132260, 3,	/* 778 (0x30a) Cylinders */
			40970, 244,	/* 241 (0xf1) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			81940, 3,	/* 482 (0x1e2) Cylinders */
			340, 1,	/* 2 (0x2) Cylinders */
			40970, 3,	/* 241 (0xf1) Cylinders */
			50320, 485,	/* 296 (0x128) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			50320, 485,	/* 296 (0x128) Cylinders */
			512, 4096, 512, st506, fixed, 1, 1, 1, &dk_models [6] }, 
/*
 *	 Hitachi Model h512
 */
	{ &dk_names [14], "Hitachi", 823, 42, 10, 32, 13, 17, 32, 1,
	  3, 47, 0, 0, 8, 65535, 65535, 1,1, 128, 256, 0, 384, 0,
		/* Partitioning Info */
			263360, 0,	/* 823 (0x337) Cylinders */
			248960, 3,	/* 778 (0x30a) Cylinders */
			81920, 131,	/* 256 (0x100) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			122880, 3,	/* 384 (0x180) Cylinders */
			640, 1,	/* 2 (0x2) Cylinders */
			40960, 3,	/* 128 (0x80) Cylinders */
			126080, 387,	/* 394 (0x18a) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			126080, 387,	/* 394 (0x18a) Cylinders */
			512, 4096, 512, esdi, fixed, 1, 1, 1, &dk_models [7] }, 
/*
 *	 Maxtor Model m1085
 */
	{ &dk_names [17], "Maxtor", 1024, 52, 8, 16, 17, 17, 20, 1,
	  0, 6, 0, 5, 5, 65535, 65535, 1,1, 320, 320, 0, 960, 0,
		/* Partitioning Info */
			131072, 0,	/* 1024 (0x400) Cylinders */
			124032, 3,	/* 969 (0x3c9) Cylinders */
			40960, 323,	/* 320 (0x140) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			81920, 3,	/* 640 (0x280) Cylinders */
			256, 1,	/* 2 (0x2) Cylinders */
			40960, 3,	/* 320 (0x140) Cylinders */
			42112, 643,	/* 329 (0x149) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			42112, 643,	/* 329 (0x149) Cylinders */
			512, 4096, 512, st506, fixed, 1, 1, 1, &dk_models [8] }, 
/*
 *	 Maxtor Model m2190
 */
	{ &dk_names [19], "Maxtor", 1224, 62, 15, 16, 17, 17, 20, 1,
	  0, 6, 0, 5, 5, 65535, 65535, 1,1, 171, 342, 0, 512, 0,
		/* Partitioning Info */
			293760, 0,	/* 1224 (0x4c8) Cylinders */
			278160, 3,	/* 1159 (0x487) Cylinders */
			82080, 174,	/* 342 (0x156) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			123120, 3,	/* 513 (0x201) Cylinders */
			480, 1,	/* 2 (0x2) Cylinders */
			41040, 3,	/* 171 (0xab) Cylinders */
			155040, 516,	/* 646 (0x286) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			155040, 516,	/* 646 (0x286) Cylinders */
			512, 4096, 512, st506, fixed, 1, 1, 1, &dk_models [9] }, 
/*
 *	 Maxtor Model m4175
 */
	{ &dk_names [21], "Maxtor", 1224, 62, 7, 31, 30, 33, 32, 1,
	  0, 39, 0, 0, 5, 65535, 65535, 1,1, 189, 378, 0, 567, 0,
		/* Partitioning Info */
			265608, 0,	/* 1224 (0x4c8) Cylinders */
			251503, 3,	/* 1159 (0x487) Cylinders */
			82026, 192,	/* 378 (0x17a) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			123039, 3,	/* 567 (0x237) Cylinders */
			434, 1,	/* 2 (0x2) Cylinders */
			41013, 3,	/* 189 (0xbd) Cylinders */
			128464, 570,	/* 592 (0x250) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			128464, 570,	/* 592 (0x250) Cylinders */
			512, 4096, 512, esdi, fixed, 1, 1, 1, &dk_models [10] }, 
/*
 *	 Maxtor Model m4380
 */
	{ &dk_names [23], "Maxtor", 1224, 62, 15, 31, 31, 31, 24, 1,
	  0, 39, 0, 1, 1, 65535, 65535, 1,1, 89, 177, 617, 265, 441,
		/* Partitioning Info */
			569160, 0,	/* 1224 (0x4c8) Cylinders */
			538935, 3,	/* 1159 (0x487) Cylinders */
			82305, 92,	/* 177 (0xb1) Cylinders */
			286905, 92,	/* 617 (0x269) Cylinders */
			123690, 3,	/* 266 (0x10a) Cylinders */
			930, 1,	/* 2 (0x2) Cylinders */
			41385, 3,	/* 89 (0x59) Cylinders */
			204600, 269,	/* 440 (0x1b8) Cylinders */
			123225, 709,	/* 265 (0x109) Cylinders */
			87420, 974,	/* 188 (0xbc) Cylinders */
			205065, 709,	/* 441 (0x1b9) Cylinders */
			5580, 1150,	/* 12 (0xc) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			210645, 709,	/* 453 (0x1c5) Cylinders */
			415245, 269,	/* 893 (0x37d) Cylinders */
			512, 4096, 512, esdi, fixed, 1, 1, 1, &dk_models [11] }, 
/*
 *	 Priam Model p3450
 */
	{ &dk_names [25], "Priam", 515, 10, 5, 23, 0, 0, 0, 3,
	  0, 0, 0, 0, 0, 0, 0, 1,1, 0, 0, 0, 0, 0,
		/* Partitioning Info */
			60375, 0,	/* 525 (0x20d) Cylinders */
			58880, 3,	/* 512 (0x200) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			115, 0,	/* 1 (0x1) Cylinders */
			230, 1,	/* 2 (0x2) Cylinders */
			19435, 3,	/* 169 (0xa9) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			20010, 172,	/* 174 (0xae) Cylinders */
			8280, 172,	/* 72 (0x48) Cylinders */
			31165, 244,	/* 271 (0x10f) Cylinders */
			19435, 346,	/* 169 (0xa9) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			512, 4096, 512, ansi, fixed, 0, 0, 0, &dk_models [12] }, 
/*
 *	 Priam Model p7050
 */
	{ &dk_names [28], "Priam", 1049, 40, 5, 23, 0, 0, 0, 3,
	  0, 0, 0, 0, 0, 0, 0, 1,1, 0, 0, 0, 0, 0,
		/* Partitioning Info */
			120635, 0,	/* 1049 (0x419) Cylinders */
			115690, 3,	/* 1006 (0x3ee) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			115, 0,	/* 1 (0x1) Cylinders */
			230, 1,	/* 2 (0x2) Cylinders */
			19435, 3,	/* 169 (0xa9) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			24495, 172,	/* 213 (0xd5) Cylinders */
			8280, 172,	/* 72 (0x48) Cylinders */
			87975, 244,	/* 765 (0x2fd) Cylinders */
			71760, 385,	/* 624 (0x270) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			56120, 521,	/* 488 (0x1e8) Cylinders */
			40135, 172,	/* 349 (0x15d) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			512, 4096, 512, ansi, fixed, 0, 0, 0, &dk_models [13] }, 
/*
 *	 Toshiba Model tm56fa
 */
	{ &dk_names [31], "Toshiba", 830, 42, 10, 17, 17, 17, 16, 1,
	  3, 6, 0, 0, 8, 65535, 65535, 1,1, 241, 241, 0, 723, 0,
		/* Partitioning Info */
			141100, 0,	/* 830 (0x33e) Cylinders */
			133450, 3,	/* 785 (0x311) Cylinders */
			40970, 244,	/* 241 (0xf1) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			81940, 3,	/* 482 (0x1e2) Cylinders */
			340, 1,	/* 2 (0x2) Cylinders */
			40970, 3,	/* 241 (0xf1) Cylinders */
			51510, 485,	/* 303 (0x12f) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			51510, 485,	/* 303 (0x12f) Cylinders */
			512, 4096, 512, st506, fixed, 1, 1, 1, &dk_models [14] }, 
/*
 *	 Siemens Model mf1300
 */
	{ &dk_names [33], "Siemens", 1216, 61, 12, 35, 11, 19, 20, 1,
	  11, 55, 13, 0, 8, 65535, 65535, 1,1, 98, 196, 683, 293, 488,
		/* Partitioning Info */
			510720, 0,	/* 1216 (0x4c0) Cylinders */
			483840, 3,	/* 1152 (0x480) Cylinders */
			82320, 101,	/* 196 (0xc4) Cylinders */
			286860, 101,	/* 683 (0x2ab) Cylinders */
			123480, 3,	/* 294 (0x126) Cylinders */
			840, 1,	/* 2 (0x2) Cylinders */
			41160, 3,	/* 98 (0x62) Cylinders */
			204540, 297,	/* 487 (0x1e7) Cylinders */
			155820, 784,	/* 371 (0x173) Cylinders */
			155820, 784,	/* 371 (0x173) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			0, 0,	/* 0 (0x0) Cylinders */
			155820, 784,	/* 371 (0x173) Cylinders */
			360360, 297,	/* 858 (0x35a) Cylinders */
			512, 4096, 512, esdi, fixed, 1, 0, 1, 0 }, 
};
#endif	STRUCT_INIT
