static char rcsid[] = "$Header: efs_netsu.c,v 820.1 86/12/04 19:47:42 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984, 1985			*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Handle the concept of network super-user.
 * If a node attempts use super user permissions
 * but is not allowed to then we convert his
 * uid and gid to those less powerful.
 *
 * jam 840507-10
 * smj 850813	Remove (enable) refs to NET_SUPER_USER
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../efs/efs.h"

efs_checkNetsu()
{
	/*
	 * If the remote node is not trying to access
	 * this node as super user then do nothing.
	 */
	if (u.u_uid != 0)
		return;

	/*
	 * For now, since we do not have a node list,
	 * we either allow all nodes or no nodes to
	 * be super user.
	 */
	if (efs_netsutype == EFS_SU_MOST)
		return;

	/*
	 * The node is not allowed to have super
	 * user privilidges so we change him from
	 * super user to someone else.
	 */
	u.u_uid = efs_netsuuid;
}
