#include "escseqp.h"

#if defined(SUN3) || defined(SUN4)
#ifndef SUN
#define SUN 1
#endif
#endif

#if defined(SUN)
#define cexternal external c
#endif SUN

#if defined(PMAX)
#define cexternal external
#endif SUN

#if defined(S32) || defined(PC_AT)
#define SVS
implementation
#else
#define longint integer
#endif


(**********************************************************************)
(* Handy utilities -- not external ************************************)
(**********************************************************************)



procedure dumpbuf{(var fi : text; var msg : escseqbuf)};
var
    i : integer; 
begin
    writeln(fi, 'buffer contents:');
    with msg do begin
        writeln(fi, '   datatype = ', datatype);
        writeln(fi, '   x1 = ', x1);
        writeln(fi, '   x2 = ', x2);
        writeln(fi, '   y1 = ', y1);
        writeln(fi, '   y2 = ', y2);
        writeln(fi, '   num = ', num);
        writeln(fi, '   strlen = ', strlen);
        write(fi, '     str = "');
        (* Note: str is not a "string" type -- it has no length field! *)
        for i := 1 to strlen do begin
            write(fi, str^[i]);
        end;
        writeln(fi, '"');
    end;
end;



procedure clearbuf{(var msg : EscSeqBuf)};
begin
    with msg do begin
        datatype:=      escerror;
        x1      :=      0;
        x2      :=      0;
        y1      :=      0;
        y2      :=      0;
        num     :=      0;
        strlen  :=      0;
        (* Note: str is not a "string" type -- it has no length field! *)
        str^[1] :=      chr(0);
    end;
end;




procedure initbuf{(var msg : EscSeqBuf)};
var
    i : integer;
begin
    with msg do begin
        (* Note: str is not a "string" type -- it has no length field! *)
        new(str);
        for i := 1 to escseqstrsize do begin
            str^[i]     :=      chr(0);
        end;
    end;
    clearbuf(msg);
end;




procedure smartmsgbufdump {(var reportfile: text;
							   var msg: escseqbuf)};
var
    i : integer;
begin
    with msg do begin
        if not (datatype in [esclowest..eschighest]) then begin
            writeln(reportfile,
                'bad datatype: value = ',
                datatype,
                '.  Changing it to ESCERROR...');
            datatype := escerror;
        end;
        case datatype of
            esccmd: begin
                writeln(reportfile,
                    'ESCCMD: command -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            esccpp: begin
                writeln(reportfile,
                    'ESCCPP: move cursor to pixel coordinates (',
                    x1 : 0,
                    ',',
                    y1 : 0,
                    ')');
            end;
            esccpr: begin
                writeln(reportfile,
                    'ESCCPR: cursor position report -- cursor is at line ',
                    x1 : 0,
                    ' column ',
                    y1 : 0);
            end;
            esccub: begin
                writeln(reportfile,
                    'ESCCUB: cursor backwards -- ',
                    num : 0,
                    ' positions');
            end;
            esccud: begin
                writeln(reportfile,
                    'ESCCUD: cursor down -- ',
                    num : 0,
                    ' lines');
            end;
            esccuf: begin
                writeln(reportfile,
                    'ESCCUF: cursor forward -- ',
                    num : 0,
                    ' positions');
            end;
            esccup: begin
                writeln(reportfile,
                    'ESCCUP: move cursor to line ',
                    x1 : 0,
                    ' column ',
                    y1 : 0);
            end;
            esccuu: begin
                writeln(reportfile,
                    'ESCCUU: cursor up -- ',
                    num : 0,
                    ' lines');
            end;
            escdch: begin
                writeln(reportfile,
                    'ESCDCH: delete ',
                    num : 0,
                    ' chars');
            end;
            escdcs: begin
                writeln(reportfile,
                    'ESCDCS: start device control string');
            end;
            escdl: begin
                writeln(reportfile,
                    'ESCDL: delete ',
                    num : 0,
                    ' lines');
            end;
            esced: begin
                writeln(reportfile,
                    'ESCED: erase in display -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escel: begin
                writeln(reportfile,
                    'ESCEL: erase in line -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escend: begin
                writeln(reportfile, 'ESCEND');
            end;
            escerrmsg: begin
                writeln(reportfile,
                    'ESCERRMSG: error message -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            esceof: begin
                writeln(reportfile, 'ESCEOF');
            end;
            escerror: begin
                writeln(reportfile, 'ESCERROR');
            end;
            escich: begin
                writeln(reportfile,
                    'ESCICH: insert ',
                    num : 0,
                    ' chars');
            end;
            escil: begin
                writeln(reportfile,
                    'ESCIL: insert ',
                    num : 0,
                    ' lines');
            end;
            esciquit: begin
                writeln(reportfile, 'ESCIQUIT');
            end;
            escmc: begin
                writeln(reportfile,
                    'ESCMC: media copy -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escpl: begin
                writeln(reportfile,
                    'ESCPL: plot line of type ',
                    num : 0,
                    ' from pixel coordinates (',
                    x1 : 0,
                    ',',
                    y1 : 0,
                    ') to (',
                    x2 : 0,
                    ',',
                    y2 : 0,
                    ')');
            end;
            escppr: begin
                writeln(reportfile,
                    'ESCPPR: pixel position report -- cursor is at (',
                    x1 : 0,
                    ',',
                    y1 : 0,
                    ')');
            end;
            escprompt: begin
                writeln(reportfile,
                    'ESCPROMPT: prompt for data -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escputinmenu: begin
                writeln(reportfile,
                    'ESCPUTINMENU: put in menu box ',
                    num : 0);
            end;
            escrm: begin
                writeln(reportfile,
                    'ESCRM: reset mode -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escrsm: begin
                writeln(reportfile,
                    'ESCRSM: report set modes -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escrvm: begin
                writeln(reportfile,
                    'ESCRVM: reset Valid mode -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escsd: begin
                writeln(reportfile,
                    'ESCSD: scroll down ',
                    num : 0,
                    'lines');
            end;
            escsm: begin
                writeln(reportfile,
                    'ESCSM: set mode -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            escst: begin
                writeln(reportfile,
                    'ESCST: end device control string');
            end;
            escsu: begin
                writeln(reportfile,
                    'ESCSU: scroll up ',
                    num : 0,
                    'lines');
            end;
            escsvm: begin
                writeln(reportfile,
                    'ESCSVM: set Valid mode -- ',
                    '(code ',
                    num : 0,
                    ')');
            end;
            esctext: begin
                writeln(reportfile,
                    'ESCTEXT: write some text:');
                write(reportfile,
                    '   <');
                (* Note: str is not a "string" type -- it has no length
                field! *)
                for i := 1 to strlen do begin
                    write(reportfile, str^[i]);
                end;
                writeln(reportfile, '>');
            end;
            escwakeup: begin
                writeln(reportfile, 'ESCWAKEUP');
            end;
        end;    (* case datatype of *)
    end;                (* with msg do begin *)
end;


procedure cpstr16totextbuffer{(
    s16: string16;
    nchars : integer;
    var msg: escseqbuf;
    off : integer
    )};
var
    i : integer;
begin
    with msg do begin
        datatype := esctext;
        for i := 1 to nchars do begin
            (* Note: str is not a "string" type -- it has no length field! *)
            str^[off + i] := s16[i];
        end;
        strlen := strlen + nchars;
    end;
end;





(**********************************************************************)
(* Initialize IO for escape sequences.  Must be called AFTER reset or
rewrite of file, but BEFORE first send or read is done. *)
#ifdef SVS
function xinit_es(fdesc : longint; iop : comiobuf) : boolean; cexternal;
function initesio;
begin
    initesio := xinit_es(fdesc,iop);
end;
#endif SVS
#if defined(SUN) || defined(PMAX)
function xinit_es(iop : comiobuf; fdesc: longint) : boolean; cexternal;
function initesio;
begin
    initesio := xinit_es(iop, fdesc);
end;
#endif SUN || PMAX


(**********************************************************************)
(* Send the message in the message buffer. *)
#ifdef SVS
function xwrite_es(iop : comiobuf; var buf : escseqbuf) : boolean; cexternal;
function sendescseq;
begin
    sendescseq := xwrite_es(iop,buf);
end;
#endif SVS
#if defined(SUN) || defined(PMAX)
function xwrite_es(var buf : escseqbuf; iop: comiobuf) : boolean; cexternal;
function sendescseq;
begin
    sendescseq := xwrite_es(buf, iop);
end;
#endif SUN || PMAX

(* Flush all accumulated IO to force a write to the other process. *)
function xflush_es(iop : comiobuf) : boolean; cexternal;
function flushescseq;
begin
    flushescseq := xflush_es(iop);
end;


(* Put the next message in the message buffer. *)
#ifdef SVS
function xread_es(iop : comiobuf; var buf : escseqbuf) : boolean; cexternal;
function readescseq;
begin
    readescseq := xread_es(iop,buf);
end;
#endif SVS
#if defined(SUN) || defined(PMAX)
function xread_es(var buf: escseqbuf; iop: comiobuf) : boolean; cexternal;
function readescseq;
begin
    readescseq := xread_es(buf, iop);
end;
#endif SUN || PMAX

(* The external code keeps files that monitor reads and writes to the pipe.
This procedure lets the user turn the monitor on and off (default off).
Note that if you want to turn it on you have to turn it off later to close
it.  You should always close it when you close the subprocess.  *)
#ifdef SVS
procedure xch_monitor(iop : comiobuf; turnon : longint); cexternal;
procedure changemonitor;
begin
    xch_monitor(iop,turnon);
end;
#endif SVS
#if defined(SUN) || defined(PMAX)
procedure xch_monitor(turnon: longint; iop : comiobuf); cexternal;
procedure changemonitor;
begin
    xch_monitor(turnon, iop);
end;
#endif SUN || PMAX

#ifdef SVS
end.
#endif SVS
