#define ERULE_C 1
#include "Clib/heap.h"

#include "erule.h"
#include "error.h"
#include "dwg_table.h"
#include "table.h"

#include "/home/andre/hoshah/c++/ds/ds_comp.h"

#include "dwg_extension.h"



erule_table* erule_the_rule_table = 0;
erule_drawing_table erule_the_drawing_table;
heap erule_heap(0);


erule::erule(const string& compile_type)
{
    erule_heap.establish();
    AS(!erule_the_rule_table);
    new erule_table(compile_type);
    AS(erule_the_rule_table);  // Set by constructor
}


void erule::dump(ostream& o) 
{ 
    if (!erule_the_rule_table) return;
    erule_the_rule_table->dump(o);
    erule_the_drawing_table.dump(o);
}



boolean erule::read(char* filename)
{
    AS(erule_the_rule_table);
    return erule_the_rule_table->read(filename);
}


static void
resolve_presence_of_both(erule_rule* rule,
			 erule_drawing_extension** ext,
                         erule_drawing_special** spec)
{
   if (*spec && *ext) {
	int spec_ord = rule->ord(*spec);
	int ext_ord = rule->ord(*ext);
	if (ext_ord < spec_ord) *spec = 0;
	else if (!((*ext)->is_prim())) *ext = 0;
    }
}


erule_selection::erule_selection(const string& drawing, 
				 const string& context_name,
				 boolean non_existence_not_error)
    : _context(context_name)
{
    if (!erule_the_rule_table) new erule("LOGIC");
    boolean alloc = this ? FALSE : TRUE;
    this = this ? this : (erule_selection*)erule_heap.mem(sizeof(*this));
    allocated = alloc;

    _special = 0;  _extension = 0;

    erule_current_drawing = _drawing = erule_the_drawing_table.enter(drawing);
    if (!_drawing) return;

    erule_rule* rule = erule_the_rule_table->enter()->select();
    if (!rule) return;

    _drawing->push_exception(rule, _context);

    _special = _drawing->select_special(rule);
    _extension  = _drawing->select_extension(rule, _special != 0 ||
					     non_existence_not_error);
    resolve_presence_of_both(rule, &_extension, &_special);
    _extension_forced_to_primitive = rule->forced_to_primitive(_extension);

    _drawing->pop_exception(rule, _context);
}


const char* erule_selection::
filename(erule_filetype filetype, unsigned page, char* context)
{
    const char *name;

    static char* ftypes[] = { "", "CN", "PE", "PL", "LL", "", "SCHEMA" };

    if (filetype == ERULE_SPECIAL) {
	if (!_special) {
	    fault("A special file has not been selected");  return 0;
	}
    }
    else {
	if (!_extension) {
	    fault("A drawing has not been selected");  return 0;
	}
    }

    ds_fileobj file_mod;
    ds_compdwg *ds_comp_ptr = _extension->get_associated_ds_compdwg();
    if (ds_comp_ptr) {
	if (ds_comp_ptr->get_file(file_mod, filetype, ftypes[filetype],
			     version(), page, context)) {
	    name = file_mod.full_ds_name();
	}
    }

    if (!name) erule_err.sdl();
    return name;
}


boolean erule_selection::is_primitive()
{
    if (_special) return TRUE;
    if (!_extension) return FALSE;
    return _extension->is_prim() ? TRUE : _extension_forced_to_primitive;
}


int erule_selection::is_simple_primitive()
{
    if (!_extension || !(_extension->is_prim())) return 0;
    if (!(_drawing->is_single_versioned())) return 0;
    erule_drawing_page* page = _extension->first_page();
    if (!page) return 0;
    int pgnum = page->page_number();
    if (_extension->next_page(page)) return 0;

    // So far, so good -- we have PRIM.1.1 with no other versions or pages.
    // Now, we need to check whether the parameterization affects the 
    // selection.

    erule_entry* entry = erule_the_rule_table->enter();  AS(entry);
    erule_rule* rule = entry->rules.first();  AS(rule);
    if (!entry->rules.next(rule)) return pgnum;		// only 1 rule -- ok

    erule_err.disable();
    for (; rule && pgnum; rule = entry->rules.next(rule)) {
	_drawing->push_exception(rule, _context);
	erule_drawing_extension* ext = 
	    _drawing->select_from_single_version(rule);
	erule_drawing_special* spec = _drawing->select_special(rule);
	resolve_presence_of_both(rule, &ext, &spec);
#ifdef DEBUG
	cerr << "ext = " << hex((int)ext) << " _extension = " << 
	    hex((int)_extension) NL;
#endif
        if (ext == _extension) {
	   if (spec != _special || 
		rule->forced_to_primitive(ext) != _extension_forced_to_primitive) {
#ifdef DEBUG
	       cerr << "spec = " << hex((int)spec) << " _special = " << 
		   hex((int)_special) NL;
	       cerr << "rule->forced_to_primitive(ext) = " <<
		   rule->forced_to_primitive(ext) <<
		       " _extension_forced_to_primitive = " <<
			   _extension_forced_to_primitive NL;
#endif
	       pgnum = 0;
	   }

	}
	else pgnum = 0;
	_drawing->pop_exception(rule, _context);
    }
    erule_err.enable();
    return pgnum;
}

boolean erule_selection::same_drawing(erule_selection* other)
{
    if (!other) return !this;
    if (!this) return FALSE;
    if (_drawing != other->_drawing) return FALSE;

    ds_compdwg *ds_comp_ptr1;
    if (_extension) ds_comp_ptr1 = _extension->get_associated_ds_compdwg();
    else if (_special) ds_comp_ptr1 = _special->get_associated_ds_compdwg();
    else return (!(other->_extension) && !(other->_special));

    ds_compdwg *ds_comp_ptr2;
    if (other->_extension) 
	ds_comp_ptr2 = other->_extension->get_associated_ds_compdwg();
    else {
	if (other->_special) 
	    ds_comp_ptr2 = other->_special->get_associated_ds_compdwg();
    }

    if (ds_comp_ptr1 && ds_comp_ptr2) 
	if (ds_comp_ptr1->StartPath() == ds_comp_ptr2->StartPath()) return TRUE;

    return FALSE;
}

string erule_selection::directory_type()
{
    ds_compdwg *ds_comp_ptr= 0;
    if (_extension) ds_comp_ptr = _extension->get_associated_ds_compdwg();
    if (ds_comp_ptr) return ds_comp_ptr->dwg_type();
    else return "";
}


boolean erule::except(const string& compile_type, 
		      const string& drawing, const string& context,
                      const string& extension, const string& attribute)
{
    if (!erule_the_rule_table) fault("Out of sequence");

    // Ignore exceptions for other compile types
    if (!erule_the_rule_table->enter(compile_type)) return TRUE;

    erule_drawing_entry* dwg = 
	erule_the_drawing_table.enter_without_directory_read(drawing);
    if (!dwg) return FALSE;

    dwg->enter_exception(context, new erule_extension(extension, attribute));
    return TRUE;
}
























