






#ifndef ER_ERROR_H
#define ER_ERROR_H
#ifdef PASCAL_XFACE
#include "pascal.h"

#else
/*
#include "ADD.h"
*/
#include "environment.h"
#include "extern_global.h"
#endif

#include "expression.h"
class erule_drawing_page;
class erule_drawing_extension;
class erule_drawing_entry;
class erule_drawing_special;
class erule_expression;

class ds_compdwg;



const ERR_SUPPRESSED = 0;       // Error that's always suppressed

/*
    Error processing -- this interface is  consitent  across
    the  versions  for PASCAL and non-PASCAL.  For now, only
    the former is implemented.  pages.  Intended for  inter-
    nal use only.
*/

class erule_error {
    void parse_line(const char* line, int column);
    boolean enabled;
    boolean errors_enabled;
public:
    erule_error();
    void enable();      // The default state
    void disable();     // Makes this a "bit motel" for errors
                        // (asserts are always printed)

    void sdl();         // Errors in Scald Data Locator
    void assert(int, const char* filename = 0, const char* line = 0, int lineno = 0, int column = 0);
                        // Numbered assertion check failures
    void parse(int, const char* filename, const char* line = 0, int lineno = 0, int column = 0);
    void message(int, erule_drawing_entry* d = 0);
    void message(int, erule_drawing_entry*, erule_drawing_extension*,
                      erule_drawing_page* = 0);
    void current_conn_file(int);
    void context();
#ifdef PASCAL_XFACE
    erule_error operator<<(const char* s)
        { if (enabled) pascal_err_string(s);  return *this; }
    erule_error operator<<(int i)
        { if (enabled) pascal_err_int(i);  return *this; }
    erule_error operator<<(const erule_expression& e)
        { if (enabled) pascal_err_xtring(e.message());  return *this; }
    erule_error operator<<(class pascal_crlf*)
        { if (enabled) pascal_err_crlf();  return *this; }
    erule_error operator<<(class erule_error_indent*)












        { if (enabled) pascal_err_indent();  return *this; }
#define ERR_NL << (class pascal_crlf*)0
#else
    erule_error put(char c) { cerr.put(c);  return *this; }
    erule_error operator<<(const char* s)
        { cerr << s; return *this; }
    erule_error operator<<(int i)
        { cerr << i; return *this; }
    erule_error operator<<(const erule_expression& e)
        { return enabled ? operator<<(e.message()) : *this; }
    erule_error operator<<(class erule_error_indent*)
        { cerr << "        ";  return *this; }
#define ERR_NL NL
#endif
#define ERR_INDENT << (class erule_error_indent*)0
} ;

extern erule_error erule_err;
extern erule_drawing_entry* erule_current_drawing;
extern char* erule_current_extension;
extern int erule_current_version;
extern int erule_current_page;
extern ds_compdwg *erule_current_ds_compdwg_ptr; 

inline erule_error::erule_error() { enabled = errors_enabled = TRUE; }
inline void erule_error::enable() { enabled = errors_enabled = TRUE; }
inline void erule_error::disable() { enabled = errors_enabled = FALSE; }

#ifdef PASCAL_XFACE
inline void erule_error::sdl()
    { if (enabled) pascal_err_sdl(); }
inline void erule_error::context()
    { if (enabled) pascal_err_context(); }
#else
inline void erule_error::sdl()
    { /*if (enabled) ADD_VAR->process_error();*/ }
#endif






















const ERR_ID_TOO_LONG = 41;                     // Lexical errors






const ERR_EOL_IN_STR = 89;
const ERR_UNCLOSED_COMMENT = 34;
const ERR_UNKNOWN_SY = 23;

const ERR_CANT_OPEN = 100;                      // File/parse errors
const ERR_CANT_OPEN_CN = 205;
const ERR_EXP_FILETYPE = 85;
const ERR_WRONG_FILETYPE = 86;
const ERR_EXP_ID = 1;
const ERR_EXP_STRING = 33;
const ERR_EXP_EQ = 2;
const ERR_EXP_SEMI = 12;
const ERR_EXP_COLON = 13;
const ERR_EXP_COMMA = 5;
const ERR_EXP_RPAREN = 7;
const ERR_EXP_END = 40;
const ERR_EXP_DOT = 37;
const ERR_EXP_EOF = 98;

const ERR_PRIM_IS_ILLEGAL_DIR_TYPE = 28;        // Semantic rule errors
const ERR_PRIM_REQUIRES_ATTRIBUTE = 26;
const ERR_EXP_SPECIAL_OR_PRIMITIVE = 27;
const ERR_PRIM_COMPTYPE = 66;
const ERR_PART_COMPTYPE = 216;

const ERR_DRAWING_NOT_FOUND = 191;              // Selection errors
const ERR_NO_TRUE_VERSION = 190;
const ERR_NO_ACCEPTABLE_EXTENSION = 193;
const ERR_MULTIPLE_DEFAULT_VERSIONS = 253;
const ERR_MULTIPLE_TRUE_VERSIONS = 139;
const ERR_NO_TRUE_RULES = 190;
const ERR_MULTIPLE_TRUE_RULES = 139;
const ERR_MULTIPLE_DEFAULT_RULES = 253;
// NOTE -- the last 2 may be reported as parse errors

const ERR_VERSION_NUM = 70;                     // Page configuration errors
const ERR_PAGE_NUM = 71;
const ERR_PART_AND_PRIM = 240;
const ERR_VERSION_ACROSS_DRAWINGS = 247;
//const ERR_VERSION_ACROSS_DIRECTORIES = 247;
const ERR_SPECIAL_ACROSS_DIRECTORIES = 254;
const ERR_EXP_MENU = 79;
const ERR_VERS_NOT_FOUND_IN_DIR = 77;

const ERR_ASSERT = 187;

#endif














