#include "error.h"

#include "dwg_table.h"

void erule_drawing_table::dump(ostream& f)
{
    f << "\n------------- Drawing table ----------------------------------\n\n";

    gavlinorder(_name,erule_drawing_entry,string) dwgs(drawings);
    erule_drawing_entry* d;
    while (d = dwgs.next()) d->dump(f);
}


erule_drawing_entry* erule_drawing_table::enter_without_directory_read(const string& name)
{
    AS(this);
    erule_drawing_entry* drawing = drawings.find(name);
    if (drawing) return drawing;

    erule_current_drawing = drawing = new erule_drawing_entry(name);
    drawings.insert(drawing);
    return drawing;
}



    







































