#include <stdio.h>
#include "Clib/gavl.h"

#include "er_heap.h"
#include "error.h"
#include "lex.h"
#include "dwg_extension.h"
#include "dwg_version.h"
#include "dwg_entry.h"

#include "/home/andre/hoshah/c++/ds/ds_comp.h"
#include "/home/andre/hoshah/c++/ds/ext_ds.h"


const MAX_PAGE_NUM = 10000;	// per previous ValidCOMPILERs


#ifdef VAX
gring_functions(next,erule_drawing_extension,);
#endif


erule_drawing_extension::
erule_drawing_extension(erule_drawing_version* v, const string& ext,
                        const ds_compdwg *ds_ptr)
{ 
    AS(!this);
    this = (erule_drawing_extension*)erule_heap.mem(sizeof(*this));
    AS(!pages.first());
    version = v;
    _name = ext;  
    expr_found_in_menu = FALSE;
    dsd_ptr = ds_ptr;
}


erule_drawing_extension::~erule_drawing_extension()
{ 
    erule_drawing_page* pg;
    while (pg = pages.remove_first()) delete pg;

    erule_heap.memfree(this, sizeof(*this));  this = 0;
}

erule_drawing_extension* erule_drawing_extension::
check_drawing_collision(const ds_compdwg &ds_compmod)
{
    AS(!dsd_ptr);
    String s = (dsd_ptr->StartPath()).PathName();
    String r = (ds_compmod.StartPath()).PathName();
    if (s != r) {
	collision_error(ds_compmod);
	this = 0;
    }
    return this;
}

void erule_drawing_extension::dump(ostream& f)
{
    erule_drawing_page* p = pages.first();
    
    if (!p)  {
	f << "    " << _name << "." << version_number() << " (no pages) " 
	    << " ";
	if (dsd_ptr) f << (dsd_ptr->StartPath()).PathName();
	else f << "";
	f NL;
    }
    int first = TRUE;
    while (p) { 
	f << "    " << _name << "." << version_number() << "." <<
	    p->page_number();
        if (first) {
	    f << " ";
	    if (dsd_ptr) f <<  (dsd_ptr->StartPath()).PathName();
	    else f <<  "";
	    first = FALSE;
	}
        f NL;
	p = pages.next(p);
    }
}

const char* erule_drawing_extension::
connectivity_file(erule_drawing_entry* d, erule_drawing_page* p)
{
    if (dsd_ptr) {
	ds_fileobj fb;
	if (dsd_ptr->get_file(fb, ERULE_CONNECTIVITY, name(), 
			      version_number(), p->page_number(), 0))
	    return fb.full_ds_name();
    }
    return 0;
}


static string PRIM;	// Should be local, but cfront can't handle it yet
static string PART;
boolean erule_drawing_extension::is_prim()
{
    if (PRIM == 0) { PRIM = "PRIM";  PART = "PART"; }
    return _name == PRIM || _name == PART;
}


erule_drawing_page* erule_drawing_extension::
enter_page(int num)
{
    if (num < 0 || num > MAX_PAGE_NUM) {
	erule_err.current_conn_file(ERR_PAGE_NUM);
        return 0;
    }

    erule_drawing_page* prev;
    erule_drawing_page* page;

    // Hack to optimize case where we get them in order

    prev = pages.last();
    if (prev && prev->page_number() <= num) {
	page = new erule_drawing_page(num);
	pages.insert_rear(page);
	return page;
    }

    // General-purpose (n-squared) algorithm

    prev = 0;
    page = pages.first();
    while (page) {
	if (page->page_number() >= num) break;
	prev = page;
	page = pages.next(page);
    }
    if (!page || page->page_number() != num) {
	page = new erule_drawing_page(num);
	if (prev) pages.insert_after(page, prev);
	else pages.insert_front(page);
    }
    return page;
}


boolean erule_drawing_extension::
operator==(const erule_drawing_extension& e)
{
    if (is_prim())
	if (e.is_prim()) {
	    if (dsd_ptr && e.dsd_ptr) 
		return (*dsd_ptr == *(e.dsd_ptr)) ? TRUE : FALSE;
	}
    else return name() == e.name();
    return FALSE;
}


void erule_drawing_extension::error_dump_expression()
{
    erule_err ERR_INDENT << _name << "." << version_number();
    erule_err << " EXPR=" << _expression ERR_NL;
}


void erule_drawing_extension::
set_expression_from_menu(erule_drawing_entry* drawing,
			 const erule_expression& e)
{ 
    if (expr_found_in_menu) {
	erule_err.message(76 /* already assigned */, drawing, this);
	return;
    }
    _expression = e;  expr_found_in_menu = TRUE;
}

	
boolean erule_drawing_extension::read_expression(erule_drawing_entry* drawing)
{
    if (expr_found_in_menu) return TRUE;

    erule_drawing_page* page = pages.first();  AS(page);

    const char *ds_filename = connectivity_file(drawing, page);

    if (!ds_filename) {
	erule_err.sdl();
	erule_err ERR_INDENT << "Unable to read selection expression for " <<
		  name() << "." << version_number() ERR_NL;
	return TRUE;		// Leaves expression defaulting to TRUE
				// (which is the backward-compatible thing)
    }

    FILE *fp = dsfile_fopen(ds_filename, 0, 'r');

    if (!fp) {
	erule_err.message(ERR_CANT_OPEN_CN);
	erule_err ERR_INDENT << "DS Object=" << ds_filename ERR_NL;
	return TRUE;
    }
    
    erule_lex lex(fp);

    if (!lex.scald_file_type()) return TRUE;

    if (!strcmp(lex.val(), "CONNECTIVITY")) {
	lex.next_token();
	if (lex == LEX_SEMI) lex.next_token();
	else lex.error(ERR_EXP_SEMI);

	if (lex == LEX_ID && !strcmp(lex.val(), "EXPR")) {
	    lex.next_token();
	    if (lex != LEX_EQ) lex.error(ERR_EXP_EQ);
	    else lex.next_token();
	    if (lex != LEX_STRING) lex.error(ERR_EXP_STRING);
	    else _expression = lex.val();
	}
    }
    else if (!strcmp(lex.val(), "MACRO_DEFINITION")) {
	if (version_number() == 1) return FALSE;	// A menu drawing
	else erule_err.message(ERR_EXP_MENU, drawing, this);
    }
    else {
	lex.error(ERR_WRONG_FILETYPE);
	erule_err ERR_INDENT << "Expected CONNECTIVITY" ERR_NL;
    }
    dsfile_fclose(fp);

    return TRUE;
}


struct reported_collision {
    erule_drawing_extension* ext;
    ds_compdwg *ds_ptr;
    int error;
    reported_collision(erule_drawing_extension* _ext,
                       ds_compdwg *dp,
		       int _error)
	{ ext = _ext;  ds_ptr = dp;  error = _error; }
};
typedef reported_collision* reported_collisionP;

static int compare_collisions(reported_collision* c1, reported_collision* c2)
{
    int val = c1->ext - c2->ext;
    if (val) return val;
/*
    if (val = c1->other_dir.which() - c2->other_dir.which()) return val;
    if (val = c1->other_dir.name().ptr_cmp(c2->other_dir.name())) return val;
*/
    return c1->error - c2->error;
}
static gavlkey_define(reported_collisionP);
static gavlkey_search(reported_collisionP, compare_collisions);


gavl_define(entry,collision_entry,reported_collisionP);
static class collision_entry {
    gavl_inst(entry,collision_entry,reported_collisionP);
    reported_collision collision;
public:
    collision_entry(int error, erule_drawing_extension* ext, const ds_compdwg *dsp);
    ~collision_entry() { erule_heap.memfree(this, sizeof(*this));  this = 0; }
};
gavl_inline(entry,collision_entry,reported_collisionP);


collision_entry::
collision_entry(int error, erule_drawing_extension* ext, const ds_compdwg *dsp)
: collision(ext, dsp, error)
{
    AS(!this);
    this = (collision_entry*)erule_heap.mem(sizeof(*this));
    entry = &collision;
}


static class reported_collisions {
    gavlroot(entry,collision_entry,reported_collisionP) collisions;
public:
    boolean operator()(int error, erule_drawing_extension* e, const ds_compdwg *dsp);
} already_reported;

static boolean reported_collisions::
operator()(int error, erule_drawing_extension* e, const ds_compdwg *dsp) {
    collision_entry* coll = new collision_entry(error, e, dsp);
    boolean val = (int)(collisions.insert(coll) != coll);
	// (int) type cast avoids stupid c compiler bug -- it thinks
	// that the result of ptr != ptr is of type ptr.
    if (val) delete coll;
    return val;
}


void erule_drawing_extension::collision_error(const ds_compdwg &ds_compmod)
{
    if (already_reported(ERR_VERSION_ACROSS_DRAWINGS, this, &ds_compmod)) return;
    
    erule_err.message(ERR_VERSION_ACROSS_DRAWINGS, erule_current_drawing, this);
    erule_err ERR_INDENT << "Using " << name() << " from " << 
	(dsd_ptr->StartPath()).PathName() ERR_NL;
    erule_err ERR_INDENT << "Ignoring ." 
	<< (ds_compmod.StartPath()).PathName() ERR_NL;
}


erule_drawing_extension* erule_drawing_extension::
check_prim_collision(const string& extension, const ds_compdwg& ds_compmod)
{
    AS(!dsd_ptr);
    if (name() != extension) {
	if (already_reported(ERR_PART_AND_PRIM, this, &ds_compmod)) return 0;
    
	erule_err.message(ERR_PART_AND_PRIM, erule_current_drawing, this);
	erule_err ERR_INDENT << "Using ." << name() << " from " << 
		  (dsd_ptr->StartPath()).PathName() ERR_NL;
	erule_err ERR_INDENT << "Ignoring ." << extension << " from " <<
	    (ds_compmod.StartPath()).PathName() ERR_NL;

	return 0;
    }

    return check_drawing_collision(ds_compmod);
}





